/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.jvm.Estimator;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e3AAC\u0006\u0001%!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0019I\u0004\u0001)A\u0005u!1!\t\u0001Q\u0001\n\rCaA\u0012\u0001!B\u00139\u0005B\u0002&\u0001A\u0013%1\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003X\u0001\u0011\u0005\u0001LA\u0007XS:$wn^3e\u001b\u0016\fgn\u001d\u0006\u0003\u00195\t1A\u001b<n\u0015\tqq\"A\u0004uo&$H/\u001a:\u000b\u0003A\t1aY8n\u0007\u0001\u00192\u0001A\n\u001a!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0019!dG\u000f\u000e\u0003-I!\u0001H\u0006\u0003\u0013\u0015\u001bH/[7bi>\u0014\bC\u0001\u000b\u001f\u0013\tyRC\u0001\u0004E_V\u0014G.Z\u0001\u0002\u001dB\u0011ACI\u0005\u0003GU\u00111!\u00138u\u0003\u001d9\u0018N\u001c3poN\u00042A\n\u00182\u001d\t9CF\u0004\u0002)W5\t\u0011F\u0003\u0002+#\u00051AH]8pizJ\u0011AF\u0005\u0003[U\tq\u0001]1dW\u0006<W-\u0003\u00020a\t\u00191+Z9\u000b\u00055*\u0002\u0003\u0002\u000b3C\u0005J!aM\u000b\u0003\rQ+\b\u000f\\33\u0003\u0019a\u0014N\\5u}Q\u0019ag\u000e\u001d\u0011\u0005i\u0001\u0001\"\u0002\u0011\u0004\u0001\u0004\t\u0003\"\u0002\u0013\u0004\u0001\u0004)\u0013A\u00038pe6\fG.\u001b>fIB\u00191\bQ!\u000e\u0003qR!!\u0010 \u0002\u0013%lW.\u001e;bE2,'BA \u0016\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003_q\u0002B\u0001\u0006\u001a\u001eC\u0005\u0019!-\u001e4\u0011\u0007Q!U$\u0003\u0002F+\t)\u0011I\u001d:bs\u0006\ta\u000e\u0005\u0002\u0015\u0011&\u0011\u0011*\u0006\u0002\u0005\u0019>tw-\u0001\u0003nK\u0006tGcA\u000fM\u001d\")Qj\u0002a\u0001\u000f\u0006!aM]8n\u0011\u0015yu\u00011\u0001\"\u0003\u0015\u0019w.\u001e8u\u0003\u001diW-Y:ve\u0016$\"AU+\u0011\u0005Q\u0019\u0016B\u0001+\u0016\u0005\u0011)f.\u001b;\t\u000bYC\u0001\u0019A\u000f\u0002\u00035\f\u0001\"Z:uS6\fG/Z\u000b\u0002;\u0001")
public class WindowedMeans
implements Estimator<Object> {
    private final int N;
    private final Seq<Tuple2<Object, Object>> normalized;
    private final double[] buf;
    private long n;

    private double mean(long from, int count) {
        Predef$.MODULE$.require(count <= this.N && count > 0);
        int x = (int)((from - (long)count) % (long)this.N);
        int i = x < 0 ? x + this.N : x;
        int j = (int)(from % (long)this.N);
        double sum = i == j ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(this.buf).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) : (i < j ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.doubleArrayOps(this.buf), i, j)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) : BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.doubleArrayOps(this.buf), i, this.N)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.doubleArrayOps(this.buf), 0, j)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        return sum / (double)count;
    }

    @Override
    public void measure(double m) {
        if (this.n == 0L) {
            Arrays.fill(this.buf, m);
        } else {
            this.buf[(int)(this.n % (long)this.N)] = m;
        }
        ++this.n;
    }

    @Override
    public double estimate() {
        Predef$.MODULE$.require(this.n > 0L);
        Seq weightedMeans = (Seq)this.normalized.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)WindowedMeans.$anonfun$estimate$1(this, x0$1)));
        return BoxesRunTime.unboxToDouble((Object)weightedMeans.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$new$1(WindowedMeans $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int i = tuple2._2$mcI$sp();
        boolean bl = i <= $this.N;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$normalized$1(Tuple2 x0$2) {
        int w;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = w = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ double $anonfun$estimate$1(WindowedMeans $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double w = tuple2._1$mcD$sp();
        int i = tuple2._2$mcI$sp();
        double d = w * $this.mean($this.n, i);
        return d;
    }

    public WindowedMeans(int N, Seq<Tuple2<Object, Object>> windows) {
        this.N = N;
        Predef$.MODULE$.require(windows.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WindowedMeans.$anonfun$new$1(this, x0$1))));
        int sum = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)windows.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)WindowedMeans.$anonfun$normalized$1(x0$2)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.normalized = (Seq)windows.map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int w = tuple2._1$mcI$sp();
            int i = tuple2._2$mcI$sp();
            Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp((double)w / (double)sum, i);
            return sp2;
        });
        this.buf = new double[N];
        this.n = 0L;
    }
}

