/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005I3AAD\b\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003\"\u0001\u0011\u0005!\u0005\u0003\u0004'\u0001\u0001\u0006Ia\n\u0005\u0007[\u0001\u0001\u000b\u0011B\u0014\t\u00139\u0002\u0001\u0019!A!B\u0013Q\u0003BB\u0018\u0001A\u0003&\u0001\u0007\u0003\u00044\u0001\u0001\u0006KA\u000b\u0005\u0006i\u0001!\t!\u000e\u0005\u0007{\u0001\u0001K\u0011\u0002 \t\r}\u0002\u0001\u0015\"\u0003?\u0011\u0015\u0001\u0005\u0001\"\u0001?\u0011\u0019\t\u0005\u0001)C\u0005\u0005\")Q\t\u0001C!\r\n11*\u00197nC:T!\u0001E\t\u0002\u0007)4XN\u0003\u0002\u0013'\u00059Ao^5ui\u0016\u0014(\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-A\u0001O!\tAr$\u0003\u0002!3\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\tq\u0002C\u0003\u001e\u0005\u0001\u0007a$\u0001\u0003nEV4\u0007c\u0001\r)U%\u0011\u0011&\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00031-J!\u0001L\r\u0003\r\u0011{WO\u00197f\u0003\u0011)'-\u001e4\u0002\u0007\u0015\u001cH/A\u0001o!\tA\u0012'\u0003\u000233\t!Aj\u001c8h\u0003\u00199X-[4ii\u00069Q.Z1tkJ,Gc\u0001\u001c:wA\u0011\u0001dN\u0005\u0003qe\u0011A!\u00168ji\")!\b\u0003a\u0001U\u0005\tQ\u000eC\u0003=\u0011\u0001\u0007!&A\u0001f\u0003\u0011ig/\u0019:\u0016\u0003)\nA!\u001a<be\u0006AQm\u001d;j[\u0006$X-\u0001\u0005wCJL\u0017M\\2f)\tQ3\tC\u0003E\u0019\u0001\u0007q%A\u0004tC6\u0004H.Z:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0012\t\u0003\u0011>s!!S'\u0011\u0005)KR\"A&\u000b\u00051+\u0012A\u0002\u001fs_>$h(\u0003\u0002O3\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0015\u0004")
public class Kalman {
    private final int N;
    private final double[] mbuf;
    private final double[] ebuf;
    private double est;
    private long n;
    private double weight;

    public void measure(double m, double e) {
        double ev;
        int i = (int)(this.n % (long)this.N);
        this.mbuf[i] = m;
        this.ebuf[i] = e;
        if (this.n == 0L) {
            this.est = m;
        }
        this.est += this.weight * (m - this.est);
        double mv = this.mvar();
        this.weight = mv + (ev = this.evar()) == 0.0 ? 1.0 : mv / (mv + ev);
        ++this.n;
    }

    private double mvar() {
        return this.variance(this.n < (long)this.N ? (double[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.doubleArrayOps(this.mbuf), (int)this.n) : this.mbuf);
    }

    private double evar() {
        return this.variance(this.n < (long)this.N ? (double[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.doubleArrayOps(this.ebuf), (int)this.n) : this.ebuf);
    }

    public double estimate() {
        return this.est;
    }

    private double variance(double[] samples) {
        if (samples.length == 1) {
            return 0.0;
        }
        double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(samples).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double mean = sum / (double)samples.length;
        double diff = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(samples), (Function1)(JFunction1.mcDD.sp & Serializable)x -> (x - mean) * (x - mean), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return diff / (double)(samples.length - 1);
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Kalman<estimate=%f, weight=%f, mvar=%f, evar=%f>"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.estimate()), BoxesRunTime.boxToDouble((double)this.weight), BoxesRunTime.boxToDouble((double)this.mvar()), BoxesRunTime.boxToDouble((double)this.evar())}));
    }

    public Kalman(int N) {
        this.N = N;
        this.mbuf = new double[N];
        this.ebuf = new double[N];
        this.n = 0L;
        this.weight = 0.9;
    }
}

