/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.AbstractOpenApiSchema;
import com.twitter.clientlib.model.Error;
import com.twitter.clientlib.model.Problem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class ProblemOrError
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ProblemOrError.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public ProblemOrError() {
        super("oneOf", Boolean.FALSE);
    }

    public ProblemOrError(Error o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public ProblemOrError(Problem o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof Error) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof Problem) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be Error, Problem");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public Error getError() throws ClassCastException {
        return (Error)super.getActualInstance();
    }

    public Problem getProblem() throws ClassCastException {
        return (Problem)super.getActualInstance();
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            Error.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for Error failed with `%s`.", e.getMessage()));
        }
        try {
            Problem.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for Problem failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for ProblemOrError with oneOf schemas: Error, Problem. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonObj.toString()));
        }
    }

    public static ProblemOrError fromJson(String jsonString) throws IOException {
        return (ProblemOrError)JSON.getGson().fromJson(jsonString, ProblemOrError.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("Error", (GenericType)new GenericType<Error>(){});
        schemas.put("Problem", (GenericType)new GenericType<Problem>(){});
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ProblemOrError.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterError = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Error.class));
            final TypeAdapter adapterProblem = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Problem.class));
            return new TypeAdapter<ProblemOrError>(){

                public void write(JsonWriter out, ProblemOrError value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof Error) {
                        JsonObject obj = adapterError.toJsonTree((Object)((Error)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    if (value.getActualInstance() instanceof Problem) {
                        JsonObject obj = adapterProblem.toJsonTree((Object)((Problem)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: Error, Problem");
                }

                public ProblemOrError read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonObject jsonObject = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        Error.validateJsonObject(jsonObject);
                        actualAdapter = adapterError;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'Error'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for Error failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'Error'", e);
                    }
                    try {
                        Problem.validateJsonObject(jsonObject);
                        actualAdapter = adapterProblem;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'Problem'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for Problem failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'Problem'", e);
                    }
                    if (match == 1) {
                        ProblemOrError ret = new ProblemOrError();
                        ret.setActualInstance(actualAdapter.fromJsonTree((JsonElement)jsonObject));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for ProblemOrError: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonObject.toString()));
                }
            }.nullSafe();
        }
    }
}

