/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.twitter.clientlib.JSON;

/**
 * Represents the data for the annotation.
 */
@ApiModel(description = "Represents the data for the annotation.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class FullTextEntitiesAnnotationsAllOf {
  public static final String SERIALIZED_NAME_NORMALIZED_TEXT = "normalized_text";
  @SerializedName(SERIALIZED_NAME_NORMALIZED_TEXT)
  private String normalizedText;

  public static final String SERIALIZED_NAME_PROBABILITY = "probability";
  @SerializedName(SERIALIZED_NAME_PROBABILITY)
  private Double probability;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public FullTextEntitiesAnnotationsAllOf() { 
  }

  public FullTextEntitiesAnnotationsAllOf normalizedText(String normalizedText) {
    
    this.normalizedText = normalizedText;
    return this;
  }

   /**
   * Text used to determine annotation.
   * @return normalizedText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Barack Obama", value = "Text used to determine annotation.")

  public String getNormalizedText() {
    return normalizedText;
  }


  public void setNormalizedText(String normalizedText) {
    this.normalizedText = normalizedText;
  }


  public FullTextEntitiesAnnotationsAllOf probability(Double probability) {
    
    this.probability = probability;
    return this;
  }

   /**
   * Confidence factor for annotation type.
   * minimum: 0
   * maximum: 1
   * @return probability
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Confidence factor for annotation type.")

  public Double getProbability() {
    return probability;
  }


  public void setProbability(Double probability) {
    this.probability = probability;
  }


  public FullTextEntitiesAnnotationsAllOf type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Annotation type.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Person", value = "Annotation type.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FullTextEntitiesAnnotationsAllOf fullTextEntitiesAnnotationsAllOf = (FullTextEntitiesAnnotationsAllOf) o;
    return Objects.equals(this.normalizedText, fullTextEntitiesAnnotationsAllOf.normalizedText) &&
        Objects.equals(this.probability, fullTextEntitiesAnnotationsAllOf.probability) &&
        Objects.equals(this.type, fullTextEntitiesAnnotationsAllOf.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(normalizedText, probability, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FullTextEntitiesAnnotationsAllOf {\n");
    sb.append("    normalizedText: ").append(toIndentedString(normalizedText)).append("\n");
    sb.append("    probability: ").append(toIndentedString(probability)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("normalized_text");
    openapiFields.add("probability");
    openapiFields.add("type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FullTextEntitiesAnnotationsAllOf
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
     // if (jsonObj == null) {
     //   if (FullTextEntitiesAnnotationsAllOf.openapiRequiredFields.isEmpty()) {
     //     return;
     //   } else { // has required fields
     //     throw new IllegalArgumentException(String.format("The required field(s) %s in FullTextEntitiesAnnotationsAllOf is not found in the empty JSON string", FullTextEntitiesAnnotationsAllOf.openapiRequiredFields.toString()));
     //   }
     // }

      if (jsonObj.get("normalized_text") != null && !jsonObj.get("normalized_text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `normalized_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("normalized_text").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FullTextEntitiesAnnotationsAllOf.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FullTextEntitiesAnnotationsAllOf' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FullTextEntitiesAnnotationsAllOf> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FullTextEntitiesAnnotationsAllOf.class));

       return (TypeAdapter<T>) new TypeAdapter<FullTextEntitiesAnnotationsAllOf>() {
           @Override
           public void write(JsonWriter out, FullTextEntitiesAnnotationsAllOf value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FullTextEntitiesAnnotationsAllOf read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FullTextEntitiesAnnotationsAllOf given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FullTextEntitiesAnnotationsAllOf
  * @throws IOException if the JSON string is invalid with respect to FullTextEntitiesAnnotationsAllOf
  */
  public static FullTextEntitiesAnnotationsAllOf fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FullTextEntitiesAnnotationsAllOf.class);
  }

 /**
  * Convert an instance of FullTextEntitiesAnnotationsAllOf to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

