/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack;

import java.io.IOException;
import java.io.OutputStream;

final class HuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;

    public HuffmanEncoder(int[] codes, byte[] lengths) {
        this.codes = codes;
        this.lengths = lengths;
    }

    public void encode(byte[] data, OutputStream out) throws IOException {
        long current = 0L;
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            int b = data[i] & 0xFF;
            int code = this.codes[b];
            byte nbits = this.lengths[b];
            current <<= nbits;
            current |= (long)code;
            n += nbits;
            while (n >= 8) {
                out.write((int)(current >> (n -= 8)));
            }
        }
        if (n > 0) {
            current <<= 8 - n;
            out.write((int)(current |= (long)(255 >>> n)));
        }
    }

    public int getEncodedLength(byte[] bytes) {
        long len = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            len += (long)this.lengths[b];
        }
        return (int)(len + 7L >> 3);
    }
}

