/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import scala.Predef$;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u001b\t\t2i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\r!\u0011!B2pI\u0016\u001c'BA\u0003\u0007\u0003\u0011AG\u000f\u001e9\u000b\u0005\u001dA\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u0013)\tq\u0001^<jiR,'OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001\u0003\u0004#\u0001\u0001\u0006KaI\u0001\fSN\\U-\u001a9BY&4X\r\u0005\u0002\u0018I%\u0011Q\u0005\u0007\u0002\b\u0005>|G.Z1o\u0011\u00199\u0003\u0001)Q\u0005G\u00051\u0011n]%eY\u0016DQ!\u000b\u0001\u0005\u0002)\nab\u001c2tKJ4X-T3tg\u0006<W\r\u0006\u0002,]A\u0011q\u0003L\u0005\u0003[a\u0011A!\u00168ji\")q\u0006\u000ba\u0001a\u00059Q.Z:tC\u001e,\u0007CA\f2\u0013\t\u0011\u0004D\u0001\u0004B]f\u0014VM\u001a\u0005\u0006i\u0001!\t!N\u0001\u000f_\n\u001cXM\u001d<f%\u0016\fX/Z:u)\tYc\u0007C\u00038g\u0001\u0007\u0001(A\u0004sKF,Xm\u001d;\u0011\u0005e\"U\"\u0001\u001e\u000b\u0005\u0015Y$BA\u0002=\u0015\tid(A\u0004iC:$G.\u001a:\u000b\u0005}\u0002\u0015!\u00028fiRL(BA!C\u0003\u0015Q'm\\:t\u0015\u0005\u0019\u0015aA8sO&\u0011QI\u000f\u0002\f\u0011R$\bOU3rk\u0016\u001cH\u000fC\u0003H\u0001\u0011\u0005\u0001*A\bpEN,'O^3SKN\u0004xN\\:f)\tY\u0013\nC\u0003K\r\u0002\u00071*\u0001\u0005sKN\u0004xN\\:f!\tID*\u0003\u0002Nu\ta\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\")q\n\u0001C\u0001!\u0006aqNY:feZ,7\t[;oWR\u00111&\u0015\u0005\u0006%:\u0003\raU\u0001\u0006G\",hn\u001b\t\u0003sQK!!\u0016\u001e\u0003\u0013!#H\u000f]\"ik:\\\u0007\"B,\u0001\t\u0003A\u0016aC:i_VdGm\u00117pg\u0016$\u0012a\t")
public class ConnectionManager
implements ScalaObject {
    private boolean isKeepAlive = false;
    private boolean isIdle = true;

    public void observeMessage(Object message) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            BoxedUnit boxedUnit;
            Object object = message;
            if (object instanceof HttpRequest) {
                this.observeRequest((HttpRequest)object);
                boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof HttpResponse) {
                this.observeResponse((HttpResponse)object);
                boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof HttpChunk) {
                this.observeChunk((HttpChunk)object);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.isKeepAlive = false;
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void observeRequest(HttpRequest request) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.isIdle = false;
            this.isKeepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
            return;
        }
    }

    public void observeResponse(HttpResponse response) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (response.isChunked() || response.containsHeader("Content-Length")) {
                if (!HttpHeaders.isKeepAlive((HttpMessage)response)) {
                    this.isKeepAlive = false;
                }
            } else {
                this.isKeepAlive = false;
            }
            this.isIdle = !response.isChunked();
            return;
        }
    }

    public void observeChunk(HttpChunk chunk) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Predef$.MODULE$.require(!this.isIdle);
            this.isIdle = chunk.isLast();
            return;
        }
    }

    public boolean shouldClose() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Boolean bl = BoxesRunTime.boxToBoolean((this.isIdle && !this.isKeepAlive ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }
}

