/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http2.transport.server;

import com.twitter.finagle.http2.transport.server.H2ServerFilter$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.Timer;
import com.twitter.util.TimerTask;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005q4QAD\b\u0003'mA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0007g\u0001\u0001\u000b\u0015\u0002\u001b\t\u000by\u0002A\u0011A \t\u000b\u0015\u0003A\u0011\t$\t\u000bY\u0003A\u0011I,\b\ry{\u0001\u0012A\n`\r\u0019qq\u0002#\u0001\u0014A\")a\u0006\u0003C\u0001I\"9Q\r\u0003b\u0001\n\u00131\u0007BB7\tA\u0003%q\rC\u0004o\u0011\t\u0007I\u0011A8\t\rmD\u0001\u0015!\u0003q\u00059A%gU3sm\u0016\u0014h)\u001b7uKJT!\u0001E\t\u0002\rM,'O^3s\u0015\t\u00112#A\u0005ue\u0006t7\u000f]8si*\u0011A#F\u0001\u0006QR$\bO\r\u0006\u0003-]\tqAZ5oC\u001edWM\u0003\u0002\u00193\u00059Ao^5ui\u0016\u0014(\"\u0001\u000e\u0002\u0007\r|Wn\u0005\u0002\u00019A\u0011Q\u0004J\u0007\u0002=)\u0011q\u0004I\u0001\bG\"\fgN\\3m\u0015\t\t#%A\u0003oKR$\u0018PC\u0001$\u0003\tIw.\u0003\u0002&=\t!2\t[1o]\u0016dG)\u001e9mKbD\u0015M\u001c3mKJ\fQ\u0001^5nKJ\u001c\u0001\u0001\u0005\u0002*Y5\t!F\u0003\u0002,/\u0005!Q\u000f^5m\u0013\ti#FA\u0003US6,'/\u0001\u0004=S:LGO\u0010\u000b\u0003aI\u0002\"!\r\u0001\u000e\u0003=AQA\n\u0002A\u0002!\nQb\u00197pg\u0016$U-\u00193mS:,\u0007CA\u00156\u0013\t1$F\u0001\u0003US6,\u0007FA\u00029!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005!1x\u000e\\1uS2,\u0017aC:fi\u0012+\u0017\r\u001a7j]\u0016$\"\u0001Q\"\u0011\u0005e\n\u0015B\u0001\";\u0005\u0011)f.\u001b;\t\u000b\u0011#\u0001\u0019\u0001\u001b\u0002\u0011\u0011,\u0017\r\u001a7j]\u0016\f1b\u00195b]:,GNU3bIR\u0019\u0001i\u0012'\t\u000b!+\u0001\u0019A%\u0002\u0007\r$\b\u0010\u0005\u0002\u001e\u0015&\u00111J\b\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u0015iU\u00011\u0001O\u0003\ri7o\u001a\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000bA\u0001\\1oO*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u0019y%M[3di\u0006)1\r\\8tKR\u0019\u0001\tW-\t\u000b!3\u0001\u0019A%\t\u000bi3\u0001\u0019A.\u0002\u000fA\u0014x.\\5tKB\u0011Q\u0004X\u0005\u0003;z\u0011ab\u00115b]:,G\u000e\u0015:p[&\u001cX-\u0001\bIeM+'O^3s\r&dG/\u001a:\u0011\u0005EB1C\u0001\u0005b!\tI$-\u0003\u0002du\t1\u0011I\\=SK\u001a$\u0012aX\u0001\u0007Y><w-\u001a:\u0016\u0003\u001d\u0004\"\u0001[6\u000e\u0003%T!A[\f\u0002\u000f1|wmZ5oO&\u0011A.\u001b\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005Y\u0001*\u00198eY\u0016\u0014h*Y7f+\u0005\u0001\bCA9y\u001d\t\u0011h\u000f\u0005\u0002tu5\tAO\u0003\u0002vO\u00051AH]8pizJ!a\u001e\u001e\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003oj\nA\u0002S1oI2,'OT1nK\u0002\u0002")
public final class H2ServerFilter
extends ChannelDuplexHandler {
    private final Timer timer;
    private volatile Time closeDeadline;

    public static String HandlerName() {
        return H2ServerFilter$.MODULE$.HandlerName();
    }

    public void setDeadline(Time deadline) {
        this.closeDeadline = deadline;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof Http2Frame) {
            Http2Frame http2Frame = (Http2Frame)object;
            ReferenceCountUtil.release((Object)http2Frame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.channelRead(ctx, msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
        if (connectionHandler == null) {
            String message = new StringBuilder(0).append("Found H2ServerFilter in a pipeline without a Http2ConnectionHandler. ").append(new StringBuilder(10).append("Pipeline: ").append(ctx.pipeline()).toString()).toString();
            IllegalStateException ex = new IllegalStateException(message);
            H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().error((Throwable)ex, message, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.close(promise);
        } else {
            Time deadline = this.closeDeadline;
            Time now = Time$.MODULE$.now();
            if (deadline.$less$eq((Object)now)) {
                connectionHandler.gracefulShutdownTimeoutMillis(0L);
                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().debug(new StringBuilder(44).append("Deadline already passed (").append(deadline).append(" <= ").append(now).append("). Closing now.").toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                super.close(ctx, promise);
            } else {
                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().info(new StringBuilder(33).append("Closing h2 session with deadline ").append(deadline).toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                DefaultHttp2GoAwayFrame goawayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
                goawayFrame.setExtraStreamIds(Integer.MAX_VALUE);
                AtomicBoolean promiseOnce = new AtomicBoolean();
                ctx.writeAndFlush((Object)goawayFrame).addListener((GenericFutureListener)new ChannelFutureListener(null, promiseOnce, ctx, promise){
                    private final AtomicBoolean promiseOnce$1;
                    private final ChannelHandlerContext ctx$1;
                    private final ChannelPromise promise$1;

                    public void operationComplete(ChannelFuture future) {
                        block0: {
                            if (future.isSuccess() || !this.promiseOnce$1.compareAndSet(false, true)) break block0;
                            this.ctx$1.close(this.promise$1);
                        }
                    }
                    {
                        this.promiseOnce$1 = promiseOnce$1;
                        this.ctx$1 = ctx$1;
                        this.promise$1 = promise$1;
                    }
                });
                TimerTask closeTask = this.timer.schedule(deadline, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    block0: {
                        if (!promiseOnce.compareAndSet(false, true)) break block0;
                        ctx.channel().eventLoop().execute(new Runnable(null, ctx, promise){
                            public final ChannelHandlerContext ctx$1;
                            public final ChannelPromise promise$1;

                            public void run() {
                                H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().info("Graceful draining period lapsed. Sending final GOAWAY and closing the connection.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                                this.ctx$1.writeAndFlush((Object)new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR)).addListener((GenericFutureListener)new ChannelFutureListener(this){
                                    private final /* synthetic */ $anon$2 $outer;

                                    public void operationComplete(ChannelFuture future) {
                                        this.$outer.ctx$1.close(this.$outer.promise$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.ctx$1 = ctx$1;
                                this.promise$1 = promise$1;
                            }
                        });
                    }
                });
                ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(null, closeTask, promiseOnce, promise){
                    private final TimerTask closeTask$1;
                    private final AtomicBoolean promiseOnce$1;
                    private final ChannelPromise promise$1;

                    public void operationComplete(ChannelFuture future) {
                        block0: {
                            this.closeTask$1.cancel();
                            if (!this.promiseOnce$1.compareAndSet(false, true)) break block0;
                            H2ServerFilter$.MODULE$.com$twitter$finagle$http2$transport$server$H2ServerFilter$$logger().info("Channel closed, session terminated.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                            this.promise$1.setSuccess();
                        }
                    }
                    {
                        this.closeTask$1 = closeTask$1;
                        this.promiseOnce$1 = promiseOnce$1;
                        this.promise$1 = promise$1;
                    }
                });
            }
        }
    }

    public H2ServerFilter(Timer timer) {
        this.timer = timer;
        this.closeDeadline = Time$.MODULE$.Bottom();
    }
}

