/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.headers;

import com.twitter.finagle.http.headers.Rfc7230HeaderValidation;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$CR$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$LF$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$NonFold$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$ObsFoldDetected$;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation$ValidationSuccess$;
import java.io.Serializable;
import java.util.BitSet;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class Rfc7230HeaderValidation$ {
    public static final Rfc7230HeaderValidation$ MODULE$ = new Rfc7230HeaderValidation$();
    private static final Regex ObsFoldRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\r?\n[\t ]+"));
    private static final BitSet validHeaderNameCharSet = MODULE$.toBitSet(MODULE$.validHeaderNameChars());
    private static final BitSet validHeaderValueCharSet = MODULE$.toBitSet(MODULE$.validHeaderValueChars());

    private Iterable<Object> validHeaderNameChars() {
        return ((List)((IterableOps)((IterableOps)Predef$.MODULE$.wrapString("!#$%&'*+-.^_`|~").toList().$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')))).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToChar((Object)x$1)));
    }

    private Iterable<Object> validHeaderValueChars() {
        return (Iterable)((IterableOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(33), 126).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(128), 255))).$plus$plus((IterableOnce)StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString("\r\n \t"), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToChar((Object)x$2))));
    }

    /*
     * WARNING - void declaration
     */
    private BitSet toBitSet(Iterable<Object> valid) {
        void var2_2;
        BitSet bitSet = new BitSet();
        valid.foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> bitSet.set(x$1));
        return var2_2;
    }

    private boolean validHeaderNameChar(char c) {
        return validHeaderNameCharSet.get(c);
    }

    private boolean validHeaderValueChar(char c) {
        return validHeaderValueCharSet.get(c);
    }

    public String replaceObsFold(CharSequence value) {
        return ObsFoldRegex.replaceAllIn(value, " ");
    }

    public Rfc7230HeaderValidation.NameValidationResult validateName(CharSequence name) {
        Rfc7230HeaderValidation.NameValidationResult nameValidationResult;
        if (name == null) {
            throw new NullPointerException("Header names cannot be null");
        }
        if (name.length() == 0) {
            nameValidationResult = new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.NameValidationException("Header name cannot be empty"));
        } else {
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (this.validHeaderNameChar(c)) continue;
                return new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.NameValidationException(new StringBuilder(0).append(new StringBuilder(62).append("Header '").append(name).append("': name cannot contain the prohibited character '0x").append(Integer.toHexString(c)).append("': ").toString()).append(c).toString()));
            }
            nameValidationResult = Rfc7230HeaderValidation$ValidationSuccess$.MODULE$;
        }
        return nameValidationResult;
    }

    public Rfc7230HeaderValidation.ValueValidationResult validateValue(CharSequence name, CharSequence value) {
        Product product;
        if (value == null) {
            throw new NullPointerException("Header values cannot be null");
        }
        Product state = Rfc7230HeaderValidation$NonFold$.MODULE$;
        boolean foldDetected = false;
        for (int i = 0; i < value.length(); ++i) {
            BoxedUnit boxedUnit;
            char c = value.charAt(i);
            if (!this.validHeaderValueChar(c)) {
                return new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.ValueValidationException(new StringBuilder(55).append("Header '").append(name).append("': value contains a prohibited character '0x").append(Integer.toHexString(c)).append("': ").append(c).toString()));
            }
            Rfc7230HeaderValidation$NonFold$ rfc7230HeaderValidation$NonFold$ = state;
            if (Rfc7230HeaderValidation$NonFold$.MODULE$.equals(rfc7230HeaderValidation$NonFold$)) {
                BoxedUnit boxedUnit2;
                if (c == '\r') {
                    state = Rfc7230HeaderValidation$CR$.MODULE$;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (c == '\n') {
                    state = Rfc7230HeaderValidation$LF$.MODULE$;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            if (Rfc7230HeaderValidation$CR$.MODULE$.equals(rfc7230HeaderValidation$NonFold$)) {
                if (c != '\n') {
                    return new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.ValueValidationException(new StringBuilder(51).append("Header '").append(name).append("': only '\\n' is allowed after '\\r' in value").toString()));
                }
                state = Rfc7230HeaderValidation$LF$.MODULE$;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (Rfc7230HeaderValidation$LF$.MODULE$.equals(rfc7230HeaderValidation$NonFold$)) {
                if (c != '\t' && c != ' ') {
                    return new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.ValueValidationException(new StringBuilder(60).append("Header '").append(name).append("': only ' ' and '\\t' are allowed after '\\n' in value").toString()));
                }
                foldDetected = true;
                state = Rfc7230HeaderValidation$NonFold$.MODULE$;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)rfc7230HeaderValidation$NonFold$);
        }
        Rfc7230HeaderValidation$NonFold$ rfc7230HeaderValidation$NonFold$ = state;
        Rfc7230HeaderValidation$NonFold$ rfc7230HeaderValidation$NonFold$2 = Rfc7230HeaderValidation$NonFold$.MODULE$;
        if (rfc7230HeaderValidation$NonFold$ == null ? rfc7230HeaderValidation$NonFold$2 != null : !rfc7230HeaderValidation$NonFold$.equals(rfc7230HeaderValidation$NonFold$2)) {
            Product product2 = state;
            Rfc7230HeaderValidation$CR$ rfc7230HeaderValidation$CR$ = Rfc7230HeaderValidation$CR$.MODULE$;
            String string = !(product2 != null ? !product2.equals(rfc7230HeaderValidation$CR$) : rfc7230HeaderValidation$CR$ != null) ? "\\r" : "\\n";
            product = new Rfc7230HeaderValidation.ValidationFailure(new Rfc7230HeaderValidation.ValueValidationException(new StringBuilder(0).append(new StringBuilder(59).append("Header '").append(name).append("': value must not end with '\\r' or '\\n'. Observed: ").toString()).append((Object)string).toString()));
        } else {
            product = foldDetected ? Rfc7230HeaderValidation$ObsFoldDetected$.MODULE$ : Rfc7230HeaderValidation$ValidationSuccess$.MODULE$;
        }
        return product;
    }

    private Rfc7230HeaderValidation$() {
    }
}

