/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.codec;

import com.twitter.finagle.http.Message;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.Status$Informational$;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000514Q\u0001E\t\u0001+mAQA\t\u0001\u0005\u0002\u0011Baa\n\u0001!B\u0013A\u0003BB\u0016\u0001A\u0003&\u0001\u0006\u0003\u0004-\u0001\u0001\u0006K!\f\u0005\u0007a\u0001\u0001\u000b\u0015B\u0017\t\rE\u0002\u0001\u0015!\u00033\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0019A\u0005\u0001)C\u0005\u0013\"1\u0001\u000b\u0001Q\u0005\nECa\u0001\u0017\u0001!\n\u0013I\u0006BB.\u0001A\u0013%A\fC\u0003^\u0001\u0011\u0005a\fC\u0003`\u0001\u0011\u0005\u0001\r\u0003\u0004b\u0001\u0001&IA\u0019\u0005\u0007K\u0002\u0001K\u0011\u00024\u0003-!#H\u000f]\u0019D_:tWm\u0019;j_:l\u0015M\\1hKJT!AE\n\u0002\u000b\r|G-Z2\u000b\u0005Q)\u0012\u0001\u00025uiBT!AF\f\u0002\u000f\u0019Lg.Y4mK*\u0011\u0001$G\u0001\bi^LG\u000f^3s\u0015\u0005Q\u0012aA2p[N\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\n\t\u0003M\u0001i\u0011!E\u0001\fSN\\U-\u001a9BY&4X\r\u0005\u0002\u001eS%\u0011!F\b\u0002\b\u0005>|G.Z1o\u0003\u0019I7/\u00133mK\u0006i\u0011m\u0019;jm\u0016\u001cFO]3b[N\u0004\"!\b\u0018\n\u0005=r\"aA%oi\u0006\u0001\u0002/\u001a8eS:<'+Z:q_:\u001cXm]\u0001\u0007G2|7/\u001a)\u0011\u0007M2\u0004(D\u00015\u0015\t)t#\u0001\u0003vi&d\u0017BA\u001c5\u0005\u001d\u0001&o\\7jg\u0016\u0004\"!H\u001d\n\u0005ir\"\u0001B+oSR\fab\u001c2tKJ4X-T3tg\u0006<W\rF\u00029{\rCQAP\u0004A\u0002}\nq!\\3tg\u0006<W\r\u0005\u0002A\u00036\t1#\u0003\u0002C'\t9Q*Z:tC\u001e,\u0007\"\u0002#\b\u0001\u0004)\u0015\u0001C8o\r&t\u0017n\u001d5\u0011\u0007M2\u0005(\u0003\u0002Hi\t1a)\u001e;ve\u0016\fab\u001c2tKJ4XMU3rk\u0016\u001cH\u000fF\u00029\u0015>CQa\u0013\u0005A\u00021\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002A\u001b&\u0011aj\u0005\u0002\b%\u0016\fX/Z:u\u0011\u0015!\u0005\u00021\u0001F\u0003=y'm]3sm\u0016\u0014Vm\u001d9p]N,Gc\u0001\u001dS/\")1+\u0003a\u0001)\u0006A!/Z:q_:\u001cX\r\u0005\u0002A+&\u0011ak\u0005\u0002\t%\u0016\u001c\bo\u001c8tK\")A)\u0003a\u0001\u000b\u0006q\u0001.\u00198eY\u0016Lem\u0015;sK\u0006lGC\u0001\u001d[\u0011\u0015!%\u00021\u0001F\u0003%)g\u000eZ*ue\u0016\fW\u000eF\u00019\u0003-\u0019\bn\\;mI\u000ecwn]3\u0016\u0003!\nqa\u001c8DY>\u001cX-F\u0001F\u0003EiWo\u001d;DY>\u001cXm\u00148GS:L7\u000f\u001b\u000b\u0003Q\rDQ\u0001\u001a\bA\u0002Q\u000bAA]3ta\u0006qQ.Y=ICZ,7i\u001c8uK:$HC\u0001\u0015h\u0011\u0015Aw\u00021\u0001j\u0003\u0019\u0019H/\u0019;vgB\u0011\u0001I[\u0005\u0003WN\u0011aa\u0015;biV\u001c\b")
public class Http1ConnectionManager {
    private boolean isKeepAlive = true;
    private boolean isIdle = true;
    private int activeStreams = 0;
    private int pendingResponses = 0;
    private final Promise<BoxedUnit> closeP = new Promise();

    public synchronized void observeMessage(Message message, Future<BoxedUnit> onFinish) {
        Message message2 = message;
        if (message2 instanceof Request) {
            Request request = (Request)message2;
            this.observeRequest(request, onFinish);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (message2 instanceof Response) {
            Response response = (Response)message2;
            this.observeResponse(response, onFinish);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.isKeepAlive = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private synchronized void observeRequest(Request request, Future<BoxedUnit> onFinish) {
        ++this.pendingResponses;
        this.isIdle = false;
        this.isKeepAlive = request.keepAlive();
        this.handleIfStream(onFinish);
    }

    private synchronized void observeResponse(Response response, Future<BoxedUnit> onFinish) {
        --this.pendingResponses;
        if (!this.isKeepAlive || this.mustCloseOnFinish(response) || !response.keepAlive()) {
            response.headerMap().setUnsafe("Connection", "close");
            this.isKeepAlive = false;
        }
        this.isIdle = !response.isChunked();
        this.handleIfStream(onFinish);
    }

    private void handleIfStream(Future<BoxedUnit> onFinish) {
        block1: {
            block0: {
                if (onFinish.isDefined()) break block0;
                ++this.activeStreams;
                onFinish.ensure((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    block0: {
                        this.endStream();
                        if (!this.shouldClose()) break block0;
                        $this.closeP.setDone((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    }
                });
                break block1;
            }
            if (!this.shouldClose()) break block1;
            this.closeP.setDone((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
    }

    private synchronized void endStream() {
        --this.activeStreams;
        this.isIdle = this.activeStreams == 0 && this.pendingResponses == 0;
    }

    public synchronized boolean shouldClose() {
        return this.isIdle && !this.isKeepAlive;
    }

    public Future<BoxedUnit> onClose() {
        return this.closeP;
    }

    private boolean mustCloseOnFinish(Response resp) {
        return this.mayHaveContent(resp.status()) && !resp.isChunked() && !resp.headerMap().contains("Content-Length");
    }

    private boolean mayHaveContent(Status status) {
        boolean bl;
        Option<Status> option;
        Status status2 = status;
        if (status2 != null && !(option = Status$Informational$.MODULE$.unapply(status2)).isEmpty()) {
            bl = false;
        } else {
            Status status3 = Status$.MODULE$.NoContent();
            Status status4 = status2;
            if (!(status3 != null ? !((Object)status3).equals(status4) : status4 != null)) {
                bl = false;
            } else {
                Status status5 = Status$.MODULE$.NotModified();
                Status status6 = status2;
                bl = status5 != null ? !((Object)status5).equals(status6) : status6 != null;
            }
        }
        return bl;
    }
}

