/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.examples;

import com.twitter.elephantbird.examples.thrift.Age;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.ThriftConverter;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.mapreduce.output.LzoThriftB64LineOutputFormat;
import com.twitter.elephantbird.mapreduce.output.LzoThriftBlockOutputFormat;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class ThriftMRExample {
    private ThriftMRExample() {
    }

    public int runTextToLzo(String[] args, Configuration conf) throws Exception {
        Job job = new Job(conf);
        job.setJobName("Thrift Example : Text to LzoB64Line");
        job.setJarByClass(this.getClass());
        job.setMapperClass(TextMapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(TextInputFormat.class);
        if (conf.get("thrift.test.format", "B64Line").equals("Block")) {
            LzoThriftBlockOutputFormat.setClassConf(Age.class, (Configuration)job.getConfiguration());
            job.setOutputFormatClass(LzoThriftBlockOutputFormat.class);
        } else {
            LzoThriftB64LineOutputFormat.setClassConf(Age.class, (Configuration)job.getConfiguration());
            job.setOutputFormatClass(LzoThriftB64LineOutputFormat.class);
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public int runLzoToText(String[] args, Configuration conf) throws Exception {
        Job job = new Job(conf);
        job.setJobName("Thrift Example : LzoB64Line to Text");
        job.setJarByClass(this.getClass());
        job.setMapperClass(LzoMapper.class);
        job.setNumReduceTasks(0);
        MultiInputFormat.setInputFormatClass(Age.class, (Job)job);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    int runSorter(String[] args, Configuration conf) throws Exception {
        Job job = new Job(conf);
        job.setJobName("Thift Example : ThriftWritable as Map output class");
        job.setJarByClass(this.getClass());
        job.setMapperClass(SortMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(ThriftWritable.class);
        job.setReducerClass(SortReducer.class);
        job.setNumReduceTasks(1);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        String test;
        Configuration conf = new Configuration();
        args = new GenericOptionsParser(conf, args).getRemainingArgs();
        ThriftMRExample runner = new ThriftMRExample();
        if (args.length != 2) {
            System.out.println("Usage: hadoop jar path/to/this.jar " + runner.getClass() + " <input dir> <output dir>");
            System.exit(1);
        }
        if ((test = conf.get("thrift.test", "lzoIn")).equals("lzoIn")) {
            System.exit(runner.runLzoToText(args, conf));
        }
        if (test.equals("lzoOut")) {
            System.exit(runner.runTextToLzo(args, conf));
        }
        if (test.equals("sort")) {
            System.exit(runner.runSorter(args, conf));
        }
    }

    public static class SortReducer
    extends Reducer<Text, ThriftWritable<Age>, Text, Text> {
        ThriftConverter<Age> converter = ThriftConverter.newInstance(Age.class);

        protected void reduce(Text key, Iterable<ThriftWritable<Age>> values, Reducer.Context context) throws IOException, InterruptedException {
            for (ThriftWritable<Age> value : values) {
                value.setConverter(this.converter);
                context.write(null, (Object)new Text(((Age)value.get()).getName() + "\t" + ((Age)value.get()).getAge()));
            }
        }
    }

    public static class SortMapper
    extends Mapper<LongWritable, Text, Text, ThriftWritable<Age>> {
        ThriftWritable<Age> tWritable = ThriftWritable.newInstance(Age.class);
        Age age = new Age();

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer line = new StringTokenizer(value.toString(), "\t\r\n");
            if (line.hasMoreTokens() && this.age.setName(line.nextToken()) != null && line.hasMoreTokens() && this.age.setAge(Integer.parseInt(line.nextToken())) != null) {
                this.tWritable.set((Object)this.age);
                context.write((Object)new Text(this.age.getName()), this.tWritable);
            }
        }
    }

    public static class LzoMapper
    extends Mapper<LongWritable, ThriftWritable<Age>, Text, Text> {
        protected void map(LongWritable key, ThriftWritable<Age> value, Mapper.Context context) throws IOException, InterruptedException {
            Age age = (Age)value.get();
            context.write(null, (Object)new Text(age.getName() + "\t" + age.getAge()));
        }
    }

    public static class TextMapper
    extends Mapper<LongWritable, Text, NullWritable, ThriftWritable<Age>> {
        ThriftWritable<Age> tWritable = ThriftWritable.newInstance(Age.class);
        Age age = new Age();

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer line = new StringTokenizer(value.toString(), "\t\r\n");
            if (line.hasMoreTokens() && this.age.setName(line.nextToken()) != null && line.hasMoreTokens() && this.age.setAge(Integer.parseInt(line.nextToken())) != null) {
                this.tWritable.set((Object)this.age);
                context.write(null, this.tWritable);
            }
        }
    }
}

