/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.util;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcArraysPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import java.io.UnsupportedEncodingException;

public class WtcMemoryStream
implements IWtcMemoryStream {
    public static final byte[] EMPTY_BUFFER = new byte[0];
    public static final int BLOCK_SIZE = 256;
    protected byte[] buffer = EMPTY_BUFFER;
    private int position = 0;
    private int length = 0;

    public WtcMemoryStream() {
        this(256);
    }

    public WtcMemoryStream(int capacity) {
        this.makeSpaceFor(capacity);
    }

    @Override
    public synchronized void reset() {
        this.setLength(0);
    }

    @Override
    public synchronized void clear() {
        this.buffer = EMPTY_BUFFER;
        this.reset();
    }

    @Override
    public synchronized int getCapacity() {
        return this.buffer.length;
    }

    @Override
    public synchronized byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public synchronized int getPosition() {
        return this.position;
    }

    @Override
    public synchronized void setPosition(int position) {
        this.makeSpaceFor(position);
        this.position = position;
    }

    @Override
    public synchronized int incPosition(int amount) {
        this.setPosition(this.getPosition() + amount);
        return this.getPosition();
    }

    @Override
    public synchronized int getLength() {
        return this.length;
    }

    @Override
    public synchronized void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        this.makeSpaceFor(length);
        WtcArraysPlatform.fill(this.buffer, (byte)0, this.length, length);
        this.length = length;
        if (this.position > this.length) {
            this.position = this.length;
        }
    }

    @Override
    public synchronized int incLength(int amount) {
        this.setLength(this.getLength() + amount);
        return this.getPosition();
    }

    protected synchronized boolean makeSpaceFor(int size) {
        if (size <= this.buffer.length) {
            return false;
        }
        int remainder = size % 256;
        size = size / 256 * 256;
        if (remainder > 0) {
            size += 256;
        }
        if (size == 0) {
            return false;
        }
        byte[] tmp = new byte[size];
        System.arraycopy(this.buffer, 0, tmp, 0, this.length);
        this.buffer = tmp;
        return true;
    }

    @Override
    public synchronized void write(byte[] buffer, int offset, int length) {
        this.makeSpaceFor(this.position + length);
        System.arraycopy(buffer, offset, this.buffer, this.position, length);
        this.position += length;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    @Override
    public synchronized void writeInt8(byte value) {
        this.makeSpaceFor(this.position + 1);
        this.buffer[this.position] = value;
        ++this.position;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    @Override
    public synchronized void writeUInt8(short value) {
        if (value >> 8 != 0) {
            throw new IllegalArgumentException("value is not a uint8: 0x" + WtcString.toHexString(value, 4));
        }
        this.makeSpaceFor(this.position + 1);
        this.buffer[this.position] = (byte)value;
        ++this.position;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    @Override
    public synchronized void writeInt16(short value) {
        this.makeSpaceFor(this.position + 2);
        this.buffer[this.position] = (byte)(value >> 8);
        this.buffer[this.position + 1] = (byte)value;
        this.position += 2;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    @Override
    public synchronized void writeUInt16(int value) {
        if (value >> 16 != 0) {
            throw new IllegalArgumentException("value is not a uint16: 0x" + WtcString.toHexString(value, 8));
        }
        this.makeSpaceFor(this.position + 2);
        this.buffer[this.position] = (byte)(value >> 8);
        this.buffer[this.position + 1] = (byte)value;
        this.position += 2;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    @Override
    public synchronized void writeInt32(long value) {
        this.makeSpaceFor(this.position + 4);
        this.buffer[this.position] = (byte)(value >> 24);
        this.buffer[this.position + 1] = (byte)(value >> 16);
        this.buffer[this.position + 2] = (byte)(value >> 8);
        this.buffer[this.position + 3] = (byte)value;
        this.position += 4;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    @Override
    public synchronized void writeUInt32(long value) {
        if (value >> 32 != 0L) {
            throw new IllegalArgumentException("value is not a uint32: 0x" + WtcString.toHexString(value, 16));
        }
        this.makeSpaceFor(this.position + 4);
        this.buffer[this.position] = (byte)(value >> 24);
        this.buffer[this.position + 1] = (byte)(value >> 16);
        this.buffer[this.position + 2] = (byte)(value >> 8);
        this.buffer[this.position + 3] = (byte)value;
        this.position += 4;
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    @Override
    public synchronized void writeString(String value) {
        if (value != null && value.length() > 0) {
            byte[] b;
            try {
                b = value.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException();
            }
            this.makeSpaceFor(this.position + b.length + 1);
            this.write(b, 0, b.length);
        }
        this.writeUInt8((short)0);
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    protected static boolean checkOffset(int size, byte[] buffer, int offset, int length) {
        return WtcMemoryStream.checkOffset(size, buffer, offset, length, true, true);
    }

    protected static boolean checkOffset(int size, byte[] buffer, int offset, int length, boolean checkParameters, boolean throwException) {
        if (checkParameters) {
            if (buffer == null) {
                throw new IllegalArgumentException("buffer must not be null");
            }
            if (length > buffer.length) {
                throw new IllegalArgumentException("length(" + length + ") must be <= buffer.length(" + buffer.length + ")");
            }
            if (offset < 0 || offset >= length) {
                throw new IllegalArgumentException("offset(" + offset + ") must be >= 0 and < (length(" + length + ") or buffer.length(" + buffer.length + "))");
            }
        }
        if (offset + size > length) {
            if (throwException) {
                throw new IndexOutOfBoundsException("attempted to read " + size + " bytes past offset(" + offset + ") would exceed length(" + length + ")");
            }
            return false;
        }
        return true;
    }

    private static int unsignedByteToInt(byte value) {
        return value & 0xFF;
    }

    private static int unsignedByteToInt(byte value, int leftShift) {
        return WtcMemoryStream.unsignedByteToInt(value) << leftShift;
    }

    @Override
    public synchronized int read(byte[] dest, int offset, int count) {
        count = Math.min(count, this.length - this.position);
        System.arraycopy(this.buffer, this.position, dest, offset, count);
        this.position += count;
        return count;
    }

    @Override
    public synchronized byte readInt8() {
        WtcMemoryStream.checkOffset(1, this.buffer, this.position, this.length);
        byte value = this.buffer[this.position++];
        return value;
    }

    @Override
    public synchronized short readUInt8() {
        WtcMemoryStream.checkOffset(1, this.buffer, this.position, this.length);
        short value = (short)WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++]);
        return value;
    }

    @Override
    public synchronized short readInt16() {
        WtcMemoryStream.checkOffset(2, this.buffer, this.position, this.length);
        short value = (short)WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++], 8);
        value = (short)(value + WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++]));
        return value;
    }

    @Override
    public synchronized int readUInt16() {
        WtcMemoryStream.checkOffset(2, this.buffer, this.position, this.length);
        int value = WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++], 8);
        return value += WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++]);
    }

    @Override
    public synchronized int readInt32() {
        WtcMemoryStream.checkOffset(4, this.buffer, this.position, this.length);
        int value = WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++], 24);
        value += WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++], 16);
        value += WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++], 8);
        return value += WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++]);
    }

    @Override
    public synchronized long readUInt32() {
        WtcMemoryStream.checkOffset(4, this.buffer, this.position, this.length);
        long value = WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++], 24);
        value += (long)WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++], 16);
        value += (long)WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++], 8);
        return value += (long)WtcMemoryStream.unsignedByteToInt(this.buffer[this.position++]);
    }

    @Override
    public synchronized String readString() {
        int index = this.position;
        while (WtcMemoryStream.checkOffset(1, this.buffer, this.position, this.length) && this.buffer[this.position] != 0) {
            ++this.position;
        }
        ++this.position;
        return WtcString.getString(this.buffer, index, this.position - index - 1);
    }

    @Override
    public synchronized String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(').append(this.length).append("):").append(WtcString.toHexString(this.buffer, 0, this.length));
        return sb.toString();
    }

    public static byte[] getBytes(short value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        return bytes;
    }

    public static byte[] getBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        return bytes;
    }

    public static byte[] getBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 56 & 0xFFL)};
        return bytes;
    }
}

