/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.types.IWtcpReceivable;
import com.twistpair.wave.thinclient.protocol.types.IWtcpSendable;
import com.twistpair.wave.thinclient.protocol.types.WtcpList;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import java.util.Enumeration;
import java.util.Vector;

public class WtcpStringList
extends WtcpList
implements IWtcpSendable,
IWtcpReceivable {
    public WtcpStringList() {
        super(String.class);
    }

    public WtcpStringList(String[] items) {
        super(String.class, items);
    }

    public WtcpStringList(Vector items) {
        super(String.class, items);
    }

    public WtcpStringList(IWtcMemoryStream inputStream) {
        this();
        this.loadNetworkToHostOrder(inputStream);
    }

    @Override
    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream) {
        int count = inputStream.readInt16();
        for (int i = 0; i < count; ++i) {
            String value = inputStream.readString();
            this.addElement(value);
        }
    }

    @Override
    public void dumpHostToNetworkOrder(IWtcMemoryStream outputStream) {
        outputStream.writeInt16((short)this.size());
        Enumeration elements = this.elements();
        while (elements.hasMoreElements()) {
            String value = (String)elements.nextElement();
            outputStream.writeString(value);
        }
    }

    @Override
    public String toString() {
        Enumeration elements = this.elements();
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        while (elements.hasMoreElements()) {
            String element = (String)elements.nextElement();
            sb.append('\"').append(element).append('\"');
            if (!elements.hasMoreElements()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

