/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;
import java.util.Vector;

public class WtcpList {
    public static final byte[] EMPTY = new byte[]{0, 0};
    protected final Class type;
    protected final Vector vector = new Vector();

    public static boolean isNullOrEmpty(WtcpList o) {
        return o == null || o.size() == 0;
    }

    protected WtcpList(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot by null");
        }
        this.type = type;
    }

    protected WtcpList(Class type, Object[] values) {
        this(type);
        this.addElements(values);
    }

    protected WtcpList(Class type, Vector values) {
        this(type);
        this.addElements(values);
    }

    protected WtcpList(Class type, WtcpList other) {
        this(type);
        this.addElements(other);
    }

    public void removeAllElements() {
        this.vector.removeAllElements();
    }

    public int size() {
        return this.vector.size();
    }

    public boolean isEmpty() {
        return this.vector.isEmpty();
    }

    public Enumeration elements() {
        return this.vector.elements();
    }

    public boolean contains(Object value) {
        return this.vector.contains(value);
    }

    public void addElement(Object value) {
        if (value == null || value.getClass() != this.type) {
            throw new IllegalArgumentException("value must be of type " + this.type);
        }
        this.vector.addElement(value);
    }

    public Object elementAt(int location) {
        return this.vector.elementAt(location);
    }

    public boolean removeElement(Object value) {
        if (value == null || value.getClass() != this.type) {
            throw new IllegalArgumentException("value must be of type " + this.type);
        }
        return this.vector.removeElement(value);
    }

    public void setElements(WtcpList other) {
        this.vector.removeAllElements();
        this.addElements(other);
    }

    public void addElements(Object[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.addElement(values[i]);
            }
        }
    }

    public void addElements(Vector values) {
        if (values != null) {
            this.addElements(values.elements());
        }
    }

    public void addElements(WtcpList other) {
        if (other != null) {
            this.addElements(other.elements());
        }
    }

    public void addElements(Enumeration enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.addElement(enumeration.nextElement());
            }
        }
    }

    public boolean removeElements(WtcpList other) {
        boolean found = false;
        if (other != null) {
            Enumeration items = other.elements();
            while (items.hasMoreElements()) {
                found |= this.removeElement(items.nextElement());
            }
        }
        return found;
    }

    public String toString() {
        return this.vector.toString();
    }
}

