/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.types.IWtcpReceivable;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

public class WtcpErrorCode
implements IWtcpReceivable {
    public static final WtcpErrorCode OK = new WtcpErrorCode(0);
    private int errorCode;
    private int subErrorCode;

    public static boolean isOk(WtcpErrorCode errorCode) {
        return errorCode == null || errorCode.isOK();
    }

    public static boolean isError(WtcpErrorCode errorCode) {
        return errorCode != null && errorCode.isError();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getSubErrorCode() {
        return this.subErrorCode;
    }

    public boolean isOK() {
        return this.errorCode == 0;
    }

    public boolean isError() {
        return this.errorCode != 0;
    }

    public WtcpErrorCode(int errorCode) {
        this.errorCode = errorCode;
        this.subErrorCode = 0;
    }

    public WtcpErrorCode(IWtcMemoryStream inputStream) {
        this.loadNetworkToHostOrder(inputStream);
    }

    @Override
    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream) {
        this.errorCode = inputStream.readInt8();
        this.subErrorCode = this.errorCode == 32 ? (int)inputStream.readInt8() : 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof WtcpErrorCode)) {
            return false;
        }
        return this.errorCode == ((WtcpErrorCode)o).errorCode && this.subErrorCode == ((WtcpErrorCode)o).subErrorCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{errorCode=").append(WtcpConstants.WtcpErrorCodes.toString(this.errorCode));
        if (this.errorCode == 32) {
            sb.append(", subErrorCode=").append(WtcpConstants.WtcpErrorCodes.toString(this.subErrorCode));
        }
        sb.append('}');
        return sb.toString();
    }
}

