/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.headers;

import com.twistpair.wave.thinclient.protocol.headers.IWtcpSubHeader;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcpMediaHeader
extends IWtcpSubHeader {
    public static final int SIZE = 2;
    public static final int SEQUENCE_NUMBER_BITS = 14;
    private int ushort0;

    @Override
    public int getOffset() {
        return 4;
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public int getSequenceNumberBits() {
        return 14;
    }

    @Override
    public int getMessageType() {
        return 5;
    }

    public boolean getIsNotAudio() {
        return (this.ushort0 & 0x8000) >> 15 == 1;
    }

    public void setIsNotAudio(boolean value) {
        int mask = 32768;
        this.ushort0 = this.ushort0 & ~mask | (value ? 1 : 0) << 15 & mask;
    }

    public boolean getHas16BitCrcAfterHeader() {
        return (this.ushort0 & 0x4000) >> 14 == 1;
    }

    public void setHas16BitCrcAfterHeader(boolean value) {
        int mask = 16384;
        this.ushort0 = this.ushort0 & ~mask | (value ? 1 : 0) << 14 & mask;
    }

    public int getSequenceNumber() {
        return (this.ushort0 & 0x3FFF) >> 0;
    }

    public void setSequenceNumber(int value) {
        int mask = 16383;
        this.ushort0 = this.ushort0 & ~mask | value << 0 & mask;
    }

    public boolean getIsAudio() {
        return !this.getIsNotAudio();
    }

    public void setIsAudio(boolean value) {
        this.setIsNotAudio(!value);
    }

    public WtcpMediaHeader() {
        this(false);
    }

    public WtcpMediaHeader(boolean isNotAudio) {
        this(isNotAudio, false, 0);
    }

    public WtcpMediaHeader(boolean isNotAudio, boolean has16BitCrcAfterHeader, int sequenceNumber) {
        this.setIsNotAudio(isNotAudio);
        this.setHas16BitCrcAfterHeader(has16BitCrcAfterHeader);
        this.setSequenceNumber(sequenceNumber);
    }

    public WtcpMediaHeader(IWtcMemoryStream buffer) {
        super(buffer);
    }

    @Override
    public void dumpHostToNetworkOrder(IWtcMemoryStream buffer) {
        super.dumpHostToNetworkOrder(buffer);
        buffer.writeUInt16(this.ushort0);
    }

    @Override
    public boolean loadNetworkToHostOrder(IWtcMemoryStream buffer) {
        if (!super.loadNetworkToHostOrder(buffer)) {
            return false;
        }
        this.ushort0 = buffer.readUInt16();
        return true;
    }

    @Override
    public void reset() {
        this.ushort0 = 0;
    }

    @Override
    public String toString(char format) {
        format = Character.toLowerCase(format);
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        switch (format) {
            case 'd': {
                sb.append("a=").append(this.getIsAudio()).append(",c=").append(this.getHas16BitCrcAfterHeader()).append(",s=").append(WtcString.formatNumber(this.getSequenceNumber(), 5));
                break;
            }
            default: {
                sb.append("a=").append(this.getIsAudio()).append(",c=").append(this.getHas16BitCrcAfterHeader()).append(",s=0x").append(WtcString.toHexString(this.getSequenceNumber(), 2));
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

