/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.headers;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

public abstract class IWtcpHeader {
    public abstract int getOffset();

    public abstract int getSize();

    public abstract int getSequenceNumberBits();

    public int getSequenceNumberMaximum() {
        return (1 << this.getSequenceNumberBits()) - 1;
    }

    public int normalizeSequenceNumber(long extendedSequenceNumber) {
        int sequenceNumberMaximum = this.getSequenceNumberMaximum();
        return (int)(extendedSequenceNumber & (long)sequenceNumberMaximum);
    }

    public int getPayloadOffset() {
        return this.getOffset() + this.getSize();
    }

    protected IWtcpHeader() {
        this.reset();
    }

    protected IWtcpHeader(IWtcMemoryStream buffer) {
        this.loadNetworkToHostOrder(buffer);
    }

    public void dumpHostToNetworkOrder(IWtcMemoryStream buffer) {
        if (buffer.getLength() < this.getPayloadOffset()) {
            buffer.setLength(this.getPayloadOffset());
        }
        buffer.setPosition(this.getOffset());
    }

    public boolean loadNetworkToHostOrder(IWtcMemoryStream buffer) {
        if (buffer.getLength() < this.getPayloadOffset()) {
            return false;
        }
        buffer.setPosition(this.getOffset());
        return true;
    }

    public abstract void reset();

    public String toString() {
        return this.toString('x');
    }

    public abstract String toString(char var1);
}

