/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol;

import com.twistpair.wave.thinclient.util.WtcString;
import java.util.Vector;

public class WtcpConstants {

    public static interface WtcpEndpointFilterType {
        public static final int SemiColonSeparated = 1;
    }

    public static class WtcpEndpointFlags {
        public static final int None = 0;
        public static final int Moderator = 1;
        public static final int Speaking = 2;
        public static final int Typing = 4;
        public static final int AudioTxMute = 8;
        public static final int TextMute = 16;
        public static final int Unavailable = 32;
        public static final int Visible = 64;
        public static final int AudioRxMute = 128;
        public static final int TxSilence = 256;
        public static final int RxSilence = 512;
        public static final int EmergencyTx = 1024;
        public static final int Self = 2048;
        public static final int Point2Point = 4096;
        public static final int Gone = 8192;
        public static final int Reserved14 = 16384;
        public static final int Reserved15 = 32768;
        public static final int User16 = 65536;
        public static final int User17 = 131072;
        public static final int User18 = 262144;
        public static final int User19 = 524288;
        public static final int User20 = 0x100000;
        public static final int User21 = 0x200000;
        public static final int User22 = 0x400000;
        public static final int User23 = 0x800000;
        public static final int User24 = 0x1000000;
        public static final int User25 = 0x2000000;
        public static final int User26 = 0x4000000;
        public static final int User27 = 0x8000000;
        public static final int User28 = 0x10000000;
        public static final int User29 = 0x20000000;
        public static final int User30 = 0x40000000;
        public static final int User31 = Integer.MIN_VALUE;
        public static final int All = -1;

        public static String toString(long flags) {
            Vector<String> values = new Vector<String>();
            if (flags == 0L) {
                return "None";
            }
            if (flags == -1L) {
                return "All";
            }
            if ((flags & 1L) == 1L) {
                values.addElement("Moderator");
            }
            if ((flags & 2L) == 2L) {
                values.addElement("Speaking");
            }
            if ((flags & 4L) == 4L) {
                values.addElement("Typing");
            }
            if ((flags & 8L) == 8L) {
                values.addElement("AudioTxMute");
            }
            if ((flags & 0x10L) == 16L) {
                values.addElement("TextMute");
            }
            if ((flags & 0x20L) == 32L) {
                values.addElement("Unavailable");
            }
            if ((flags & 0x40L) == 64L) {
                values.addElement("Visible");
            }
            if ((flags & 0x80L) == 128L) {
                values.addElement("AudioRxMute");
            }
            if ((flags & 0x100L) == 256L) {
                values.addElement("TxSilence");
            }
            if ((flags & 0x200L) == 512L) {
                values.addElement("RxSilence");
            }
            if ((flags & 0x400L) == 1024L) {
                values.addElement("EmergencyTx");
            }
            if ((flags & 0x800L) == 2048L) {
                values.addElement("Self");
            }
            if ((flags & 0x1000L) == 4096L) {
                values.addElement("Point2Point");
            }
            if ((flags & 0x2000L) == 8192L) {
                values.addElement("Gone");
            }
            if ((flags & 0x4000L) == 16384L) {
                values.addElement("Reserved14");
            }
            if ((flags & 0x8000L) == 32768L) {
                values.addElement("Reserved15");
            }
            if ((flags & 0x10000L) == 65536L) {
                values.addElement("User16");
            }
            if ((flags & 0x20000L) == 131072L) {
                values.addElement("User17");
            }
            if ((flags & 0x40000L) == 262144L) {
                values.addElement("User18");
            }
            if ((flags & 0x80000L) == 524288L) {
                values.addElement("User19");
            }
            if ((flags & 0x100000L) == 0x100000L) {
                values.addElement("User20");
            }
            if ((flags & 0x200000L) == 0x200000L) {
                values.addElement("User21");
            }
            if ((flags & 0x400000L) == 0x400000L) {
                values.addElement("User22");
            }
            if ((flags & 0x800000L) == 0x800000L) {
                values.addElement("User23");
            }
            if ((flags & 0x1000000L) == 0x1000000L) {
                values.addElement("User24");
            }
            if ((flags & 0x2000000L) == 0x2000000L) {
                values.addElement("User25");
            }
            if ((flags & 0x4000000L) == 0x4000000L) {
                values.addElement("User26");
            }
            if ((flags & 0x8000000L) == 0x8000000L) {
                values.addElement("User27");
            }
            if ((flags & 0x10000000L) == 0x10000000L) {
                values.addElement("User28");
            }
            if ((flags & 0x20000000L) == 0x20000000L) {
                values.addElement("User29");
            }
            if ((flags & 0x40000000L) == 0x40000000L) {
                values.addElement("User30");
            }
            if ((flags & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                values.addElement("User31");
            }
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.elementAt(i);
                if (i != 0) {
                    sb.append('|');
                }
                sb.append(value);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public static interface WtcpChannelFlags {
        public static final short None = 0;
        public static final short Active = 1;
        public static final short RemoteMute = 2;
        public static final short ClientSpeaking = 4;
        public static final short RemoteSpeaking = 8;
        public static final short Reserved4 = 16;
        public static final short Reserved5 = 32;
        public static final short Reserved6 = 64;
        public static final short Reserved7 = 128;
        public static final short Reserved8 = 256;
        public static final short Reserved9 = 512;
        public static final short Reserved10 = 1024;
        public static final short Reserved11 = 2048;
        public static final short Reserved12 = 4096;
        public static final short Reserved13 = 8192;
        public static final short Reserved14 = 16384;
        public static final short Reserved15 = Short.MIN_VALUE;
        public static final short All = -1;
    }

    public static class WtcpCallType {
        public static final byte Endpoint = 1;
        public static final byte E164 = 2;

        public static String getName(int callType) {
            switch (callType) {
                case 1: {
                    return "Endpoint";
                }
                case 2: {
                    return "E164";
                }
            }
            return "?";
        }

        public static String toString(int callType) {
            return WtcpCallType.toString(callType, 'd');
        }

        public static String toString(int callType, char format) {
            switch (format) {
                case 'd': {
                    return '\"' + WtcpCallType.getName(callType) + "\"(" + WtcString.formatNumber(callType, 1) + ')';
                }
            }
            return '\"' + WtcpCallType.getName(callType) + "\"(0x" + WtcString.toHexString(callType, 2) + ')';
        }
    }

    public static class WtcpCallProgressState {
        public static final byte Disconnected = 0;
        public static final byte Proceeding = 1;
        public static final byte Ringing = 2;
        public static final byte Connected = 3;

        public static String getName(int progress) {
            switch (progress) {
                case 0: {
                    return "Disconnected";
                }
                case 1: {
                    return "Proceeding";
                }
                case 2: {
                    return "Ringing";
                }
                case 3: {
                    return "Connected";
                }
            }
            return "?";
        }

        public static String toString(int progress) {
            return WtcpCallProgressState.toString(progress, 'd');
        }

        public static String toString(int progress, char format) {
            switch (format) {
                case 'd': {
                    return '\"' + WtcpCallProgressState.getName(progress) + "\"(" + WtcString.formatNumber(progress, 1) + ')';
                }
            }
            return '\"' + WtcpCallProgressState.getName(progress) + "\"(0x" + WtcString.toHexString(progress, 2) + ')';
        }
    }

    public static class WtcpErrorCodes {
        public static final byte OK = 0;
        public static final byte Error = 1;
        public static final byte InvalidCodec = 2;
        public static final byte InvalidAudioScale = 3;
        public static final byte InvalidSessionTimeout = 4;
        public static final byte InvalidLicense = 5;
        public static final byte LicenseMaxReach = 6;
        public static final byte InvalidUsernameOrPassword = 7;
        public static final byte InvalidProfileId = 8;
        public static final byte InvalidChannelId = 9;
        public static final byte ChannelAccessDenied = 10;
        public static final byte NoSuchPage = 11;
        public static final byte InvalidEndpointId = 12;
        public static final byte ChannelNotActive = 13;
        public static final byte ResponseTooLong = 14;
        public static final byte DtmfNotEnabled = 15;
        public static final byte InvalidDtmf = 16;
        public static final byte InvalidE164Number = 17;
        public static final byte PttBonk = 18;
        public static final byte TryAgain = 19;
        public static final byte InvalidOpCode = 20;
        public static final byte InvalidCallId = 21;
        public static final byte NoCallResource = 22;
        public static final byte TooMany = 23;
        public static final byte InACall = 24;
        public static final byte InvalidPhoneLine = 25;
        public static final byte PhoneLineUnavailable = 26;
        public static final byte CredentialsInProgress = 27;
        public static final byte InvalidCallType = 28;
        public static final byte EndpointHasNoPhoneLine = 29;
        public static final byte CannotSetOtherEndpointProperty = 30;
        public static final byte InvalidSessionId = 31;
        public static final byte WtcpTransmissionError = 32;
        public static final byte KexTimeout = 33;
        public static final byte SessionOpenTimeout = 34;
        public static final byte CredentialsTimeout = 35;
        public static final byte ReadOnly = 36;
        public static final byte InvalidEndpointPropFilterType = 37;
        public static final byte InvalidEndpointPropFilterString = 38;
        public static final byte Empty = 39;
        public static final byte InitSequenceFailed = 40;
        public static final byte ServerError1 = 41;
        public static final byte ServerError2 = 42;
        public static final byte MgsError = 43;
        public static final byte HttpError = 44;
        public static final byte InsufficientServerResources1 = 45;
        public static final byte InsufficientServerResources2 = 46;
        public static final byte InvalidFormat = 47;
        public static final byte ProxyAtCapacity = 48;
        public static final byte BackendDrop = 49;
        public static final byte SessionNotOpened = 50;
        public static final byte FeatureNotImplemented = 51;
        public static final byte UserHasNoProfile = 52;
        public static final byte UserHasNoZone = 53;
        public static final byte MgsXmlError = 54;
        public static final byte SelectProfileNow = 55;
        public static final byte ProxyNotReady = 56;
        public static final byte ClientNotReady = 57;
        public static final byte ReKeyNeeded = 58;
        public static final byte CallPttAccessDenied = 59;
        public static final byte CallPttNotActive = 60;
        public static final byte AddressBookNotAvailable = 61;
        public static final byte CallPttTooLong = 62;
        public static final byte CallPttBusy = 63;
        public static final byte UnknownErrorCode = 64;
        public static final byte NullPtr = 65;
        public static final byte XmlParsingError = 66;

        public static String getName(int errorCode) {
            switch (errorCode) {
                case 0: {
                    return "OK";
                }
                case 1: {
                    return "Error";
                }
                case 2: {
                    return "InvalidCodec";
                }
                case 3: {
                    return "InvalidAudioScale";
                }
                case 4: {
                    return "InvalidSessionTimeout";
                }
                case 5: {
                    return "InvalidLicense";
                }
                case 6: {
                    return "LicenseMaxReach";
                }
                case 7: {
                    return "InvalidUsernameOrPassword";
                }
                case 8: {
                    return "InvalidProfileId";
                }
                case 9: {
                    return "InvalidChannelId";
                }
                case 10: {
                    return "ChannelAccessDenied";
                }
                case 11: {
                    return "NoSuchPage";
                }
                case 12: {
                    return "InvalidEndpointId";
                }
                case 13: {
                    return "ChannelNotActive";
                }
                case 14: {
                    return "ResponseTooLong";
                }
                case 15: {
                    return "DtmfNotEnabled";
                }
                case 16: {
                    return "InvalidDtmf";
                }
                case 17: {
                    return "InvalidE164Number";
                }
                case 18: {
                    return "PttBonk";
                }
                case 19: {
                    return "TryAgain";
                }
                case 20: {
                    return "InvalidOpCode";
                }
                case 21: {
                    return "InvalidCallId";
                }
                case 22: {
                    return "NoCallResource";
                }
                case 23: {
                    return "TooMany";
                }
                case 24: {
                    return "InACall";
                }
                case 25: {
                    return "InvalidPhoneLine";
                }
                case 26: {
                    return "PhoneLineUnavailable";
                }
                case 27: {
                    return "CredentialsInProgress";
                }
                case 28: {
                    return "InvalidCallType";
                }
                case 29: {
                    return "EndpointHasNoPhoneLine";
                }
                case 30: {
                    return "CannotSetOtherEndpointProperty";
                }
                case 31: {
                    return "InvalidSessionId";
                }
                case 32: {
                    return "WtcpTransmissionError";
                }
                case 33: {
                    return "KexTimeout";
                }
                case 34: {
                    return "SessionOpenTimeout";
                }
                case 35: {
                    return "CredentialsTimeout";
                }
                case 36: {
                    return "ReadOnly";
                }
                case 37: {
                    return "InvalidEndpointPropFilterType";
                }
                case 38: {
                    return "InvalidEndpointPropFilterString";
                }
                case 39: {
                    return "Empty";
                }
                case 40: {
                    return "InitSequenceFailed";
                }
                case 41: {
                    return "ServerError1";
                }
                case 42: {
                    return "ServerError2";
                }
                case 43: {
                    return "MgsError";
                }
                case 44: {
                    return "HttpError";
                }
                case 45: {
                    return "InsufficientServerResources1";
                }
                case 46: {
                    return "InsufficientServerResources2";
                }
                case 47: {
                    return "InvalidFormat";
                }
                case 48: {
                    return "ProxyAtCapacity";
                }
                case 49: {
                    return "BackendDrop";
                }
                case 50: {
                    return "SessionNotOpened";
                }
                case 51: {
                    return "FeatureNotImplemented";
                }
                case 52: {
                    return "UserHasNoProfile";
                }
                case 53: {
                    return "UserHasNoZone";
                }
                case 54: {
                    return "MgsXmlError";
                }
                case 55: {
                    return "SelectProfileNow";
                }
                case 56: {
                    return "ProxyNotReady";
                }
                case 57: {
                    return "ClientNotReady";
                }
                case 58: {
                    return "ReKeyNeeded";
                }
                case 59: {
                    return "CallPttAccessDenied";
                }
                case 60: {
                    return "CallPttNotActive";
                }
                case 61: {
                    return "AddressBookNotAvailable";
                }
                case 62: {
                    return "CallPttTooLong";
                }
                case 63: {
                    return "CallPttBusy";
                }
                case 64: {
                    return "UnknownErrorCode";
                }
                case 65: {
                    return "NullPtr";
                }
                case 66: {
                    return "XmlParsingError";
                }
            }
            return "?";
        }

        public static String toString(int errorCode) {
            return WtcpErrorCodes.toString(errorCode, 'd');
        }

        public static String toString(int errorCode, char format) {
            switch (format) {
                case 'd': {
                    return '\"' + WtcpErrorCodes.getName(errorCode) + "\"(" + WtcString.formatNumber(errorCode, 1) + ')';
                }
            }
            return '\"' + WtcpErrorCodes.getName(errorCode) + "\"(0x" + WtcString.toHexString(errorCode, 2) + ')';
        }
    }

    public static interface WtcpAudioCodec {
        public static final byte Invalid = 0;
        public static final byte PCM_Mono16bBigEndian8kHz = 1;
        public static final byte GSM_full_rate = 10;
        public static final byte MSGSM = 11;
        public static final byte G711_Ulaw64k = 20;
        public static final byte G711_Alaw64k = 21;
        public static final byte AMR_MR0475 = 30;
        public static final byte AMR_MR0515 = 31;
        public static final byte AMR_MR0590 = 32;
        public static final byte AMR_MR0670 = 33;
        public static final byte AMR_MR0740 = 34;
        public static final byte AMR_MR0795 = 35;
        public static final byte AMR_MR1020 = 36;
        public static final byte AMR_MR1220 = 37;
        public static final byte AMR_MRDTX = 38;
        public static final byte Speex_NB_2150 = 40;
        public static final byte Speex_NB_5950 = 41;
        public static final byte Speex_NB_8000 = 42;
        public static final byte Speex_NB_11000 = 43;
        public static final byte Speex_NB_15000 = 44;
        public static final byte Speex_NB_18200 = 45;
        public static final byte Speex_NB_24600 = 46;
    }

    public static class WtcpChannelChange {
        public static final byte Added = 1;
        public static final byte Removed = 2;
        public static final byte Changed = 3;

        public static String getName(int changeType) {
            switch (changeType) {
                case 1: {
                    return "Added";
                }
                case 2: {
                    return "Removed";
                }
                case 3: {
                    return "Changed";
                }
            }
            return "?";
        }

        public static String toString(int changeType) {
            return WtcpChannelChange.toString(changeType, 'd');
        }

        public static String toString(int changeType, char format) {
            switch (format) {
                case 'd': {
                    return '\"' + WtcpChannelChange.getName(changeType) + "\"(" + WtcString.formatNumber(changeType, 1) + ')';
                }
            }
            return '\"' + WtcpChannelChange.getName(changeType) + "\"(0x" + WtcString.toHexString(changeType, 1) + ')';
        }
    }

    public static class WtcpOpType {
        public static final byte Reserved0 = 0;
        public static final byte Request = 1;
        public static final byte Response = 2;
        public static final byte Unsolicited = 3;
        public static final byte Error = 4;

        public static String getName(int opType) {
            switch (opType) {
                case 0: {
                    return "Reserved0";
                }
                case 1: {
                    return "Request";
                }
                case 2: {
                    return "Response";
                }
                case 3: {
                    return "Unsolicited";
                }
                case 4: {
                    return "Error";
                }
            }
            return "?";
        }

        public static String toString(int opType) {
            return WtcpOpType.toString(opType, 'd');
        }

        public static String toString(int opType, char format) {
            switch (format) {
                case 'd': {
                    return '\"' + WtcpOpType.getName(opType) + "\"(" + WtcString.formatNumber(opType, 1) + ')';
                }
            }
            return '\"' + WtcpOpType.getName(opType) + "\"(0x" + WtcString.toHexString(opType, 1) + ')';
        }
    }

    public static class WtcpOpCode {
        public static final short WTCPControlSignaling = 1;
        public static final short Ping = 2;
        public static final short ReKex = 3;
        public static final short SessionOpen = 5;
        public static final short SessionClose = 6;
        public static final short SetCredentials = 7;
        public static final short SessionResume = 8;
        public static final short ChannelSetActive = 10;
        public static final short ChannelList = 11;
        public static final short ChannelActivity = 12;
        public static final short ChannelPushToTalk = 13;
        public static final short ChannelMute = 14;
        public static final short ChannelPropertiesGet = 15;
        public static final short ChannelPropertiesSet = 16;
        public static final short EndpointPropertiesSet = 20;
        public static final short EndpointLookup = 21;
        public static final short EndpointPropertiesGet = 22;
        public static final short EndpointPropertyFilterSet = 23;
        public static final short PhoneLinesSetActive = 30;
        public static final short PhoneLineStatus = 31;
        public static final short CallMake = 32;
        public static final short CallOffer = 33;
        public static final short CallAnswer = 34;
        public static final short CallHangup = 35;
        public static final short CallDtmf = 36;
        public static final short CallProgress = 37;
        public static final short CallPushToTalkOn = 38;
        public static final short CallPushToTalkOff = 39;
        public static final short AddressBook = 50;

        public static String getName(int opCode) {
            switch (opCode) {
                case 1: {
                    return "WTCPControlSignaling";
                }
                case 2: {
                    return "Ping";
                }
                case 3: {
                    return "ReKex";
                }
                case 5: {
                    return "SessionOpen";
                }
                case 6: {
                    return "SessionClose";
                }
                case 7: {
                    return "SetCredentials";
                }
                case 8: {
                    return "SessionResume";
                }
                case 10: {
                    return "ChannelSetActive";
                }
                case 11: {
                    return "ChannelList";
                }
                case 12: {
                    return "ChannelActivity";
                }
                case 13: {
                    return "ChannelPushToTalk";
                }
                case 14: {
                    return "ChannelMute";
                }
                case 15: {
                    return "ChannelPropertiesGet";
                }
                case 16: {
                    return "ChannelPropertiesSet";
                }
                case 20: {
                    return "EndpointPropertiesSet";
                }
                case 21: {
                    return "EndpointLookup";
                }
                case 22: {
                    return "EndpointPropertiesGet";
                }
                case 23: {
                    return "EndpointPropertyFilterSet";
                }
                case 30: {
                    return "PhoneLinesSetActive";
                }
                case 31: {
                    return "PhoneLineStatus";
                }
                case 32: {
                    return "CallMake";
                }
                case 33: {
                    return "CallOffer";
                }
                case 34: {
                    return "CallAnswer";
                }
                case 35: {
                    return "CallHangup";
                }
                case 36: {
                    return "CallDtmf";
                }
                case 37: {
                    return "CallProgress";
                }
                case 38: {
                    return "CallPushToTalkOn";
                }
                case 39: {
                    return "CallPushToTalkOff";
                }
                case 50: {
                    return "AddressBook";
                }
            }
            return "?";
        }

        public static String toString(int opCode) {
            return WtcpOpCode.toString(opCode, 'd');
        }

        public static String toString(int opCode, char format) {
            switch (format) {
                case 'd': {
                    return '\"' + WtcpOpCode.getName(opCode) + "\"(" + WtcString.formatNumber(opCode, 4) + ')';
                }
            }
            return '\"' + WtcpOpCode.getName(opCode) + "\"(0x" + WtcString.toHexString(opCode, 2) + ')';
        }
    }

    public static class WtcpMessageType {
        public static final byte Reserved0 = 0;
        public static final byte Hello = 1;
        public static final byte UdpHello = 2;
        public static final byte KeyExchange = 3;
        public static final byte Control = 4;
        public static final byte Media = 5;
        public static final byte Reserved6 = 6;
        public static final byte Reserved7 = 7;

        public static String getName(byte messageType) {
            switch (messageType) {
                case 0: {
                    return "Reserved0";
                }
                case 1: {
                    return "Hello";
                }
                case 2: {
                    return "UdpHello";
                }
                case 3: {
                    return "KeyExchange";
                }
                case 4: {
                    return "Control";
                }
                case 5: {
                    return "Media";
                }
                case 6: {
                    return "Reserved6";
                }
                case 7: {
                    return "Reserved7";
                }
            }
            return "?";
        }

        public static String toString(byte messageType) {
            return WtcpMessageType.toString(messageType, 'd');
        }

        public static String toString(byte messageType, char format) {
            switch (format) {
                case 'd': {
                    return '\"' + WtcpMessageType.getName(messageType) + "\"(" + WtcString.formatNumber(messageType, 1) + ')';
                }
            }
            return '\"' + WtcpMessageType.getName(messageType) + "\"(0x" + WtcString.toHexString(messageType, 1) + ')';
        }
    }

    public static interface WtcpVersion {
        public static final byte HeaderMain = 1;
        public static final byte HeaderControl = 1;
    }
}

