/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.net;

import com.twistpair.wave.thinclient.WtcLocatorException;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.net.WtcConnection;
import com.twistpair.wave.thinclient.net.WtcHttpConnectionPlatform;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform;
import com.twistpair.wave.thinclient.net.WtcUri;
import com.twistpair.wave.thinclient.net.WtcUriPlatform;
import com.twistpair.wave.thinclient.util.WtcXml;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.w3c.dom.Element;

public class WtcNet {
    private static final String TAG = WtcLog.TAG(WtcNet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element makeRequestXml(WtcUri uri) throws IOException, WtcLocatorException.WtcLocatorResponseInvalidException {
        try {
            WtcLog.info(TAG, "+makeRequestXml(" + uri + ")");
            WtcHttpResponseText response = WtcNet.makeRequestText(uri);
            Element xmlDoc = null;
            try {
                if (response.getResponseCode() == 200) {
                    xmlDoc = WtcXml.toXmlDoc(response.response);
                }
            }
            catch (WtcXml.WtcXmlException e) {
                throw new WtcLocatorException.WtcLocatorResponseInvalidException(e, response.response);
            }
            Element element = xmlDoc;
            return element;
        }
        finally {
            WtcLog.info(TAG, "+makeRequestXml(" + uri + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WtcHttpResponseText makeRequestText(WtcUri uri) throws IOException {
        try {
            String response;
            int responseCode;
            WtcLog.info(TAG, "+makeRequestText(" + uri + ")");
            block15: while (true) {
                InputStream inputStream;
                WtcHttpConnectionPlatform conn;
                WtcLog.info(TAG, "Request: " + uri);
                try {
                    WtcLog.info(TAG, "+WtcConnection.open(uri)");
                    conn = (WtcHttpConnectionPlatform)WtcConnection.open(uri);
                    WtcLog.info(TAG, "-WtcConnection.open(uri)");
                }
                catch (IOException e) {
                    WtcLog.error(TAG, "EXCEPTION: makeRequestText conn=WtcConnection.open(" + uri + ")", e);
                    throw e;
                }
                try {
                    WtcLog.info(TAG, "+conn.openInputStream()");
                    inputStream = conn.openInputStream();
                    WtcLog.info(TAG, "-conn.openInputStream()");
                }
                catch (IOException e2) {
                    WtcNetworkExceptionPlatform e2;
                    WtcLog.error(TAG, "EXCEPTION: makeRequestText inputStream=conn.openInputStream()", e2);
                    if (WtcNetworkExceptionPlatform.isUnreachable(e2)) {
                        e2 = new WtcNetworkExceptionPlatform.WtcNetworkUnreachableException(uri, (Exception)e2);
                    } else if (WtcNetworkExceptionPlatform.isUnknownHostException(e2)) {
                        e2 = new WtcNetworkExceptionPlatform.WtcNetworkUnknownHostException(uri, (Exception)e2);
                    } else if (WtcNetworkExceptionPlatform.isHostnameNotVerified(e2)) {
                        e2 = new WtcNetworkExceptionPlatform.WtcNetworkHostnameNotVerifiedException(uri, (Exception)e2);
                    }
                    throw e2;
                }
                responseCode = conn.getResponseCode();
                WtcLog.info(TAG, "responseCode=" + responseCode);
                InputStreamReader reader = new InputStreamReader(inputStream);
                StringBuffer sb = new StringBuffer();
                char[] buffer = new char[1024];
                try {
                    int charsRead;
                    while ((charsRead = reader.read(buffer)) > 0) {
                        sb.append(new String(buffer, 0, charsRead));
                    }
                }
                catch (IOException e) {
                    WtcLog.error(TAG, "EXCEPTION: makeRequestText reader.read(...)", e);
                    throw e;
                }
                finally {
                    ((Reader)reader).close();
                    conn.close();
                }
                response = sb.toString();
                WtcLog.info(TAG, "Response: " + response);
                switch (responseCode) {
                    case 301: 
                    case 302: 
                    case 307: {
                        String location = conn.getHeaderField("location");
                        if (location == null) {
                            throw new IOException("Missing \"location\" redirect header");
                        }
                        uri = WtcUriPlatform.parse(location);
                        continue block15;
                    }
                }
                break;
            }
            if (200 != responseCode) {
                WtcLog.warn(TAG, "Unknown HTTP response. responseCode=" + responseCode + "; returning response anyway.");
            }
            WtcHttpResponseText wtcHttpResponseText = new WtcHttpResponseText(responseCode, response);
            return wtcHttpResponseText;
        }
        finally {
            WtcLog.info(TAG, "-makeRequestText(" + uri + ")");
        }
    }

    public static class WtcHttpResponseText {
        private final int responseCode;
        private final String response;

        protected WtcHttpResponseText(int responseCode, String response) {
            this.responseCode = responseCode;
            this.response = response;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponse() {
            return this.response;
        }
    }
}

