/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.media.Codec;

public class GSMCodec
extends Codec {
    private static final String TAG = WtcLog.TAG(GSMCodec.class);
    private static final String LIB_NAME = "GSM";
    private static final String LIB_PATH = "gsmlib";
    protected static boolean isInitialized = false;

    private native int InitLib();

    private native int Close();

    private native int Decode(byte[] var1, int var2, short[] var3, int var4);

    private native int Encode(short[] var1, int var2, int var3, byte[] var4, int var5);

    public GSMCodec() {
        this.initialize();
    }

    @Override
    public String getName() {
        return LIB_NAME;
    }

    public boolean initialize() {
        if (GSMCodec.loadLibrary(LIB_PATH) && !isInitialized) {
            try {
                isInitialized = this.InitLib() == 1;
            }
            catch (Exception ex) {
                WtcLog.error(TAG, "EXCEPTION: Could not initialize gsmlib lib", ex);
            }
        }
        return isInitialized;
    }

    public void close() {
        if (!isInitialized) {
            return;
        }
        this.Close();
        isInitialized = false;
    }

    public int encode(short[] bufferUnencoded, int offset, int length, byte[] bufferEncoded) {
        if (!isInitialized) {
            return 0;
        }
        return this.Encode(bufferUnencoded, offset, length, bufferEncoded, bufferEncoded.length);
    }

    public int decode(byte[] bufferEncoded, int length, short[] bufferUnencoded) {
        if (!isInitialized) {
            return 0;
        }
        return this.Decode(bufferEncoded, length, bufferUnencoded, bufferUnencoded.length);
    }
}

