/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.twistpair.wave.thinclient.WtcWeakReferenceHandler;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.WtcUtilsPlatform;

public class WtcServiceConnection
implements ServiceConnection {
    private static final String TAG = WtcLog.TAG(WtcServiceConnection.class);
    private final Context mContext;
    private final Class<?> mClassService;
    private final Messenger mMessengerActivity;
    private Messenger mMessengerService;
    private boolean mIsBound;
    private boolean mIsStarted;
    private Message mMessageOnServiceConnected;

    public WtcServiceConnection(Context context, Class<?> classService, WtcWeakReferenceHandler<?> handler) {
        this.mContext = context;
        this.mClassService = classService;
        this.mMessengerActivity = new Messenger(handler);
    }

    public Context getContext() {
        return this.mContext;
    }

    public Class<?> getClassService() {
        return this.mClassService;
    }

    public Messenger getMessengerActivity() {
        return this.mMessengerActivity;
    }

    public Messenger getMessengerService() {
        return this.mMessengerService;
    }

    public synchronized boolean isBound() {
        return this.mIsBound;
    }

    public boolean isRunning() {
        return WtcServiceConnection.isServiceRunning(this.mContext, this.mClassService);
    }

    public static boolean isServiceRunning(Context context, Class<?> classService) {
        String classServiceCanonicalName = classService.getCanonicalName();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo rsi : manager.getRunningServices(Integer.MAX_VALUE)) {
            String tempServiceCanonicalName = rsi.service.getClassName();
            if (!tempServiceCanonicalName.equals(classServiceCanonicalName)) continue;
            return true;
        }
        return false;
    }

    public boolean start(Bundle extras) {
        ComponentName componentName;
        Intent intent = new Intent(this.mContext, this.mClassService);
        if (extras != null) {
            intent.putExtras(extras);
        }
        this.mIsStarted = (componentName = this.mContext.startService(intent)) != null;
        return this.mIsStarted;
    }

    public boolean bind(Bundle extras, Message onServiceConnected) {
        this.mMessageOnServiceConnected = onServiceConnected;
        Intent intent = new Intent(this.mContext, this.mClassService);
        if (extras != null) {
            intent.putExtras(extras);
        }
        return this.mContext.bindService(intent, (ServiceConnection)this, 1);
    }

    public synchronized void unbind(Message message) {
        if (this.mMessengerService != null && message != null) {
            if (this.mMessengerActivity != null) {
                message.replyTo = this.mMessengerActivity;
            }
            try {
                this.mMessengerService.send(message);
            }
            catch (RemoteException e) {
                WtcLog.warn(TAG, "EXCEPTION: unbind(...)", e);
            }
        }
        try {
            this.mContext.unbindService((ServiceConnection)this);
        }
        catch (IllegalArgumentException e) {
            WtcLog.warn(TAG, "EXCEPTION: unbind(...)", e);
        }
        this.mIsBound = false;
    }

    public void stop(Message message) {
        if (this.mIsBound) {
            this.unbind(message);
        }
        Intent intent = new Intent(this.mContext, this.mClassService);
        boolean wasStopped = this.mContext.stopService(intent);
        this.mIsStarted = false;
    }

    public synchronized void onServiceConnected(ComponentName name, IBinder service) {
        WtcLog.debug(TAG, "+onServiceConnected(\"" + name + "\", " + service + ")");
        WtcUtilsPlatform.toastShort(this.mContext, name.getShortClassName() + " Connected");
        if (name.getClassName().equals(this.mClassService.getCanonicalName())) {
            this.mMessengerService = new Messenger(service);
            this.mIsBound = true;
            if (this.mMessageOnServiceConnected != null) {
                try {
                    this.mMessageOnServiceConnected.replyTo = this.mMessengerActivity;
                    this.mMessengerService.send(this.mMessageOnServiceConnected);
                }
                catch (RemoteException e) {
                    WtcLog.warn(TAG, "Unable to register client to service.", e);
                }
            }
        }
        WtcLog.debug(TAG, "-onServiceConnected(\"" + name + "\", " + service + ")");
    }

    public synchronized void onServiceDisconnected(ComponentName name) {
        WtcLog.debug(TAG, "+onServiceDisconnected(\"" + name + "\")");
        WtcUtilsPlatform.toastShort(this.mContext, name.getShortClassName() + " Disconnected");
        this.mMessengerService = null;
        this.mIsBound = false;
        WtcLog.debug(TAG, "-onServiceDisconnected(\"" + name + "\")");
    }

    public void send(Message message) {
        WtcLog.debug(TAG, "+send(" + message + ")");
        if (this.mMessengerService != null) {
            try {
                this.mMessengerService.send(message);
            }
            catch (RemoteException e) {
                WtcLog.warn(TAG, "could not send message " + message, e);
            }
        }
        WtcLog.debug(TAG, "-send(" + message + ")");
    }
}

