/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcLocatorException;
import com.twistpair.wave.thinclient.net.WtcInetSocketAddressPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WtcProxyInfo {
    private String serverId;
    private int proxyIndex;
    private WtcInetSocketAddressPlatform[] inetSocketAddresses;
    private String softwareVersionCheckURL;

    public static String toString(WtcProxyInfo[] proxyInfos) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < proxyInfos.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(proxyInfos[i].toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public WtcProxyInfo(WtcInetSocketAddressPlatform inetSocketAddress) {
        this.initialize(null, -1, new WtcInetSocketAddressPlatform[]{inetSocketAddress}, null);
    }

    public WtcProxyInfo(Node proxyNode) throws WtcLocatorException.WtcLocatorResponseInvalidException {
        NamedNodeMap attributes = proxyNode.getAttributes();
        if (attributes == null) {
            throw new WtcLocatorException.WtcLocatorResponseInvalidException("Proxy node has no attributes", proxyNode);
        }
        String serverId = attributes.getNamedItem("ServerID").getNodeValue();
        String proxyIndex = attributes.getNamedItem("ProxyIndex").getNodeValue();
        String address1 = attributes.getNamedItem("Address1").getNodeValue();
        String port1 = attributes.getNamedItem("Port1").getNodeValue();
        String address2 = attributes.getNamedItem("Address2").getNodeValue();
        String port2 = attributes.getNamedItem("Port2").getNodeValue();
        String softwareVersionCheckURL = attributes.getNamedItem("SoftwareVersionCheckURL").getNodeValue();
        if (WtcString.isNullOrEmpty(serverId) || WtcString.isNullOrEmpty(proxyIndex) || WtcString.isNullOrEmpty(address1) || WtcString.isNullOrEmpty(port1)) {
            throw new WtcLocatorException.WtcLocatorResponseInvalidException("Proxy node missing required attributes: ServerID, ProxyIndex, Address1, Port1", proxyNode);
        }
        WtcInetSocketAddressPlatform[] inetSocketAddresses = WtcString.isNullOrEmpty(address2) || WtcString.isNullOrEmpty(port2) ? new WtcInetSocketAddressPlatform[]{new WtcInetSocketAddressPlatform(address1, Integer.parseInt(port1))} : new WtcInetSocketAddressPlatform[]{new WtcInetSocketAddressPlatform(address1, Integer.parseInt(port1)), new WtcInetSocketAddressPlatform(address2, Integer.parseInt(port2))};
        this.initialize(serverId, Integer.parseInt(proxyIndex), inetSocketAddresses, softwareVersionCheckURL);
    }

    private void initialize(String serverId, int proxyIndex, WtcInetSocketAddressPlatform[] inetSocketAddresses, String softwareVersionCheckURL) {
        if (inetSocketAddresses == null || inetSocketAddresses.length == 0) {
            throw new IllegalArgumentException("inetSocketAddresses cannot be null or empty");
        }
        this.serverId = serverId;
        this.proxyIndex = proxyIndex;
        this.inetSocketAddresses = inetSocketAddresses;
        this.softwareVersionCheckURL = softwareVersionCheckURL;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("{serverId=\"").append(this.serverId).append("\", proxyIndex=").append(this.proxyIndex).append(", inetSocketAddresses=[");
        for (int i = 0; i < this.inetSocketAddresses.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.inetSocketAddresses[i]);
        }
        sb.append("], softwareVersionCheckURL=\"").append(this.softwareVersionCheckURL).append("\"}").toString();
        return sb.toString();
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getProxyIndex() {
        return this.proxyIndex;
    }

    public WtcInetSocketAddressPlatform[] getInetSocketAddresses() {
        return this.inetSocketAddresses;
    }

    public String getSoftwareVersionCheckURL() {
        return this.softwareVersionCheckURL;
    }
}

