/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcConnectionStatistics;
import com.twistpair.wave.thinclient.WtcPingRequestRxTimeout;
import com.twistpair.wave.thinclient.WtcStackException;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.WtcpMessage;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpMediaHeader;
import com.twistpair.wave.thinclient.util.IntegerPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public class WtcMessageFilter {
    private static final String TAG = WtcLog.TAG(WtcMessageFilter.class);
    private static final boolean REQUEST_TIMEOUT_DISABLED = false;
    private static final boolean VERBOSE_LOG = false;
    private final Hashtable latestOpCodeRequestTransactionId;
    private final Hashtable tasksControl;
    private final IRequestTxResponseRxTimeoutListener listenerRequestTxResponseRxTimeout;
    private final WtcConnectionStatistics connectionStatistics;
    private int requestTxResponseRxTimeoutMs = 30000;
    private RequestTxResponseRxTimeoutTask taskKex;
    private Timer timer;
    private WtcPingRequestRxTimeout timeoutPingRequestRx;

    public WtcMessageFilter(IRequestTxResponseRxTimeoutListener listenerRequestTxResponseRxTimeout, WtcPingRequestRxTimeout.IPingRequestRxTimeoutListener listenerPingRequestRxTimeout, WtcConnectionStatistics connectionStatistics) {
        this.listenerRequestTxResponseRxTimeout = listenerRequestTxResponseRxTimeout;
        this.connectionStatistics = connectionStatistics;
        this.latestOpCodeRequestTransactionId = new Hashtable();
        this.tasksControl = new Hashtable();
        this.timer = new Timer();
        this.timeoutPingRequestRx = new WtcPingRequestRxTimeout(listenerPingRequestRxTimeout, connectionStatistics);
        this.timeoutPingRequestRx.reset(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            WtcLog.info(TAG, "+close()");
            if (this.timeoutPingRequestRx != null) {
                WtcLog.info(TAG, "timeoutPingRequestRx.close()");
                this.timeoutPingRequestRx.close();
                this.timeoutPingRequestRx = null;
            }
            WtcMessageFilter wtcMessageFilter = this;
            synchronized (wtcMessageFilter) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.taskKex = null;
                Hashtable hashtable = this.tasksControl;
                synchronized (hashtable) {
                    this.tasksControl.clear();
                }
                hashtable = this.latestOpCodeRequestTransactionId;
                synchronized (hashtable) {
                    this.latestOpCodeRequestTransactionId.clear();
                }
            }
        }
        finally {
            WtcLog.info(TAG, "-close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(WtcpMessage message) {
        RequestTxResponseRxTimeoutTask task;
        WtcMessageFilter wtcMessageFilter;
        int requestTxResponseRxTimeoutMs = this.requestTxResponseRxTimeoutMs;
        byte messageType = message.getMessageType();
        switch (messageType) {
            case 3: {
                wtcMessageFilter = this;
                synchronized (wtcMessageFilter) {
                    if (this.taskKex != null) {
                        throw new IllegalStateException("KEX message already in progress");
                    }
                    this.taskKex = task = new RequestTxResponseRxTimeoutTask(requestTxResponseRxTimeoutMs, messageType, -1, -1);
                    break;
                }
            }
            case 4: {
                WtcpControlHeader controlHeader = (WtcpControlHeader)message.getSubHeader();
                int opType = controlHeader.verOpCode.getOpType();
                if (opType == 1) {
                    Integer opCode = IntegerPlatform.valueOf(controlHeader.verOpCode.getOpCode());
                    Integer transactionId = IntegerPlatform.valueOf(controlHeader.transactionId);
                    Hashtable hashtable = this.latestOpCodeRequestTransactionId;
                    synchronized (hashtable) {
                        this.latestOpCodeRequestTransactionId.put(opCode, transactionId);
                    }
                    task = new RequestTxResponseRxTimeoutTask(requestTxResponseRxTimeoutMs, messageType, opCode, transactionId);
                    hashtable = this.tasksControl;
                    synchronized (hashtable) {
                        this.tasksControl.put(transactionId, task);
                        break;
                    }
                }
                task = null;
                break;
            }
            default: {
                task = null;
            }
        }
        if (task != null) {
            wtcMessageFilter = this;
            synchronized (wtcMessageFilter) {
                if (this.timer != null) {
                    this.timer.schedule((TimerTask)task, requestTxResponseRxTimeoutMs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(WtcpMessage message) throws WtcStackException.WtcStackMessageReceiveResponseUnexpectedException {
        TimerTask task;
        boolean shouldIgnore = false;
        byte messageType = message.getMessageType();
        block6 : switch (messageType) {
            case 3: {
                WtcMessageFilter wtcMessageFilter = this;
                synchronized (wtcMessageFilter) {
                    task = this.taskKex;
                    this.taskKex = null;
                    break;
                }
            }
            case 4: {
                WtcpControlHeader controlHeader = (WtcpControlHeader)message.getSubHeader();
                int opType = controlHeader.verOpCode.getOpType();
                int opCode = controlHeader.verOpCode.getOpCode();
                block11 : switch (opType) {
                    case 2: 
                    case 4: {
                        Integer latestTransactionId;
                        int transactionId = controlHeader.transactionId;
                        Hashtable hashtable = this.tasksControl;
                        synchronized (hashtable) {
                            task = (RequestTxResponseRxTimeoutTask)this.tasksControl.remove(IntegerPlatform.valueOf(transactionId));
                        }
                        boolean handleMessage = opType == 2;
                        if (!(handleMessage |= opType == 4 && (opCode == 38 || opCode == 39))) break block6;
                        if (this.timeoutPingRequestRx != null) {
                            this.timeoutPingRequestRx.reset(false);
                        }
                        Hashtable hashtable2 = this.latestOpCodeRequestTransactionId;
                        synchronized (hashtable2) {
                            Integer opCodeValue = IntegerPlatform.valueOf(opCode);
                            latestTransactionId = (Integer)this.latestOpCodeRequestTransactionId.get(opCodeValue);
                            if (opCode == 38) {
                                Integer latestCallPushToTalkOffTransactionId = (Integer)this.latestOpCodeRequestTransactionId.get(IntegerPlatform.valueOf(39));
                                if (latestCallPushToTalkOffTransactionId != null) {
                                    WtcLog.info(TAG, "Call PTT OFF is in transit; ignoring Call PTT ON response");
                                    latestTransactionId = latestCallPushToTalkOffTransactionId;
                                }
                            } else if (opCode == 39) {
                                this.latestOpCodeRequestTransactionId.remove(opCodeValue);
                            }
                        }
                        if (latestTransactionId == null) {
                            WtcLog.error(TAG, "UNEXPECTED: RXed Response for non-tracked Request; opCode=" + WtcpConstants.WtcpOpCode.toString(opCode) + "; transactionId=" + transactionId);
                            throw new WtcStackException.WtcStackMessageReceiveResponseUnexpectedException(opCode, transactionId);
                        }
                        switch (opCode) {
                            case 10: 
                            case 13: 
                            case 14: 
                            case 32: 
                            case 35: 
                            case 38: 
                            case 39: {
                                shouldIgnore = latestTransactionId != transactionId;
                                break block11;
                            }
                        }
                        shouldIgnore = false;
                        break;
                    }
                    case 1: {
                        if (this.timeoutPingRequestRx != null) {
                            this.timeoutPingRequestRx.reset(true);
                        }
                        task = null;
                        break;
                    }
                    default: {
                        task = null;
                        break;
                    }
                }
                break;
            }
            case 5: {
                task = null;
                shouldIgnore = false;
                break;
            }
            default: {
                task = null;
            }
        }
        if (task != null) {
            task.cancel();
            int latencyMs = ((RequestTxResponseRxTimeoutTask)task).getElapsedMs();
            switch (((RequestTxResponseRxTimeoutTask)task).messageType) {
                case 3: {
                    WtcLog.warn(TAG, "$LATENCY: KEX = " + latencyMs + "ms");
                    break;
                }
                case 4: {
                    switch (((RequestTxResponseRxTimeoutTask)task).opCode) {
                        case 13: {
                            WtcLog.warn(TAG, "$LATENCY: PTT = " + latencyMs + "ms");
                        }
                    }
                }
            }
            this.requestTxResponseRxTimeoutMs = this.connectionStatistics.latency.add(latencyMs);
        }
        return shouldIgnore;
    }

    public class WtcpMediaMessageFilter {
        public void add(WtcpMediaHeader mediaHeader) {
        }
    }

    private class RequestTxResponseRxTimeoutTask
    extends TimerTask {
        private final String TAG = WtcLog.TAG(RequestTxResponseRxTimeoutTask.class);
        public final long timeCreated = System.currentTimeMillis();
        public final int timeoutMs;
        public final byte messageType;
        public final int opCode;
        public final int transactionId;

        public RequestTxResponseRxTimeoutTask(int timeoutMs, byte messageType, int opCode, int transactionId) {
            this.timeoutMs = timeoutMs;
            this.messageType = messageType;
            this.opCode = opCode;
            this.transactionId = transactionId;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("timeCreated=").append(this.timeCreated).append(", timeoutMs=").append(this.timeoutMs).append(", messageType=").append(WtcpConstants.WtcpMessageType.toString(this.messageType));
            if (this.messageType == 4) {
                sb.append('{').append("opCode=").append(WtcpConstants.WtcpOpCode.toString(this.opCode)).append(", transactionId=0x").append(WtcString.toHexString(this.transactionId, 2)).append('}');
            }
            return sb.toString();
        }

        public int getElapsedMs() {
            return (int)(System.currentTimeMillis() - this.timeCreated);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WtcLog.info(this.TAG, "+run()");
                int elapsedMs = this.getElapsedMs();
                WtcMessageFilter wtcMessageFilter = WtcMessageFilter.this;
                synchronized (wtcMessageFilter) {
                    block10: {
                        if (WtcMessageFilter.this.timer != null) break block10;
                        return;
                    }
                    WtcMessageFilter.this.listenerRequestTxResponseRxTimeout.onRequestTxResponseRxTimeout(this.timeoutMs, elapsedMs, this.messageType, this.opCode, this.transactionId);
                }
            }
            catch (Exception e) {
                WtcLog.error(this.TAG, "run()", e);
            }
            finally {
                WtcLog.info(this.TAG, "-run()");
            }
        }
    }

    public static interface IRequestTxResponseRxTimeoutListener {
        public void onRequestTxResponseRxTimeout(long var1, long var3, byte var5, int var6, int var7);
    }
}

