/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcLocatorException;
import com.twistpair.wave.thinclient.WtcLocatorResponse;
import com.twistpair.wave.thinclient.kexcrypto.WtcCryptoUtilPlatform;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.net.WtcNet;
import com.twistpair.wave.thinclient.net.WtcUri;
import com.twistpair.wave.thinclient.net.WtcUriPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import java.io.IOException;
import org.w3c.dom.Element;

public class WtcLocator {
    private static final String TAG = WtcLog.TAG(WtcLocator.class);
    private static final String DEFAULT_WAVE_LOCATOR_PATH = "/wave/_interface/proxy_locator.asp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WtcLocatorResponse locateProxies(WtcUri uriLocator) throws IOException, WtcLocatorException.WtcLocatorResponseInvalidException {
        try {
            WtcLog.info(TAG, "+locateProxies(" + uriLocator + ")");
            Element xmlDoc = WtcNet.makeRequestXml(uriLocator);
            WtcLocatorResponse wtcLocatorResponse = new WtcLocatorResponse(xmlDoc);
            return wtcLocatorResponse;
        }
        finally {
            WtcLog.info(TAG, "-locateProxies(" + uriLocator + ")");
        }
    }

    public static WtcUri verifyQuery(WtcUri uri, String key, long defaultValue) {
        return WtcLocator.verifyQuery(uri, key, String.valueOf(defaultValue));
    }

    public static WtcUri verifyQuery(WtcUri uri, String key, String defaultValue) {
        String queryParameter = uri.getQueryParameter(key);
        if (WtcString.isNullOrEmpty(queryParameter)) {
            WtcUri.Builder builder = uri.buildUpon();
            builder.appendQueryParameter(key, defaultValue);
            uri = builder.build();
        }
        return uri;
    }

    public static WtcUri createLocatorUri(String uriString) {
        return WtcLocator.createLocatorUri(uriString, null, null);
    }

    public static WtcUri createLocatorUri(String uriString, boolean ssl) {
        return WtcLocator.createLocatorUri(WtcLocator.prependRequestProtocol(uriString, ssl), null, null);
    }

    public static WtcUri createLocatorUri(String uriString, boolean ssl, String packageCode, String appVersion) {
        return WtcLocator.createLocatorUri(WtcLocator.prependRequestProtocol(uriString, ssl), packageCode, appVersion);
    }

    public static WtcUri createLocatorUri(String uriString, String packageCode, String appVersion) {
        if (WtcString.isNullOrEmpty(uriString)) {
            throw new IllegalArgumentException("uriString cannot be null or empty");
        }
        WtcUri uriLocator = WtcUriPlatform.parse(uriString);
        String host = ((WtcUri)uriLocator).getHost();
        if (WtcString.isNullOrEmpty(host)) {
            throw new IllegalArgumentException("uriString must contain a host");
        }
        String path = ((WtcUri)uriLocator).getPath();
        if (WtcString.isNullOrEmpty(path)) {
            WtcUri.Builder builder = ((WtcUri)uriLocator).buildUpon();
            builder.path(DEFAULT_WAVE_LOCATOR_PATH);
            uriLocator = builder.build();
        }
        uriLocator = WtcLocator.verifyQuery(uriLocator, "action", "getproxy");
        if (!WtcString.isNullOrEmpty(packageCode)) {
            uriLocator = WtcLocator.verifyQuery(uriLocator, "pc", packageCode);
        }
        if (!WtcString.isNullOrEmpty(appVersion)) {
            uriLocator = WtcLocator.verifyQuery(uriLocator, "ver", appVersion);
        }
        uriLocator = WtcLocator.verifyQuery(uriLocator, "nonce", WtcCryptoUtilPlatform.getRandomInt64());
        return uriLocator;
    }

    private static String prependRequestProtocol(String uriString, boolean ssl) {
        if (WtcString.isNullOrEmpty(uriString)) {
            throw new IllegalArgumentException("uriString cannot be null or empty");
        }
        if (!uriString.startsWith("wtcp")) {
            if (ssl && !uriString.startsWith("https")) {
                if (uriString.startsWith("http://")) {
                    uriString = WtcString.replaceFirst(uriString, "http://", "");
                }
                uriString = "https://" + uriString;
            } else {
                if (uriString.startsWith("https://")) {
                    uriString = WtcString.replaceFirst(uriString, "https://", "");
                }
                uriString = "http://" + uriString;
            }
        }
        return uriString;
    }
}

