/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcClient;
import com.twistpair.wave.thinclient.WtcClientListener;
import com.twistpair.wave.thinclient.WtcClientPhoneCallManager;
import com.twistpair.wave.thinclient.WtcClientPhoneLine;
import com.twistpair.wave.thinclient.WtcStack;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.types.WtcpErrorCode;
import com.twistpair.wave.thinclient.protocol.types.WtcpStringList;
import com.twistpair.wave.thinclient.util.WtcString;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class WtcClientPhoneLineManager {
    private static final String TAG = WtcLog.TAG(WtcClientPhoneLineManager.class);
    public static final int REACTIVATE_INTERVAL_SECONDS_DEFAULT = 30;
    private final WtcClient mClient;
    private final WtcClientListener mListener;
    private final Object mSyncLock = new Object();
    private final Vector mPhoneLineNumbers = new Vector();
    private final Hashtable mPhoneLines = new Hashtable();
    private final Hashtable mLineActivationTransactionIdToPhoneLine = new Hashtable();
    private final Hashtable mReactivationTimerTasks = new Hashtable();
    private Timer mReactivationTimer;
    private int mReactivateIntervalSeconds = 30;

    protected WtcClientPhoneLineManager(WtcClient client, WtcClientListener listener, WtcStack stack, WtcpStringList phoneLineNumbers) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (stack == null) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        if (phoneLineNumbers == null) {
            throw new IllegalArgumentException("phoneLineNumbers cannot be null");
        }
        this.mClient = client;
        this.mListener = listener;
        this.mReactivationTimer = new Timer();
        Enumeration enumerator = phoneLineNumbers.elements();
        while (enumerator.hasMoreElements()) {
            String phoneLineNumber = (String)enumerator.nextElement();
            this.mPhoneLineNumbers.addElement(phoneLineNumber);
            WtcClientPhoneLine phoneLine = new WtcClientPhoneLine(stack, this, phoneLineNumber);
            this.mPhoneLines.put(phoneLineNumber, phoneLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        WtcLog.info(TAG, "+clear()");
        Object object = this.mSyncLock;
        synchronized (object) {
            if (this.mReactivationTimer != null) {
                this.mReactivationTimer.cancel();
                this.mReactivationTimer = null;
            }
            this.mReactivationTimerTasks.clear();
            this.mPhoneLineNumbers.removeAllElements();
            this.mPhoneLines.clear();
            this.mLineActivationTransactionIdToPhoneLine.clear();
        }
        WtcLog.info(TAG, "-clear()");
    }

    public WtcClientPhoneCallManager getPhoneCallManager() {
        return this.mClient.getPhoneCallManager();
    }

    public Enumeration getPhoneLineNumbers() {
        return this.mPhoneLineNumbers.elements();
    }

    public int getPhoneLineCount() {
        return this.mPhoneLineNumbers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcClientPhoneLine getPhoneLine(int index) {
        WtcClientPhoneLine phoneLine = null;
        Object object = this.mSyncLock;
        synchronized (object) {
            String phoneLineNumber;
            if (index >= 0 && index < this.mPhoneLineNumbers.size() && (phoneLineNumber = (String)this.mPhoneLineNumbers.elementAt(index)) != null) {
                phoneLine = this.getPhoneLine(phoneLineNumber);
            }
        }
        return phoneLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcClientPhoneLine getPhoneLine(String phoneLineNumber) {
        Object object = this.mSyncLock;
        synchronized (object) {
            return (WtcClientPhoneLine)this.mPhoneLines.get(phoneLineNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReactivateIntervalSeconds(int intervalSeconds) {
        Object object = this.mSyncLock;
        synchronized (object) {
            this.mReactivateIntervalSeconds = intervalSeconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reactivationTimerStart(WtcClientPhoneLine phoneLine) {
        WtcLog.info(TAG, "+reactivationTimerStart(phoneLine=" + phoneLine + ")");
        Object object = this.mSyncLock;
        synchronized (object) {
            if (this.mReactivateIntervalSeconds > 0) {
                this.reactivationTimerCancel(phoneLine);
                if (this.mReactivationTimer != null) {
                    ReactivationTimerTask task = new ReactivationTimerTask(phoneLine);
                    this.mReactivationTimerTasks.put(phoneLine, task);
                    int milliseconds = this.mReactivateIntervalSeconds * 1000;
                    WtcLog.warn(TAG, "reactivationTimerStart: +mReactivationTimer.schedule(task, " + milliseconds + ")");
                    this.mReactivationTimer.schedule((TimerTask)task, milliseconds);
                    WtcLog.warn(TAG, "reactivationTimerStart: -mReactivationTimer.schedule(task, " + milliseconds + ")");
                }
            }
        }
        WtcLog.info(TAG, "-reactivationTimerStart(phoneLine=" + phoneLine + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reactivationTimerCancel(WtcClientPhoneLine phoneLine) {
        WtcLog.info(TAG, "+reactivationTimerCancel(phoneLine=" + phoneLine + ")");
        Object object = this.mSyncLock;
        synchronized (object) {
            ReactivationTimerTask task = (ReactivationTimerTask)this.mReactivationTimerTasks.remove(phoneLine);
            if (task != null) {
                WtcLog.warn(TAG, "reactivationTimerCancel: +task.cancel()");
                task.cancel();
                WtcLog.warn(TAG, "reactivationTimerCancel: -task.cancel()");
            } else {
                WtcLog.warn(TAG, "mReactivationTimerTasks.remove(" + phoneLine + ") returned null!");
            }
        }
        WtcLog.info(TAG, "-reactivationTimerCancel(phoneLine=" + phoneLine + ")");
    }

    public Integer activate(String[] phoneLines) {
        String phoneLineNumber = phoneLines[0];
        WtcClientPhoneLine phoneLine = this.getPhoneLine(phoneLineNumber);
        return phoneLine == null ? null : this.activate(phoneLine, true);
    }

    public Integer activate(WtcpStringList phoneLines) {
        String phoneLineNumber = (String)phoneLines.elementAt(0);
        WtcClientPhoneLine phoneLine = this.getPhoneLine(phoneLineNumber);
        return phoneLine == null ? null : phoneLine.activate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer activate(WtcClientPhoneLine phoneLine, boolean on) {
        Integer n;
        Integer transactionId = null;
        try {
            WtcLog.info(TAG, "+activate(phoneLine=" + phoneLine + ", on=" + on + ")");
            phoneLine.mIsActivated = false;
            if (on) {
                String phoneLineNumber = phoneLine.getNumber();
                transactionId = phoneLine.getStack().sendPhoneLineSetActive(phoneLineNumber);
                if (transactionId != null) {
                    Object object = this.mSyncLock;
                    synchronized (object) {
                        this.mLineActivationTransactionIdToPhoneLine.put(transactionId, phoneLineNumber);
                    }
                }
            } else {
                throw new UnsupportedOperationException("phone line deactivation is currently not supported");
            }
            n = transactionId;
        }
        catch (Throwable throwable) {
            WtcLog.info(TAG, "-activate(phoneLine=" + phoneLine + ", on=" + on + "); return " + transactionId);
            throw throwable;
        }
        WtcLog.info(TAG, "-activate(phoneLine=" + phoneLine + ", on=" + on + "); return " + transactionId);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPhoneLinesSetActive(WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        String signature = "onPhoneLinesSetActive(..., errorCode=" + errorCode + ")";
        boolean isOK = errorCode.isOK();
        try {
            if (isOK) {
                WtcLog.info(TAG, "+" + signature);
            } else {
                WtcLog.warn(TAG, "+" + signature);
            }
            Integer transactionId = new Integer(controlHeader.transactionId);
            WtcClientPhoneLine phoneLine = null;
            Object object = this.mSyncLock;
            synchronized (object) {
                String phoneLineNumber = (String)this.mLineActivationTransactionIdToPhoneLine.remove(transactionId);
                phoneLine = this.getPhoneLine(phoneLineNumber);
            }
            boolean handled = false;
            if (phoneLine != null) {
                if (errorCode.isOK() || errorCode.getErrorCode() == 26) {
                    this.reactivationTimerStart(phoneLine);
                }
                if (this.mListener != null) {
                    handled = this.mListener.onPhoneLineActivating(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneLine, errorCode);
                }
            } else {
                WtcLog.warn(TAG, "mLineActivationTransactionIdToPhoneLine.remove(" + transactionId + ") returned null!");
            }
            if (!handled && this.mListener != null) {
                this.mListener.onPhoneLineSetActive(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, errorCode);
            }
        }
        finally {
            if (isOK) {
                WtcLog.info(TAG, "-" + signature);
            } else {
                WtcLog.warn(TAG, "-" + signature);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPhoneLineStatus(WtcpControlHeader controlHeader, String phoneLineNumber, WtcpErrorCode errorCode) {
        String signature = "onPhoneLineStatus(..., phoneLineNumber=" + WtcString.quote(phoneLineNumber) + ", errorCode=" + errorCode + ")";
        boolean isOK = errorCode.isOK();
        try {
            if (isOK) {
                WtcLog.info(TAG, "+" + signature);
            } else {
                WtcLog.warn(TAG, "+" + signature);
            }
            WtcClientPhoneLine phoneLine = this.getPhoneLine(phoneLineNumber);
            boolean handled = false;
            if (phoneLine != null) {
                phoneLine.mIsActivated = isOK;
                if (isOK) {
                    this.reactivationTimerCancel(phoneLine);
                    if (this.mListener != null) {
                        handled = this.mListener.onPhoneLineActivated(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneLine);
                    }
                } else {
                    if (errorCode.getErrorCode() == 26) {
                        this.reactivationTimerStart(phoneLine);
                    }
                    if (this.mListener != null) {
                        handled = this.mListener.onPhoneLineDeactivated(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneLine, errorCode);
                    }
                }
            }
            if (!handled && this.mListener != null) {
                this.mListener.onPhoneLineStatus(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneLineNumber, errorCode);
            }
        }
        finally {
            if (isOK) {
                WtcLog.info(TAG, "-" + signature);
            } else {
                WtcLog.warn(TAG, "-" + signature);
            }
        }
    }

    private static class ReactivationTimerTask
    extends TimerTask {
        private static final String TAG = WtcLog.TAG(ReactivationTimerTask.class);
        private final WtcClientPhoneLine mPhoneLine;

        public ReactivationTimerTask(WtcClientPhoneLine phoneLine) {
            this.mPhoneLine = phoneLine;
        }

        @Override
        public void run() {
            WtcLog.info(TAG, "+run()");
            try {
                this.mPhoneLine.activate(true);
            }
            catch (Exception e) {
                WtcLog.error(TAG, "run: EXCEPTION", e);
            }
            WtcLog.info(TAG, "-run()");
        }
    }
}

