package com.twistpair.wave.thinclient.util;

public class WtcVersionString
{
    private final int major;
    private final int minor;
    private final int build;
    private final int revision;

    public WtcVersionString(String versionString)
    {
        String[] versionParts = WtcString.split(versionString, ".", 0);
        if (versionParts.length != 4)
        {
            throw new IllegalArgumentException("versionString must be of format \"1.2.3.4\"");
        }

        major = Integer.parseInt(versionParts[0]);
        minor = Integer.parseInt(versionParts[1]);
        build = Integer.parseInt(versionParts[2]);
        revision = Integer.parseInt(versionParts[3]);
    }

    public int getMajor()
    {
        return major;
    }

    public int getMinor()
    {
        return minor;
    }

    public int getBuild()
    {
        return build;
    }

    public int getRevision()
    {
        return revision;
    }

    public String toString()
    {
        return major + "." + minor + "." + build + "." + revision;
    }

    public int compare(Object o)
    {
        if (!(o instanceof WtcVersionString))
        {
            throw new IllegalArgumentException("Argument must be of type VersionString");
        }
        return compare((WtcVersionString) o);
    }

    /**
     * IMPORTANT: 0.0.0.12345 is *GREATER* than 5.1.0.12344!
     * @param o
     * @return an integer < 0 if o is less than this, 0 if o is equal to this, and > 0 if o is greater than this.
     */
    public int compare(WtcVersionString o)
    {
        if (o == null)
            return 1;

        if (this.revision != o.revision)
            if (this.revision > o.revision)
                return 1;
            else
                return -1;

        if (this.major != o.major)
            if (this.major > o.major)
                return 1;
            else
                return -1;

        if (this.minor != o.minor)
            if (this.minor > o.minor)
                return 1;
            else
                return -1;

        if (this.build != o.build)
            if (this.build > o.build)
                return 1;
            else
                return -1;

        return 0;
    }

    public int hashCode()
    {
        int result = 17;
        result = 31 * result + major;
        result = 31 * result + minor;
        result = 31 * result + build;
        result = 31 * result + revision;
        return result;
    }

    public boolean equals(Object o)
    {
        if (!(o instanceof WtcVersionString))
        {
            throw new IllegalArgumentException("Argument must be of type VersionString");
        }
        return equals((WtcVersionString) o);
    }

    public boolean equals(WtcVersionString o)
    {
        return this.compare(o) == 0;
    }

    public boolean greaterThan(WtcVersionString o)
    {
        return this.compare(o) == 1;
    }

    public boolean lessThan(WtcVersionString o)
    {
        return this.compare(o) == -1;
    }
}
