package com.twistpair.wave.thinclient.util;

public class WtcUInt8 extends WtcScalar
{
    public final short value;

    public WtcUInt8(int value)
    {
        super(false);
        this.value = (short) value;
    }

    public WtcUInt8(IWtcMemoryStream inputStream)
    {
        this(inputStream.readUInt8());
    }

    public String toString()
    {
        return String.valueOf(value);
    }

    public boolean equals(Object o)
    {
        if (o == null || !(o instanceof WtcUInt8))
        {
            return false;
        }

        return this.value == ((WtcUInt8) o).value;
    }

    public int hashCode()
    {
        int result = 17;
        result = 31 * result + value;
        return result;
    }
}
