package com.twistpair.wave.thinclient.util;

public class StereoVolume
{
    public static final int MAX   = 100;
    public static final int MIN   = 0;

    private int             left  = MAX;
    private int             right = MAX;

    public StereoVolume()
    {
        set(MAX, MAX);
    }

    public StereoVolume(int left, int right)
    {
        set(left, right);
    }

    public void set(int left, int right)
    {
        setLeft(left);
        setRight(right);
    }

    public int getLeft()
    {
        return left;
    }

    public void setLeft(int level)
    {
        if (level < MIN || level > MAX)
        {
            throw new IllegalArgumentException("level must be >= " + MIN + " and <= " + MAX);
        }
        left = level;
    }

    public int getRight()
    {
        return right;
    }

    public void setRight(int level)
    {
        if (level < MIN || level > MAX)
        {
            throw new IllegalArgumentException("level must be >= " + MIN + " and <= " + MAX);
        }
        right = level;
    }

    public boolean equals(Object o)
    {
        if (o == null)
        {
            return false;
        }

        if (o instanceof StereoVolume)
        {
            return ((StereoVolume) o).left == left && ((StereoVolume) o).right == right;
        }

        return super.equals(o);
    }

    public String toString()
    {
        return new StringBuffer().append("[left=").append(left).append(",right=").append(right).append(']').toString();
    }
}
