package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;
import java.util.Hashtable;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

//
// BEGIN WtcpKeyValueList
//
/**
 * Wraps a "Hashtable&lt;String,String&gt" in to a IWtcpSendable and IWtcpReceivable object. 
 */
public class WtcpKeyValueList //
                extends Hashtable //
                implements IWtcpSendable, IWtcpReceivable
{
    public WtcpKeyValueList()
    {
        super();
    }

    public WtcpKeyValueList(Hashtable other)
    {
        super();
        Enumeration keys = other.keys();
        while (keys.hasMoreElements())
        {
            String key = keys.nextElement().toString();
            String value = other.get(key).toString();
            this.put(key, value);
        }
    }

    /**
     * WtcpKeyValueList contains String keys and values
     * @param inputStream
     */
    public WtcpKeyValueList(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        // A WtcpKeyValueList is received as a list of key/value pairs
        short listCount = inputStream.readInt16();

        // Convert the list of key/value pairs to a dictionary...
        String key;
        String value;
        int dictCount = (listCount / 2);
        for (int i = 0; i < dictCount; i++)
        {
            key = inputStream.readString();
            value = inputStream.readString();
            this.put(key, value);
        }
    }

    public void dumpHostToNetworkOrder(IWtcMemoryStream outputStream)
    {
        outputStream.writeInt16((short) (this.size() * 2));
        String key;
        Enumeration keys = this.keys();
        while (keys.hasMoreElements())
        {
            key = (String) keys.nextElement();
            outputStream.writeString(key);
            outputStream.writeString((String) this.get(key));
        }
    }

    public String toString()
    {
        Enumeration keys = this.keys();
        String key;
        String value;

        StringBuffer sb = new StringBuffer();
        sb.append('{');
        while (keys.hasMoreElements())
        {
            key = (String) keys.nextElement();
            value = (String) this.get(key);
            sb.append('\"').append(key).append('\"').append(':').append('\"').append(value).append('\"');
            if (keys.hasMoreElements())
            {
                sb.append(',');
            }
        }
        sb.append('}');
        return sb.toString();
    }
}
//
// END WtcpKeyValueList
//
