package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;

//
// BEGIN WtcpEndpointProperties
//
/**
 * A WtcpKeyValueList collection of properties for a specific WTCP endpoint ID.<br>
 * The user of this class is responsible for maintaining their own map&lt;ID,WtcpEndpointInfo&gt;.
 */
public class WtcpEndpointProperties //
                implements IWtcpReceivable
{
    public String           endpointId;
    public WtcpKeyValueList properties;

    public WtcpEndpointProperties(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        endpointId = inputStream.readString();
        properties = new WtcpKeyValueList(inputStream);
    }

    public String toString()
    {
        return new StringBuffer() //
        .append('{') //
        .append("endpointId=").append(WtcString.quote(endpointId)) //
        .append(", properties=").append(properties) //
        .append('}') //
        .toString();
    }
}
//
// END WtcpEndpointProperties
//
