package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.WtcpConstants.WtcpEndpointFlags;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcComparatorPlatform;
import com.twistpair.wave.thinclient.util.WtcString;

//
// BEGIN WtcpEndpointInfo
//
public class WtcpEndpointInfo //
                implements IWtcpReceivable
{
    public static final String                ID_SELF    = "1";

    public static final WtcComparatorPlatform COMPARATOR = new WtcComparatorPlatform()
                                                         {
                                                             public int compare(Object a, Object b)
                                                             {
                                                                 return ((WtcpEndpointInfo) a).displayName.compareTo(((WtcpEndpointInfo) b).displayName);
                                                             }
                                                         };

    private String                            id;

    /**
     * Any combination of WtcpEndpointFlags
     */
    private int                               flags;

    private String                            displayName;

    /*
    public WtcpEndpointInfo()
    {
    }
    */

    public WtcpEndpointInfo(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        id = inputStream.readString();
        flags = inputStream.readInt32();
        displayName = inputStream.readString();
    }

    public String toString()
    {
        return new StringBuffer() //
        .append('{') //
        .append("id=").append(WtcString.quote(id)) //
        .append(", flags=").append(WtcpEndpointFlags.toString(flags)) //
        .append(", displayName=").append(WtcString.quote(displayName)) //
        .append('}') //
        .toString();
    }

    public String getId()
    {
        return id;
    }

    public long getFlags()
    {
        return flags;
    }

    public String getDisplayName()
    {
        return displayName;
    }

    public boolean isSpeaking()
    {
        return ((flags & WtcpEndpointFlags.Speaking) == WtcpEndpointFlags.Speaking);
    }

    public boolean isVisible()
    {
        return ((flags & WtcpEndpointFlags.Visible) == WtcpEndpointFlags.Visible);
    }

    public boolean isSelf()
    {
        return ((flags & WtcpEndpointFlags.Self) == WtcpEndpointFlags.Self);
    }

    public boolean isPoint2Point()
    {
        return ((flags & WtcpEndpointFlags.Point2Point) == WtcpEndpointFlags.Point2Point);
    }
}
//
// END WtcpEndpointInfo
//
