package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcInt32;

//
// BEGIN WtcpChannelIdList
//
/**
 * WtcpList&lt;WtcInt32&gt; 
 */
public class WtcpChannelIdList //
                extends WtcpList //
                implements IWtcpSendable, IWtcpReceivable
{
    public WtcpChannelIdList()
    {
        super(WtcInt32.class);
    }

    public WtcpChannelIdList(WtcpChannelIdList channelIds)
    {
        super(WtcInt32.class, channelIds);
    }

    public WtcpChannelIdList(int[] channelIds)
    {
        this();
        addElements(channelIds);
    }

    public WtcpChannelIdList(IWtcMemoryStream inputStream)
    {
        this();
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        short count = inputStream.readInt16();
        int id;
        for (int i = 0; i < count; i++)
        {
            id = inputStream.readInt32();
            this.addElement(WtcInt32.valueOf(id, true));
        }
    }

    public void dumpHostToNetworkOrder(IWtcMemoryStream outputStream)
    {
        outputStream.writeInt16((short) this.size());
        WtcInt32 id;
        Enumeration elements = this.elements();
        while (elements.hasMoreElements())
        {
            id = (WtcInt32) elements.nextElement();
            outputStream.writeInt32(id.value);
        }
    }

    public void addElements(int[] channelIds)
    {
        if (channelIds != null)
        {
            for (int i = 0; i < channelIds.length; i++)
            {
                addElement(WtcInt32.valueOf(channelIds[i], true));
            }
        }
    }

    public boolean removeElements(int[] channelIds)
    {
        boolean found = false;
        if (channelIds != null)
        {
            for (int i = 0; i < channelIds.length; i++)
            {
                found |= removeElement(WtcInt32.valueOf(channelIds[i], true));
            }
        }
        return found;
    }
}
//
// END WtcpChannelIdList
//
