package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

//
// BEGIN WtcpChannelActivity
//
public class WtcpChannelActivity //
                implements IWtcpReceivable
{
    public int                  channelId;

    /**
     * Any combo of WtcpChannelFlags
     */
    public int                  channelFlags;

    /**
     * The total number of endpoints in the channel.
     * This number can be, and usually is, larger than the length of this activity event's "endpoints" field.
     */
    public short                endpointCount;

    /**
     * The endpoints that are reporting activity in this event.
     * Currently this activity is limited to the "Speaking" endpoints.
     */
    public WtcpEndpointInfoList activityEndpoints;

    public WtcpChannelActivity(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        channelId = inputStream.readInt32();
        channelFlags = inputStream.readInt16();
        endpointCount = inputStream.readInt16();
        activityEndpoints = new WtcpEndpointInfoList(inputStream);
    }

    public String toString()
    {
        return new StringBuffer() //
        .append("{channelId=").append(channelId) //
        .append(",channelFlags=").append(channelFlags) //
        .append(",endpointCount=").append(endpointCount) //
        .append(",activityEndpoints=").append(activityEndpoints) //
        .append('}') //
        .toString();
    }
}
//
// END WtcpChannelActivity
//
