package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

//
// BEGIN WtcpCallAnswer
//
public class WtcpCallAnswer //
                implements IWtcpReceivable
{
    public int           callId;
    public WtcpErrorCode errorCode;

    public WtcpCallAnswer(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        callId = inputStream.readInt32();
        errorCode = new WtcpErrorCode(inputStream);
    }

    public String toString()
    {
        return new StringBuffer() //
        .append('{') //
        .append("callId=").append(callId) //
        .append(", errorCode=").append(errorCode) //
        .append('}') //
        .toString();
    }
}
//
// END WtcpCallAnswer
//
