package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.protocol.WtcpConstants.WtcpAudioCodec;

public class WtcMediaDeviceFactoryPlatform extends WtcMediaDeviceFactory
{
    public WtcMediaDeviceFactoryPlatform()
    {
        super(WtcpAudioCodec.GSM_full_rate);
    }

    @Override
    public void setAudioCodec(byte audioCodecId) throws IllegalArgumentException
    {
        switch (audioCodecId)
        {
            case WtcpAudioCodec.PCM_Mono16bBigEndian8kHz:
                mAudioCodec = new WtcMediaCodecPcmPlatform();
                break;

            case WtcpAudioCodec.GSM_full_rate:
                mAudioCodec = new WtcMediaCodecGSMPlatform();
                break;

            default:
                throw new IllegalArgumentException("Unsupported codec: " + audioCodecId);
        }
        mAudioCodecId = audioCodecId;
    }
}
