package com.twistpair.wave.thinclient.media;

public class WtcMediaCodecGSMPlatform extends WtcMediaCodec
{
    private final GSMCodec codec;

    public WtcMediaCodecGSMPlatform()
    {
        codec = new GSMCodec();
    }

    @Override
    public String getName()
    {
        return codec.getName();
    }

    @Override
    public int getSampleRate()
    {
        return 8000;
    }

    @Override
    public int getMillisecondsPerFrame()
    {
        return 20;
    }

    @Override
    public int getBytesPerFrame()
    {
        return 160; // GSM decodes 160 byte frames
    }

    @Override
    protected boolean initialize()
    {
        return codec.initialize();
    }

    @Override
    public void close()
    {
        codec.close();
    }

    @Override
    public int decode(byte[] bufferEncoded, int length, short[] bufferUnencoded)
    {
        return codec.decode(bufferEncoded, length, bufferUnencoded);
    }

    @Override
    public int encode(short[] bufferUnencoded, int offset, int length, byte[] bufferEncoded)
    {
        return codec.encode(bufferUnencoded, offset, length, bufferEncoded);
    }
}