package com.twistpair.wave.thinclient.kexcrypto;

import junit.framework.Assert;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcKexCryptoClient extends WtcKexCryptoBase
{
    private static final String TAG               = WtcLog.TAG(WtcKexCryptoClient.class);

    public static boolean       VERBOSE_LOG       = false;

    public static final String  DEFAULT_KEX_GROUP = "";
    public static final int     DEFAULT_KEX_MODE  = WtcMessageCipherMode.AES256CTR;
    public static final int     DEFAULT_KEX_SIZE  = WtcKexPrimeSize.P4096;

    public interface WtcKexPrimeSize
    {
        int NONE  = 0;
        int P64   = 64;
        int P1024 = 1024;
        int P2048 = 2048;
        int P4096 = 4096;
        int P8192 = 8192;
    }

    // NOTE: In a real-world application you should consider dynamically pre-generating the below large prime numbers.
    // This can take a *very* long time (especially 4096 (nearly an hour) and 8192 (over a day)).

    // large "safe prime" numbers generated w/ the following cygwin commands:
    // openssl dhparam -noout -text 64
    public static byte[]            DH64_P           =
                                                     {
        // Just for comparison of how large the following numbers are...
        (byte) 0xE9, (byte) 0x08, (byte) 0x46, (byte) 0x83, (byte) 0xB0, (byte) 0x53, (byte) 0x5B, (byte) 0x0B,
                                                     };
    public static byte[]            DH64_G           =
                                                     {
                                                         0x02,
                                                     };

    // openssl dhparam -noout -C 1024
    public static byte[]            DH1024_P         =
                                                     {
        (byte) 0xEE, (byte) 0xA9, (byte) 0x47, (byte) 0x15, (byte) 0x33, (byte) 0x31, (byte) 0x57, (byte) 0xB5, (byte) 0xE9,
        (byte) 0xEE, (byte) 0x15, (byte) 0x52, (byte) 0x69, (byte) 0x48, (byte) 0x4C, (byte) 0xCE, (byte) 0x4E, (byte) 0x4B,
        (byte) 0xF3, (byte) 0x07, (byte) 0x05, (byte) 0xBB, (byte) 0x68, (byte) 0xC7, (byte) 0x0E, (byte) 0xF9, (byte) 0xC5,
        (byte) 0x67, (byte) 0xB4, (byte) 0x6F, (byte) 0x73, (byte) 0xD1, (byte) 0x7B, (byte) 0xF9, (byte) 0x12, (byte) 0xBD,
        (byte) 0xAE, (byte) 0xA9, (byte) 0xC5, (byte) 0x48, (byte) 0x1C, (byte) 0x0E, (byte) 0x0D, (byte) 0x74, (byte) 0x85,
        (byte) 0x0D, (byte) 0x61, (byte) 0x25, (byte) 0xD7, (byte) 0xF5, (byte) 0x71, (byte) 0x95, (byte) 0x8B, (byte) 0x76,
        (byte) 0x29, (byte) 0x4A, (byte) 0xAE, (byte) 0x43, (byte) 0x78, (byte) 0x97, (byte) 0x4C, (byte) 0x36, (byte) 0xDC,
        (byte) 0x3E, (byte) 0x42, (byte) 0xEE, (byte) 0xA2, (byte) 0xB8, (byte) 0xF9, (byte) 0x33, (byte) 0x7E, (byte) 0x8A,
        (byte) 0x67, (byte) 0x29, (byte) 0xFD, (byte) 0x11, (byte) 0x76, (byte) 0x6A, (byte) 0x6D, (byte) 0x3E, (byte) 0xB0,
        (byte) 0x31, (byte) 0x7C, (byte) 0x2D, (byte) 0x58, (byte) 0xEA, (byte) 0x52, (byte) 0x60, (byte) 0x8E, (byte) 0xE3,
        (byte) 0x0A, (byte) 0xD7, (byte) 0x7A, (byte) 0x0B, (byte) 0x77, (byte) 0x10, (byte) 0x7C, (byte) 0x6A, (byte) 0xD2,
        (byte) 0xB7, (byte) 0xD1, (byte) 0x16, (byte) 0x6F, (byte) 0xAB, (byte) 0x24, (byte) 0xC9, (byte) 0xED, (byte) 0x55,
        (byte) 0x73, (byte) 0x87, (byte) 0xAE, (byte) 0x37, (byte) 0x17, (byte) 0x73, (byte) 0x1B, (byte) 0x31, (byte) 0x08,
        (byte) 0xD7, (byte) 0x3E, (byte) 0x13, (byte) 0x82, (byte) 0xAE, (byte) 0x7C, (byte) 0x24, (byte) 0xC5, (byte) 0x00,
        (byte) 0x88, (byte) 0x53,
                                                     };
    public static byte[]            DH1024_G         =
                                                     {
                                                         (byte) 0x02,
                                                     };

    // openssl dhparam -noout -text 2048
    public static byte[]            DH2048_P         =
                                                     {
        (byte) 0x86, (byte) 0x16, (byte) 0x20, (byte) 0x52, (byte) 0x71, (byte) 0xB3, (byte) 0x87, (byte) 0xA3, (byte) 0xD5,
        (byte) 0x73, (byte) 0x33, (byte) 0xD3, (byte) 0x96, (byte) 0x3F, (byte) 0xA0, (byte) 0x89, (byte) 0x7D, (byte) 0xC7,
        (byte) 0xFA, (byte) 0xC9, (byte) 0x9C, (byte) 0x7E, (byte) 0x06, (byte) 0xCE, (byte) 0x62, (byte) 0x27, (byte) 0xC9,
        (byte) 0xA5, (byte) 0xF3, (byte) 0xA4, (byte) 0x24, (byte) 0x0D, (byte) 0x7F, (byte) 0xE9, (byte) 0x4D, (byte) 0xDF,
        (byte) 0x05, (byte) 0x5B, (byte) 0x4D, (byte) 0x5F, (byte) 0x17, (byte) 0xCF, (byte) 0x9D, (byte) 0xDC, (byte) 0x0D,
        (byte) 0x57, (byte) 0x97, (byte) 0xF3, (byte) 0xDA, (byte) 0x6B, (byte) 0xB9, (byte) 0x12, (byte) 0x62, (byte) 0x80,
        (byte) 0x5C, (byte) 0x16, (byte) 0x77, (byte) 0xAF, (byte) 0xB2, (byte) 0x0D, (byte) 0x10, (byte) 0x70, (byte) 0x09,
        (byte) 0x18, (byte) 0x72, (byte) 0xB5, (byte) 0x94, (byte) 0x3F, (byte) 0x70, (byte) 0x7B, (byte) 0x99, (byte) 0x03,
        (byte) 0xCA, (byte) 0x81, (byte) 0x15, (byte) 0x45, (byte) 0x0E, (byte) 0xAE, (byte) 0xB4, (byte) 0x18, (byte) 0x27,
        (byte) 0x5C, (byte) 0x8F, (byte) 0x5D, (byte) 0xD3, (byte) 0xD8, (byte) 0xC1, (byte) 0x3D, (byte) 0xCD, (byte) 0xA4,
        (byte) 0x64, (byte) 0x60, (byte) 0x99, (byte) 0x13, (byte) 0x3B, (byte) 0x6C, (byte) 0xFE, (byte) 0xBA, (byte) 0x83,
        (byte) 0xD9, (byte) 0x15, (byte) 0x5F, (byte) 0x3C, (byte) 0x5D, (byte) 0x5F, (byte) 0x46, (byte) 0x5D, (byte) 0x5E,
        (byte) 0x37, (byte) 0x45, (byte) 0x11, (byte) 0x63, (byte) 0xB5, (byte) 0x1A, (byte) 0x4A, (byte) 0x51, (byte) 0x4E,
        (byte) 0xF6, (byte) 0xCE, (byte) 0x4D, (byte) 0x03, (byte) 0x0D, (byte) 0xA7, (byte) 0x29, (byte) 0x35, (byte) 0xB3,
        (byte) 0x78, (byte) 0x08, (byte) 0x69, (byte) 0xB9, (byte) 0x7E, (byte) 0x5E, (byte) 0x64, (byte) 0x83, (byte) 0x87,
        (byte) 0x8B, (byte) 0x71, (byte) 0xCC, (byte) 0x9A, (byte) 0xD6, (byte) 0x55, (byte) 0x43, (byte) 0x51, (byte) 0xB5,
        (byte) 0x1F, (byte) 0xCF, (byte) 0x47, (byte) 0x98, (byte) 0x26, (byte) 0xD4, (byte) 0x82, (byte) 0x01, (byte) 0x4D,
        (byte) 0x23, (byte) 0xC8, (byte) 0x32, (byte) 0x9F, (byte) 0xFA, (byte) 0x41, (byte) 0x10, (byte) 0x3E, (byte) 0x69,
        (byte) 0x93, (byte) 0x54, (byte) 0x93, (byte) 0x01, (byte) 0xAE, (byte) 0xBE, (byte) 0x7B, (byte) 0x72, (byte) 0xA0,
        (byte) 0x7A, (byte) 0x4A, (byte) 0xF1, (byte) 0x23, (byte) 0x14, (byte) 0x75, (byte) 0x33, (byte) 0xE0, (byte) 0xDE,
        (byte) 0x27, (byte) 0x6A, (byte) 0xA4, (byte) 0xE3, (byte) 0x7C, (byte) 0x06, (byte) 0x3C, (byte) 0xDC, (byte) 0x5F,
        (byte) 0x25, (byte) 0x34, (byte) 0x8A, (byte) 0xBC, (byte) 0xCB, (byte) 0x22, (byte) 0x31, (byte) 0xC6, (byte) 0xB6,
        (byte) 0xAA, (byte) 0xED, (byte) 0x71, (byte) 0xB7, (byte) 0x6D, (byte) 0xB8, (byte) 0xCA, (byte) 0x60, (byte) 0x0A,
        (byte) 0xAD, (byte) 0x67, (byte) 0xA6, (byte) 0x55, (byte) 0x37, (byte) 0x07, (byte) 0x04, (byte) 0xB0, (byte) 0xDD,
        (byte) 0x70, (byte) 0x34, (byte) 0x23, (byte) 0xD6, (byte) 0xAE, (byte) 0x19, (byte) 0xDB, (byte) 0x4B, (byte) 0xF3,
        (byte) 0xCA, (byte) 0x68, (byte) 0x01, (byte) 0xD1, (byte) 0xEF, (byte) 0x6F, (byte) 0xAD, (byte) 0x38, (byte) 0x0D,
        (byte) 0x86, (byte) 0x7C, (byte) 0x06, (byte) 0x04, (byte) 0x29, (byte) 0x55, (byte) 0x67, (byte) 0xCF, (byte) 0x67,
        (byte) 0xE0, (byte) 0x8B, (byte) 0xF2, (byte) 0x9E, (byte) 0x02, (byte) 0xEA, (byte) 0x47, (byte) 0x0E, (byte) 0x2C,
        (byte) 0xFC, (byte) 0x91, (byte) 0xC0, (byte) 0xD3,
                                                     };
    public static byte[]            DH2048_G         =
                                                     {
                                                         (byte) 0x02,
                                                     };

    // openssl dhparam -noout -text 4096
    public static byte[]            DH4096_P         =
                                                     {
        (byte) 0x99, (byte) 0xE0, (byte) 0xDD, (byte) 0x42, (byte) 0x28, (byte) 0xD1, (byte) 0x55, (byte) 0x13, (byte) 0x27,
        (byte) 0xA6, (byte) 0x49, (byte) 0x29, (byte) 0xEB, (byte) 0x1D, (byte) 0xEA, (byte) 0x80, (byte) 0x22, (byte) 0x77,
        (byte) 0x9C, (byte) 0x3C, (byte) 0x01, (byte) 0xC2, (byte) 0xEA, (byte) 0xD6, (byte) 0xE4, (byte) 0xFF, (byte) 0x01,
        (byte) 0x53, (byte) 0xE7, (byte) 0xD0, (byte) 0x2E, (byte) 0x3D, (byte) 0xC1, (byte) 0x03, (byte) 0xEA, (byte) 0xA9,
        (byte) 0x5C, (byte) 0x9C, (byte) 0xF4, (byte) 0x8D, (byte) 0x3E, (byte) 0xCB, (byte) 0xE4, (byte) 0x29, (byte) 0xF0,
        (byte) 0xBF, (byte) 0x94, (byte) 0x5C, (byte) 0x3B, (byte) 0x26, (byte) 0xBA, (byte) 0x3C, (byte) 0x0E, (byte) 0xD5,
        (byte) 0xF2, (byte) 0x1F, (byte) 0x4C, (byte) 0x5A, (byte) 0x1E, (byte) 0x47, (byte) 0xD4, (byte) 0xFF, (byte) 0x83,
        (byte) 0xB2, (byte) 0x25, (byte) 0x78, (byte) 0x6F, (byte) 0x40, (byte) 0x46, (byte) 0xB4, (byte) 0x32, (byte) 0x49,
        (byte) 0xCB, (byte) 0xE5, (byte) 0x38, (byte) 0x50, (byte) 0x10, (byte) 0xF8, (byte) 0xC9, (byte) 0x29, (byte) 0xA3,
        (byte) 0x29, (byte) 0xFA, (byte) 0xC2, (byte) 0xF3, (byte) 0xD7, (byte) 0x08, (byte) 0x47, (byte) 0xDF, (byte) 0xDC,
        (byte) 0x65, (byte) 0x7C, (byte) 0x75, (byte) 0x21, (byte) 0xA5, (byte) 0xB2, (byte) 0x8C, (byte) 0x33, (byte) 0x4D,
        (byte) 0x5E, (byte) 0x7D, (byte) 0x36, (byte) 0xAE, (byte) 0x7E, (byte) 0x64, (byte) 0xA8, (byte) 0x03, (byte) 0x0F,
        (byte) 0xDE, (byte) 0xBD, (byte) 0x76, (byte) 0xA4, (byte) 0x5C, (byte) 0xC9, (byte) 0x9E, (byte) 0x04, (byte) 0x41,
        (byte) 0xDA, (byte) 0x48, (byte) 0xD9, (byte) 0x3B, (byte) 0x16, (byte) 0x0A, (byte) 0xBF, (byte) 0x93, (byte) 0xC7,
        (byte) 0xEB, (byte) 0x87, (byte) 0xDA, (byte) 0xA7, (byte) 0x0F, (byte) 0xF4, (byte) 0x24, (byte) 0x72, (byte) 0xC1,
        (byte) 0x5E, (byte) 0x9A, (byte) 0xFB, (byte) 0xC0, (byte) 0xB5, (byte) 0x50, (byte) 0xFE, (byte) 0x1A, (byte) 0xBD,
        (byte) 0xAF, (byte) 0x22, (byte) 0xB6, (byte) 0x9F, (byte) 0x52, (byte) 0x6A, (byte) 0x67, (byte) 0x4F, (byte) 0x05,
        (byte) 0xE1, (byte) 0xF4, (byte) 0x27, (byte) 0x56, (byte) 0xC4, (byte) 0xEC, (byte) 0x2C, (byte) 0x26, (byte) 0x64,
        (byte) 0xF1, (byte) 0x0D, (byte) 0x45, (byte) 0x34, (byte) 0xED, (byte) 0x7E, (byte) 0xBF, (byte) 0xB7, (byte) 0x7E,
        (byte) 0xA0, (byte) 0xE3, (byte) 0xFA, (byte) 0x22, (byte) 0x62, (byte) 0x26, (byte) 0x31, (byte) 0x30, (byte) 0x72,
        (byte) 0x95, (byte) 0xD0, (byte) 0xE0, (byte) 0x2D, (byte) 0x81, (byte) 0x4B, (byte) 0x8B, (byte) 0xFD, (byte) 0xF9,
        (byte) 0xEC, (byte) 0x53, (byte) 0x73, (byte) 0x8D, (byte) 0x59, (byte) 0x96, (byte) 0xC7, (byte) 0x69, (byte) 0x20,
        (byte) 0xA7, (byte) 0xFB, (byte) 0xC8, (byte) 0x70, (byte) 0xA1, (byte) 0xEF, (byte) 0xAA, (byte) 0x7E, (byte) 0x36,
        (byte) 0x54, (byte) 0xEA, (byte) 0x61, (byte) 0xD8, (byte) 0x2B, (byte) 0x00, (byte) 0x2B, (byte) 0x9D, (byte) 0xCD,
        (byte) 0x10, (byte) 0xC1, (byte) 0x44, (byte) 0x52, (byte) 0x84, (byte) 0xF2, (byte) 0x56, (byte) 0x52, (byte) 0x90,
        (byte) 0x30, (byte) 0x08, (byte) 0x81, (byte) 0xAB, (byte) 0xA2, (byte) 0xB8, (byte) 0xD7, (byte) 0xD4, (byte) 0xE9,
        (byte) 0x5D, (byte) 0x55, (byte) 0x57, (byte) 0x18, (byte) 0x3F, (byte) 0xA3, (byte) 0x62, (byte) 0x9C, (byte) 0x07,
        (byte) 0xAC, (byte) 0x4A, (byte) 0xA2, (byte) 0xDE, (byte) 0x11, (byte) 0x83, (byte) 0xED, (byte) 0x8D, (byte) 0x70,
        (byte) 0x3C, (byte) 0x08, (byte) 0xF9, (byte) 0x47, (byte) 0xB2, (byte) 0x9C, (byte) 0x29, (byte) 0x30, (byte) 0x88,
        (byte) 0x6A, (byte) 0xE9, (byte) 0xD0, (byte) 0xC6, (byte) 0x64, (byte) 0x6E, (byte) 0xF2, (byte) 0x2E, (byte) 0x2E,
        (byte) 0xC3, (byte) 0x03, (byte) 0x66, (byte) 0xFA, (byte) 0x91, (byte) 0xCA, (byte) 0x91, (byte) 0x28, (byte) 0xB7,
        (byte) 0x04, (byte) 0xAD, (byte) 0xD0, (byte) 0xEA, (byte) 0xD9, (byte) 0x58, (byte) 0x49, (byte) 0x5D, (byte) 0xA2,
        (byte) 0xA8, (byte) 0x41, (byte) 0xA6, (byte) 0xFD, (byte) 0xFC, (byte) 0xBE, (byte) 0x2C, (byte) 0xFB, (byte) 0x7B,
        (byte) 0x62, (byte) 0x79, (byte) 0xD0, (byte) 0xF2, (byte) 0x79, (byte) 0x4B, (byte) 0xEA, (byte) 0x22, (byte) 0x41,
        (byte) 0xDF, (byte) 0xA4, (byte) 0x07, (byte) 0xA4, (byte) 0xEE, (byte) 0x0E, (byte) 0xB5, (byte) 0x68, (byte) 0x7A,
        (byte) 0xF2, (byte) 0x0C, (byte) 0xF4, (byte) 0x9A, (byte) 0x51, (byte) 0x71, (byte) 0x31, (byte) 0x1B, (byte) 0x4F,
        (byte) 0x23, (byte) 0xAD, (byte) 0x5D, (byte) 0xE0, (byte) 0xED, (byte) 0xC9, (byte) 0x46, (byte) 0xE9, (byte) 0xE4,
        (byte) 0x98, (byte) 0xF9, (byte) 0xBA, (byte) 0x66, (byte) 0xE4, (byte) 0x9A, (byte) 0x1B, (byte) 0xAC, (byte) 0x68,
        (byte) 0x77, (byte) 0x95, (byte) 0xEA, (byte) 0x45, (byte) 0x1F, (byte) 0xEB, (byte) 0x83, (byte) 0x47, (byte) 0xC0,
        (byte) 0x97, (byte) 0x80, (byte) 0x9D, (byte) 0x13, (byte) 0xFA, (byte) 0xF1, (byte) 0x97, (byte) 0xC3, (byte) 0xD8,
        (byte) 0xC4, (byte) 0x0D, (byte) 0x6E, (byte) 0x96, (byte) 0x61, (byte) 0x82, (byte) 0x70, (byte) 0x0D, (byte) 0x92,
        (byte) 0xCD, (byte) 0xB4, (byte) 0x08, (byte) 0x3A, (byte) 0x9E, (byte) 0x26, (byte) 0x86, (byte) 0x05, (byte) 0xCB,
        (byte) 0xB0, (byte) 0x43, (byte) 0x9F, (byte) 0xCE, (byte) 0x86, (byte) 0xE7, (byte) 0xB8, (byte) 0x4E, (byte) 0x67,
        (byte) 0x92, (byte) 0x9B, (byte) 0xCE, (byte) 0xF9, (byte) 0x67, (byte) 0x89, (byte) 0xF4, (byte) 0xF8, (byte) 0x7E,
        (byte) 0x79, (byte) 0xFD, (byte) 0x7D, (byte) 0x95, (byte) 0x32, (byte) 0xDC, (byte) 0xDE, (byte) 0xDB, (byte) 0x92,
        (byte) 0x40, (byte) 0x36, (byte) 0x52, (byte) 0xEB, (byte) 0x10, (byte) 0xC9, (byte) 0xCA, (byte) 0x2B, (byte) 0x08,
        (byte) 0xCC, (byte) 0xAF, (byte) 0x67, (byte) 0xE8, (byte) 0xD3, (byte) 0xB7, (byte) 0xBC, (byte) 0x3E, (byte) 0x10,
        (byte) 0x58, (byte) 0x98, (byte) 0xF9, (byte) 0xBB, (byte) 0xCE, (byte) 0x9F, (byte) 0x15, (byte) 0x84, (byte) 0x57,
        (byte) 0x0B, (byte) 0xE9, (byte) 0x74, (byte) 0x40, (byte) 0xCC, (byte) 0x2F, (byte) 0xF1, (byte) 0xB0, (byte) 0x1A,
        (byte) 0x27, (byte) 0xE9, (byte) 0x01, (byte) 0xF9, (byte) 0x2F, (byte) 0x36, (byte) 0x77, (byte) 0x7B, (byte) 0x0C,
        (byte) 0x54, (byte) 0x15, (byte) 0x1C, (byte) 0xA6, (byte) 0x11, (byte) 0x3C, (byte) 0x43, (byte) 0xFB, (byte) 0x63,
        (byte) 0x61, (byte) 0x91, (byte) 0x33, (byte) 0xC4, (byte) 0x1C, (byte) 0x39, (byte) 0x6C, (byte) 0xFA, (byte) 0xE4,
        (byte) 0xE5, (byte) 0xA3, (byte) 0x68, (byte) 0x75, (byte) 0x09, (byte) 0xB6, (byte) 0xDA, (byte) 0x66, (byte) 0x43,
        (byte) 0xFD, (byte) 0x37, (byte) 0xFB, (byte) 0x55, (byte) 0x95, (byte) 0x0E, (byte) 0xBC, (byte) 0x18, (byte) 0x0B,
        (byte) 0x8A, (byte) 0xFE, (byte) 0x07, (byte) 0x9C, (byte) 0xAA, (byte) 0x80, (byte) 0xD2, (byte) 0xAA, (byte) 0x81,
        (byte) 0x53, (byte) 0xF0, (byte) 0x69, (byte) 0x58, (byte) 0x3F, (byte) 0xD7, (byte) 0xBA, (byte) 0x5D, (byte) 0x23,
        (byte) 0x16, (byte) 0xC5, (byte) 0x8B, (byte) 0xE1, (byte) 0x12, (byte) 0xC7, (byte) 0x43, (byte) 0xE3,
                                                     };
    public static byte[]            DH4096_G         =
                                                     {
                                                         (byte) 0x02,
                                                     };

    // openssl dhparam -noout -text 8192
    public static byte[]            DH8192_P         =
                                                     {
        (byte) 0xC3, (byte) 0xD0, (byte) 0x5A, (byte) 0xF7, (byte) 0xA1, (byte) 0x90, (byte) 0x00, (byte) 0x8A, (byte) 0x93,
        (byte) 0xCE, (byte) 0xF3, (byte) 0xA2, (byte) 0x34, (byte) 0x39, (byte) 0x01, (byte) 0x9E, (byte) 0x87, (byte) 0xF0,
        (byte) 0x4E, (byte) 0xB8, (byte) 0xFB, (byte) 0xA4, (byte) 0x18, (byte) 0x58, (byte) 0x10, (byte) 0x8F, (byte) 0xD4,
        (byte) 0xA7, (byte) 0x00, (byte) 0x77, (byte) 0x31, (byte) 0x6B, (byte) 0xA1, (byte) 0x0A, (byte) 0x66, (byte) 0xD0,
        (byte) 0xE1, (byte) 0x67, (byte) 0x94, (byte) 0x93, (byte) 0xC8, (byte) 0xA6, (byte) 0x13, (byte) 0x23, (byte) 0x39,
        (byte) 0x5A, (byte) 0x66, (byte) 0x30, (byte) 0x1A, (byte) 0xEA, (byte) 0x9C, (byte) 0x4E, (byte) 0xFD, (byte) 0x18,
        (byte) 0xE9, (byte) 0x4C, (byte) 0x01, (byte) 0x25, (byte) 0x2C, (byte) 0x9B, (byte) 0x87, (byte) 0x50, (byte) 0x3C,
        (byte) 0x64, (byte) 0x39, (byte) 0x0C, (byte) 0xB9, (byte) 0xD1, (byte) 0x1E, (byte) 0xF3, (byte) 0x8F, (byte) 0x5E,
        (byte) 0x08, (byte) 0xC8, (byte) 0xA9, (byte) 0x50, (byte) 0x28, (byte) 0x37, (byte) 0x9E, (byte) 0xD8, (byte) 0x85,
        (byte) 0x6C, (byte) 0xC8, (byte) 0xD1, (byte) 0x91, (byte) 0x97, (byte) 0xC8, (byte) 0xB7, (byte) 0x31, (byte) 0x0C,
        (byte) 0x64, (byte) 0x5A, (byte) 0x36, (byte) 0xCD, (byte) 0x61, (byte) 0x42, (byte) 0x16, (byte) 0x39, (byte) 0x62,
        (byte) 0xC3, (byte) 0xD9, (byte) 0xE1, (byte) 0x0A, (byte) 0x1E, (byte) 0x48, (byte) 0xB6, (byte) 0x1F, (byte) 0xEC,
        (byte) 0x72, (byte) 0xF2, (byte) 0x6E, (byte) 0xC8, (byte) 0x1D, (byte) 0x79, (byte) 0x25, (byte) 0xBC, (byte) 0x7B,
        (byte) 0x52, (byte) 0x67, (byte) 0x19, (byte) 0xB0, (byte) 0xE7, (byte) 0x09, (byte) 0xEF, (byte) 0xF7, (byte) 0xE6,
        (byte) 0x94, (byte) 0x07, (byte) 0xF4, (byte) 0x8A, (byte) 0x67, (byte) 0x68, (byte) 0xFC, (byte) 0x72, (byte) 0x90,
        (byte) 0xE4, (byte) 0x66, (byte) 0x67, (byte) 0x91, (byte) 0xB6, (byte) 0x3C, (byte) 0x16, (byte) 0xC9, (byte) 0x3C,
        (byte) 0xA2, (byte) 0x70, (byte) 0x3B, (byte) 0x28, (byte) 0xAF, (byte) 0xEC, (byte) 0xEA, (byte) 0x5B, (byte) 0xD7,
        (byte) 0xC3, (byte) 0xCD, (byte) 0x47, (byte) 0x78, (byte) 0x0B, (byte) 0x9E, (byte) 0xCF, (byte) 0x05, (byte) 0x62,
        (byte) 0x2B, (byte) 0x4A, (byte) 0x63, (byte) 0xDB, (byte) 0x53, (byte) 0xB4, (byte) 0xA3, (byte) 0x08, (byte) 0x6A,
        (byte) 0x65, (byte) 0x6E, (byte) 0x5E, (byte) 0xD6, (byte) 0x8D, (byte) 0x8F, (byte) 0x8F, (byte) 0xA0, (byte) 0x96,
        (byte) 0xA4, (byte) 0xB3, (byte) 0x04, (byte) 0x15, (byte) 0xBB, (byte) 0x4F, (byte) 0xC1, (byte) 0x71, (byte) 0x22,
        (byte) 0x89, (byte) 0x6A, (byte) 0x3C, (byte) 0x10, (byte) 0x85, (byte) 0xEB, (byte) 0x3F, (byte) 0x10, (byte) 0xC4,
        (byte) 0xC9, (byte) 0xE7, (byte) 0x29, (byte) 0x33, (byte) 0x4F, (byte) 0x56, (byte) 0x18, (byte) 0x46, (byte) 0xFB,
        (byte) 0x27, (byte) 0xA7, (byte) 0x63, (byte) 0x2D, (byte) 0x30, (byte) 0x82, (byte) 0x03, (byte) 0x0B, (byte) 0x63,
        (byte) 0xB7, (byte) 0xF1, (byte) 0xE5, (byte) 0x0D, (byte) 0x76, (byte) 0x6F, (byte) 0xAA, (byte) 0xCF, (byte) 0x95,
        (byte) 0x76, (byte) 0xB3, (byte) 0x73, (byte) 0xE0, (byte) 0xAE, (byte) 0xF5, (byte) 0xA8, (byte) 0xCB, (byte) 0x2A,
        (byte) 0x50, (byte) 0xF3, (byte) 0x24, (byte) 0x12, (byte) 0xA1, (byte) 0x69, (byte) 0x6E, (byte) 0xF9, (byte) 0xA1,
        (byte) 0x55, (byte) 0xB7, (byte) 0xA1, (byte) 0xD3, (byte) 0x4D, (byte) 0x5C, (byte) 0xA2, (byte) 0x75, (byte) 0x07,
        (byte) 0x15, (byte) 0x89, (byte) 0xC3, (byte) 0x60, (byte) 0xAF, (byte) 0x0B, (byte) 0x4C, (byte) 0xBB, (byte) 0x8E,
        (byte) 0x29, (byte) 0x67, (byte) 0x3D, (byte) 0x95, (byte) 0x8F, (byte) 0xDD, (byte) 0x4C, (byte) 0x0E, (byte) 0x31,
        (byte) 0x0F, (byte) 0xD3, (byte) 0x1F, (byte) 0xC6, (byte) 0xD7, (byte) 0x7C, (byte) 0x62, (byte) 0x2E, (byte) 0x93,
        (byte) 0x76, (byte) 0xE8, (byte) 0x4D, (byte) 0xD0, (byte) 0xBD, (byte) 0x56, (byte) 0x72, (byte) 0x35, (byte) 0xE5,
        (byte) 0xD8, (byte) 0xCE, (byte) 0xDD, (byte) 0x73, (byte) 0x0A, (byte) 0x2C, (byte) 0xE5, (byte) 0xAC, (byte) 0xAB,
        (byte) 0xF6, (byte) 0x81, (byte) 0x65, (byte) 0x8A, (byte) 0x6C, (byte) 0x47, (byte) 0x0D, (byte) 0x33, (byte) 0x9C,
        (byte) 0x0F, (byte) 0x5A, (byte) 0xB8, (byte) 0x20, (byte) 0x82, (byte) 0x13, (byte) 0x5B, (byte) 0xAA, (byte) 0xE5,
        (byte) 0xF6, (byte) 0x87, (byte) 0x63, (byte) 0x6B, (byte) 0x04, (byte) 0x04, (byte) 0x0E, (byte) 0x21, (byte) 0x6F,
        (byte) 0xAF, (byte) 0x8F, (byte) 0x56, (byte) 0x38, (byte) 0x12, (byte) 0x1C, (byte) 0x19, (byte) 0xAE, (byte) 0x97,
        (byte) 0x9D, (byte) 0xDB, (byte) 0xE5, (byte) 0x3D, (byte) 0x8B, (byte) 0xCC, (byte) 0xFE, (byte) 0x85, (byte) 0x53,
        (byte) 0xD3, (byte) 0x67, (byte) 0xB3, (byte) 0xF5, (byte) 0x58, (byte) 0x76, (byte) 0x78, (byte) 0xE6, (byte) 0x54,
        (byte) 0x85, (byte) 0x18, (byte) 0xF1, (byte) 0x85, (byte) 0xBD, (byte) 0xD3, (byte) 0x3B, (byte) 0xEF, (byte) 0x00,
        (byte) 0xA5, (byte) 0x77, (byte) 0x37, (byte) 0x49, (byte) 0xEA, (byte) 0xCF, (byte) 0x47, (byte) 0xE8, (byte) 0xC0,
        (byte) 0xFA, (byte) 0xFC, (byte) 0xEE, (byte) 0xB9, (byte) 0x15, (byte) 0x34, (byte) 0x64, (byte) 0xBF, (byte) 0xEB,
        (byte) 0xE4, (byte) 0x4C, (byte) 0x84, (byte) 0x25, (byte) 0xE6, (byte) 0x6D, (byte) 0x5D, (byte) 0x24, (byte) 0x63,
        (byte) 0x18, (byte) 0xA2, (byte) 0x56, (byte) 0xAC, (byte) 0x22, (byte) 0xDE, (byte) 0x3F, (byte) 0x40, (byte) 0x27,
        (byte) 0x19, (byte) 0x68, (byte) 0x01, (byte) 0xC3, (byte) 0x1F, (byte) 0x7D, (byte) 0x43, (byte) 0x50, (byte) 0x15,
        (byte) 0xDC, (byte) 0x77, (byte) 0x4B, (byte) 0x32, (byte) 0x11, (byte) 0xBE, (byte) 0x9D, (byte) 0x77, (byte) 0x44,
        (byte) 0x94, (byte) 0xD6, (byte) 0xFC, (byte) 0xCA, (byte) 0xDF, (byte) 0xAD, (byte) 0x68, (byte) 0x84, (byte) 0xA1,
        (byte) 0xEC, (byte) 0x34, (byte) 0x93, (byte) 0xBE, (byte) 0x70, (byte) 0x46, (byte) 0x66, (byte) 0x70, (byte) 0x3F,
        (byte) 0x12, (byte) 0x03, (byte) 0x42, (byte) 0x98, (byte) 0xE5, (byte) 0x26, (byte) 0x9A, (byte) 0xA7, (byte) 0x2D,
        (byte) 0xC9, (byte) 0xF9, (byte) 0xE5, (byte) 0xE4, (byte) 0x2A, (byte) 0x8E, (byte) 0x68, (byte) 0x2E, (byte) 0x49,
        (byte) 0xA8, (byte) 0x47, (byte) 0x17, (byte) 0x47, (byte) 0x13, (byte) 0x83, (byte) 0xDB, (byte) 0xC8, (byte) 0xAD,
        (byte) 0xB6, (byte) 0xAD, (byte) 0x15, (byte) 0xF5, (byte) 0xED, (byte) 0xCC, (byte) 0x87, (byte) 0xB6, (byte) 0x91,
        (byte) 0x68, (byte) 0xB6, (byte) 0x84, (byte) 0x07, (byte) 0xBA, (byte) 0x45, (byte) 0xC2, (byte) 0x62, (byte) 0xA0,
        (byte) 0xA4, (byte) 0xEE, (byte) 0xDD, (byte) 0x67, (byte) 0x2C, (byte) 0x78, (byte) 0x56, (byte) 0xBE, (byte) 0x57,
        (byte) 0x2C, (byte) 0x2C, (byte) 0x19, (byte) 0x00, (byte) 0x08, (byte) 0x58, (byte) 0xA8, (byte) 0x8E, (byte) 0x65,
        (byte) 0x96, (byte) 0x8F, (byte) 0xEF, (byte) 0xCA, (byte) 0x73, (byte) 0xEE, (byte) 0x85, (byte) 0x38, (byte) 0xD1,
        (byte) 0x43, (byte) 0x10, (byte) 0x58, (byte) 0xA5, (byte) 0xBF, (byte) 0x6C, (byte) 0x0C, (byte) 0x60, (byte) 0x01,
        (byte) 0xB6, (byte) 0x59, (byte) 0xDB, (byte) 0x9A, (byte) 0x3F, (byte) 0x48, (byte) 0x8F, (byte) 0xF1, (byte) 0x36,
        (byte) 0x65, (byte) 0xED, (byte) 0xD5, (byte) 0x91, (byte) 0x2B, (byte) 0x79, (byte) 0x95, (byte) 0x25, (byte) 0x12,
        (byte) 0x0C, (byte) 0xBE, (byte) 0x6B, (byte) 0x72, (byte) 0x1A, (byte) 0x2A, (byte) 0xD7, (byte) 0xAC, (byte) 0xB2,
        (byte) 0xC5, (byte) 0xDC, (byte) 0x4C, (byte) 0x2D, (byte) 0xBA, (byte) 0xE2, (byte) 0x0E, (byte) 0xA8, (byte) 0x52,
        (byte) 0x73, (byte) 0x79, (byte) 0x1A, (byte) 0xC1, (byte) 0x6A, (byte) 0x19, (byte) 0xD6, (byte) 0x3E, (byte) 0xBE,
        (byte) 0xA2, (byte) 0x77, (byte) 0x04, (byte) 0xA5, (byte) 0x1B, (byte) 0x69, (byte) 0x1A, (byte) 0x8A, (byte) 0xB3,
        (byte) 0x46, (byte) 0x33, (byte) 0xB4, (byte) 0x64, (byte) 0x2B, (byte) 0xEC, (byte) 0xB3, (byte) 0x6D, (byte) 0x0E,
        (byte) 0x2A, (byte) 0xF0, (byte) 0x7A, (byte) 0xA9, (byte) 0x00, (byte) 0x01, (byte) 0xD3, (byte) 0x53, (byte) 0x13,
        (byte) 0x0E, (byte) 0xA8, (byte) 0x85, (byte) 0x2E, (byte) 0x99, (byte) 0x28, (byte) 0x28, (byte) 0x85, (byte) 0xB7,
        (byte) 0xB4, (byte) 0x08, (byte) 0x6F, (byte) 0x0D, (byte) 0xDC, (byte) 0x22, (byte) 0x8C, (byte) 0xA7, (byte) 0xC6,
        (byte) 0xA8, (byte) 0xF7, (byte) 0xEE, (byte) 0x6A, (byte) 0xFD, (byte) 0x8B, (byte) 0xE8, (byte) 0xEC, (byte) 0x32,
        (byte) 0xD1, (byte) 0xA9, (byte) 0x58, (byte) 0x4A, (byte) 0x11, (byte) 0xE2, (byte) 0x00, (byte) 0x26, (byte) 0xFD,
        (byte) 0x5E, (byte) 0x20, (byte) 0x96, (byte) 0x78, (byte) 0x7C, (byte) 0x94, (byte) 0x14, (byte) 0x40, (byte) 0x85,
        (byte) 0x8C, (byte) 0x7F, (byte) 0xCB, (byte) 0x8C, (byte) 0xB0, (byte) 0x7B, (byte) 0x71, (byte) 0x09, (byte) 0x7F,
        (byte) 0x46, (byte) 0x6A, (byte) 0x7E, (byte) 0x8F, (byte) 0xAB, (byte) 0x36, (byte) 0x7A, (byte) 0x29, (byte) 0x70,
        (byte) 0xEC, (byte) 0x8A, (byte) 0xC0, (byte) 0xCB, (byte) 0x9F, (byte) 0xD0, (byte) 0xD2, (byte) 0x20, (byte) 0xC1,
        (byte) 0xAB, (byte) 0x28, (byte) 0x6D, (byte) 0x2B, (byte) 0x3E, (byte) 0x9C, (byte) 0xA7, (byte) 0x24, (byte) 0x8F,
        (byte) 0x4D, (byte) 0xD0, (byte) 0x24, (byte) 0xE2, (byte) 0xF5, (byte) 0xE1, (byte) 0x00, (byte) 0xC4, (byte) 0x49,
        (byte) 0xBF, (byte) 0x75, (byte) 0xEA, (byte) 0xE3, (byte) 0xD4, (byte) 0x14, (byte) 0xDE, (byte) 0x33, (byte) 0x0E,
        (byte) 0x60, (byte) 0x6D, (byte) 0xB2, (byte) 0x50, (byte) 0x7D, (byte) 0xF1, (byte) 0xB9, (byte) 0x0E, (byte) 0x2A,
        (byte) 0x67, (byte) 0xE8, (byte) 0xFB, (byte) 0x84, (byte) 0x8E, (byte) 0x6F, (byte) 0x17, (byte) 0x79, (byte) 0x8B,
        (byte) 0xE7, (byte) 0x92, (byte) 0x3A, (byte) 0xDC, (byte) 0x90, (byte) 0xD2, (byte) 0xE4, (byte) 0xA0, (byte) 0x8D,
        (byte) 0x0C, (byte) 0xD2, (byte) 0xAB, (byte) 0x90, (byte) 0x96, (byte) 0xD1, (byte) 0xD0, (byte) 0x92, (byte) 0x24,
        (byte) 0xEB, (byte) 0x2D, (byte) 0xBE, (byte) 0x15, (byte) 0x97, (byte) 0xFA, (byte) 0x7E, (byte) 0xEF, (byte) 0x98,
        (byte) 0x59, (byte) 0x7F, (byte) 0xBF, (byte) 0xCD, (byte) 0xE4, (byte) 0x09, (byte) 0xB6, (byte) 0x64, (byte) 0xD0,
        (byte) 0x0C, (byte) 0x43, (byte) 0xF1, (byte) 0x1C, (byte) 0xAC, (byte) 0xC5, (byte) 0x17, (byte) 0x73, (byte) 0x83,
        (byte) 0x1F, (byte) 0x8C, (byte) 0x92, (byte) 0x40, (byte) 0xE6, (byte) 0x8E, (byte) 0xA9, (byte) 0x9F, (byte) 0x82,
        (byte) 0xD3, (byte) 0xC5, (byte) 0x61, (byte) 0x69, (byte) 0xA0, (byte) 0xAC, (byte) 0x3D, (byte) 0xE7, (byte) 0x4F,
        (byte) 0x87, (byte) 0x4E, (byte) 0x2A, (byte) 0x4B, (byte) 0x92, (byte) 0x19, (byte) 0xC8, (byte) 0x35, (byte) 0x47,
        (byte) 0x15, (byte) 0xF3, (byte) 0xD7, (byte) 0x14, (byte) 0x9C, (byte) 0x49, (byte) 0xE4, (byte) 0x32, (byte) 0x24,
        (byte) 0x37, (byte) 0xE8, (byte) 0x0B, (byte) 0x22, (byte) 0xFA, (byte) 0xC8, (byte) 0x4C, (byte) 0x5A, (byte) 0xB1,
        (byte) 0xF2, (byte) 0x15, (byte) 0x95, (byte) 0x7A, (byte) 0x7F, (byte) 0x1E, (byte) 0xB9, (byte) 0x62, (byte) 0x0C,
        (byte) 0xC2, (byte) 0x91, (byte) 0xFC, (byte) 0x52, (byte) 0x96, (byte) 0xF8, (byte) 0xDE, (byte) 0x43, (byte) 0x59,
        (byte) 0x67, (byte) 0x0A, (byte) 0xBA, (byte) 0x3C, (byte) 0xBC, (byte) 0x41, (byte) 0xC7, (byte) 0xF1, (byte) 0x84,
        (byte) 0xDA, (byte) 0xEB, (byte) 0xBA, (byte) 0x66, (byte) 0x0B, (byte) 0xB8, (byte) 0x7C, (byte) 0x48, (byte) 0x0B,
        (byte) 0x0B, (byte) 0xB5, (byte) 0x11, (byte) 0x9B, (byte) 0x1F, (byte) 0xCA, (byte) 0xF9, (byte) 0xC7, (byte) 0xCD,
        (byte) 0x41, (byte) 0x13, (byte) 0xD0, (byte) 0x54, (byte) 0x86, (byte) 0x61, (byte) 0x74, (byte) 0x6F, (byte) 0x3F,
        (byte) 0x5C, (byte) 0xAC, (byte) 0x3E, (byte) 0xDE, (byte) 0x0F, (byte) 0x74, (byte) 0x61, (byte) 0x24, (byte) 0x92,
        (byte) 0x97, (byte) 0x41, (byte) 0x86, (byte) 0xD1, (byte) 0xAE, (byte) 0x3D, (byte) 0x3F, (byte) 0x9B, (byte) 0x55,
        (byte) 0x2C, (byte) 0x7D, (byte) 0x7E, (byte) 0x91, (byte) 0x3F, (byte) 0xA0, (byte) 0x3D, (byte) 0x06, (byte) 0x90,
        (byte) 0x03, (byte) 0x66, (byte) 0x0A, (byte) 0x43, (byte) 0x62, (byte) 0x65, (byte) 0x75, (byte) 0xE8, (byte) 0x35,
        (byte) 0x0C, (byte) 0x7C, (byte) 0xE2, (byte) 0xBC, (byte) 0x00, (byte) 0xA3, (byte) 0x74, (byte) 0x75, (byte) 0xF3,
        (byte) 0x86, (byte) 0xCB, (byte) 0x3F, (byte) 0x73, (byte) 0x3A, (byte) 0x2D, (byte) 0xF6, (byte) 0x5C, (byte) 0xA7,
        (byte) 0x48, (byte) 0xDE, (byte) 0x75, (byte) 0x91, (byte) 0xAE, (byte) 0xAF, (byte) 0x8C, (byte) 0x5E, (byte) 0xD9,
        (byte) 0x6A, (byte) 0xBC, (byte) 0x13, (byte) 0xD9, (byte) 0xFE, (byte) 0x43, (byte) 0xBD, (byte) 0x27, (byte) 0x77,
        (byte) 0x1E, (byte) 0xC7, (byte) 0x1B, (byte) 0x56, (byte) 0xBA, (byte) 0x19, (byte) 0x14, (byte) 0x46, (byte) 0x35,
        (byte) 0xBF, (byte) 0xCD, (byte) 0x18, (byte) 0xE6, (byte) 0x79, (byte) 0xC7, (byte) 0xFF, (byte) 0x74, (byte) 0xC1,
        (byte) 0x78, (byte) 0x58, (byte) 0x63, (byte) 0x44, (byte) 0x8E, (byte) 0xA3, (byte) 0x0A, (byte) 0x69, (byte) 0x76,
        (byte) 0xDA, (byte) 0xA1, (byte) 0xBD, (byte) 0x31, (byte) 0xF2, (byte) 0x0A, (byte) 0x40, (byte) 0x59, (byte) 0x30,
        (byte) 0xF1, (byte) 0x78, (byte) 0x89, (byte) 0x66, (byte) 0x7E, (byte) 0xB8, (byte) 0x90, (byte) 0xF3, (byte) 0x67,
        (byte) 0x4A, (byte) 0x52, (byte) 0xBA, (byte) 0x31, (byte) 0x11, (byte) 0xB9, (byte) 0xCC, (byte) 0xB1, (byte) 0xBD,
        (byte) 0x69, (byte) 0xA7, (byte) 0xD0, (byte) 0x60, (byte) 0xA9, (byte) 0xBC, (byte) 0x71, (byte) 0xE4, (byte) 0x4E,
        (byte) 0x83, (byte) 0xB1, (byte) 0x24, (byte) 0x1F, (byte) 0x00, (byte) 0x68, (byte) 0xC1, (byte) 0x24, (byte) 0xE6,
        (byte) 0xFC, (byte) 0x57, (byte) 0xFA, (byte) 0x72, (byte) 0x2B, (byte) 0xF5, (byte) 0x33, (byte) 0xAF, (byte) 0xB6,
        (byte) 0x3C, (byte) 0x79, (byte) 0xEA, (byte) 0xD3, (byte) 0x47, (byte) 0x0C, (byte) 0x11, (byte) 0x6C, (byte) 0x80,
        (byte) 0x14, (byte) 0x11, (byte) 0x47, (byte) 0xF5, (byte) 0xD8, (byte) 0x29, (byte) 0x94, (byte) 0x22, (byte) 0x01,
        (byte) 0x72, (byte) 0xC1, (byte) 0x60, (byte) 0x3C, (byte) 0xEA, (byte) 0x78, (byte) 0x9B,
                                                     };
    public static byte[]            DH8192_G         =
                                                     {
                                                         (byte) 0x02,
                                                     };

    protected byte[]                hmacKey;
    protected WtcDhKeyPairPlatform  dhKeyPair;

    protected final Object          kexRequestSignal = new Object();
    protected boolean               kexCompleted;
    protected Thread                kexThread;
    protected int                   kexPrimeSize;
    protected IWtcMemoryStream      kexRequest;
    protected WtcKexCryptoException kexException;

    public void reset()
    {
        super.reset();
        hmacKey = null;
        dhKeyPair = null;

        if (kexRequestSignal == null)
        {
            kexCompleted = false;
            kexPrimeSize = WtcKexPrimeSize.NONE;
            kexRequest = null;
            kexException = null;
        }
        else
        {
            synchronized (kexRequestSignal)
            {
                if (kexThread != null)
                {
                    kexThread.interrupt();
                    kexThread = null;
                }
                kexCompleted = false;
                kexPrimeSize = WtcKexPrimeSize.NONE;
                kexRequest = null;
                kexException = null;
            }
        }
    }

    public IWtcMemoryStream waitForKexRequest() //
                    throws InterruptedException, WtcKexCryptoException
    {
        synchronized (kexRequestSignal)
        {
            if (!kexCompleted)
            {
                kexRequestSignal.wait();
            }

            if (kexPrimeSize == WtcKexPrimeSize.NONE)
            {
                return null;
            }

            if (kexException != null)
            {
                throw kexException;
            }

            kexRequest.setPosition(0);
            return kexRequest;
        }
    }

    protected void setKexRequest(IWtcMemoryStream kexRequest, WtcKexCryptoException kexException)
    {
        synchronized (kexRequestSignal)
        {
            if (kexRequest != null)
            {
                kexRequest.setPosition(0);
            }

            this.kexCompleted = true;
            this.kexRequest = kexRequest;
            this.kexException = kexException;

            kexRequestSignal.notifyAll();
        }
    }

    public void createKexRequestAsync()
    {
        createKexRequestAsync(DEFAULT_KEX_SIZE);
    }

    /**
     * @param primeSize Any one of WtcKexPrimeSize 
     * @throws IllegalArgumentException
     */
    public void createKexRequestAsync(int primeSize) //
                    throws IllegalArgumentException
    {
        createKexRequestAsync(DEFAULT_KEX_GROUP, DEFAULT_KEX_MODE, primeSize);
    }

    /**
     * @param keyGroupId
     * @param messageCipherMode
     * @param primeSize
     * @throws IllegalArgumentException
     */
    public void createKexRequestAsync(final String keyGroupId, final int messageCipherMode, int primeSize) //
                    throws IllegalArgumentException
    {
        WtcLog.info(TAG, "+createKexRequestAsync");

        synchronized (kexRequestSignal)
        {
            reset();

            // Public generator of P (usually 2 or 5)
            final byte[] G;

            // Public "safe prime" BigInteger
            final byte[] P;

            setMessageCipherMode(messageCipherMode);

            switch (primeSize)
            {
                case WtcKexPrimeSize.NONE:
                    setKexRequest(null, null);
                    return;
                case WtcKexPrimeSize.P1024:
                    P = DH1024_P;
                    G = DH1024_G;
                    break;
                case WtcKexPrimeSize.P2048:
                    P = DH2048_P;
                    G = DH2048_G;
                    break;
                case WtcKexPrimeSize.P4096:
                    P = DH4096_P;
                    G = DH4096_G;
                    break;
                case WtcKexPrimeSize.P8192:
                    P = DH8192_P;
                    G = DH8192_G;
                    break;
                default:
                    throw new IllegalArgumentException("primeSize=" + primeSize + " not supported");
            }

            this.kexPrimeSize = primeSize;

            kexThread = new Thread(new Runnable()
            {
                public void run()
                {
                    try
                    {
                        WtcLog.info(TAG, "+createKexRequestAsync.run()");

                        int cookie = WtcCryptoUtilPlatform.getRandomInt32();
                        String strMessageCipherMode = cipherModeToString(getMessageCipherMode());

                        WtcLog.info(TAG, "+new WtcDhKeyPairPlatform(...)");
                        long timeStart = System.currentTimeMillis();
                        dhKeyPair = new WtcDhKeyPairPlatform(P, G);
                        long timeStop = System.currentTimeMillis();
                        long timeElapsed = timeStop - timeStart;
                        WtcLog.warn(TAG, "-new WtcDhKeyPairPlatform(...): took " + timeElapsed + "ms");

                        byte[] E = dhKeyPair.getDHPublicKeyBytes();

                        IWtcMemoryStream outputStream = new WtcMemoryStream();

                        if (VERBOSE_LOG)
                        {
                            WtcLog.info(TAG, "HEADER(" + HEADER.length + ")=" + HEADER);
                        }
                        outputStream.write(HEADER, 0, HEADER.length);
                        if (VERBOSE_LOG)
                        {
                            WtcLog.info(TAG, "cookie=" + cookie);
                        }
                        outputStream.writeInt32(cookie);
                        if (VERBOSE_LOG)
                        {
                            WtcLog.info(TAG, "keyGroupId=" + keyGroupId);
                        }
                        writeString(outputStream, keyGroupId);
                        if (VERBOSE_LOG)
                        {
                            WtcLog.info(TAG, "messageCipherMode=" + strMessageCipherMode);
                        }
                        writeString(outputStream, strMessageCipherMode);
                        if (VERBOSE_LOG)
                        {
                            WtcLog.info(TAG, "G(" + G.length + ")=" + WtcString.toHexString(G));
                        }
                        writeByteArray(outputStream, G);
                        if (VERBOSE_LOG)
                        {
                            WtcLog.info(TAG, "P(" + P.length + ")=" + WtcString.toHexString(P));
                        }
                        writeByteArray(outputStream, P);
                        if (VERBOSE_LOG)
                        {
                            WtcLog.info(TAG, "E(" + E.length + ")=" + WtcString.toHexString(E));
                        }
                        writeByteArray(outputStream, E);

                        hmacKey = findKey(keyGroupId);

                        byte[] MAC1 =
                            WtcCryptoUtilPlatform.HMACSHA256(hmacKey, outputStream.getBuffer(), 0, outputStream.getLength());
                        if (VERBOSE_LOG)
                        {
                            WtcLog.info(TAG, "MAC1(" + MAC1.length + ")=" + WtcString.toHexString(MAC1));
                        }
                        writeByteArray(outputStream, MAC1);

                        setKexRequest(outputStream, null);
                    }
                    catch (WtcKexCryptoException e)
                    {
                        WtcLog.error(TAG, "EXCEPTION: createKexRequestAsync.run", e);
                        setKexRequest(null, e);
                    }
                    catch (Exception e)
                    {
                        WtcLog.error(TAG, "EXCEPTION: createKexRequestAsync.run", e);
                        e = new WtcKexCryptoException("createKexRequestAsync.run", e);
                        setKexRequest(null, (WtcKexCryptoException) e);
                    }
                    finally
                    {
                        WtcLog.info(TAG, "-createKexRequestAsync.run()");
                    }
                }
            });
            kexThread.start();
        }

        WtcLog.info(TAG, "-createKexRequestAsync");
    }

    /**
     * @param inputStream
     * @throws WtcKexCryptoException
     */
    public void processKexResponse(IWtcMemoryStream inputStream) throws WtcKexCryptoException
    {
        WtcLog.info(TAG, "+processKexResponse");
        try
        {
            // WtcLog.info(TAG, "messageResponse(" + length + ")=" + bytesToHexString(messageResponse, offset, count));

            int readStart = inputStream.getPosition();

            short numBytesPerKey = inputStream.readInt16();
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "numBytesPerKey=" + numBytesPerKey);
            }
            short numKeys = inputStream.readInt16();
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "numKeys=" + numKeys);
            }
            byte[] F = readByteArray(inputStream);
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "F(" + F.length + ")=" + WtcString.toHexString(F));
            }
            String messageCipherMode = readString(inputStream);
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "messageCipherMode=" + messageCipherMode);
            }
            byte[] ivClientToServer = readByteArray(inputStream);
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "ivClientToServer(" + ivClientToServer.length + ")=" + WtcString.toHexString(ivClientToServer));
            }
            byte[] ivServerToClient = readByteArray(inputStream);
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "ivServerToClient(" + ivServerToClient.length + ")=" + WtcString.toHexString(ivServerToClient));
            }
            byte[] keysEncrypted = readByteArray(inputStream);
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "keysEncrypted(" + keysEncrypted.length + ")=" + WtcString.toHexString(keysEncrypted));
            }
            byte[] MAC2 = readByteArray(inputStream);
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "MAC2(" + MAC2.length + ")=" + WtcString.toHexString(MAC2));
            }

            int readStop = inputStream.getPosition();

            throwExceptionIfNotValidInput(inputStream, readStart, readStop, hmacKey, MAC2);

            setMessageCipherMode(parseCipherMode(messageCipherMode));

            Assert.assertEquals("ivClientToServer.length != ivServerToClient.length", ivClientToServer.length,
                            ivServerToClient.length);
            this.ivRemoteToLocal = ivServerToClient;
            this.ivLocalToRemote = ivClientToServer;

            byte[] sharedSecret = dhKeyPair.calculateAgreement(F);
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "sharedSecret(" + sharedSecret.length + ")=" + WtcString.toHexString(sharedSecret));
            }

            masterKey = WtcCryptoUtilPlatform.SHA256(sharedSecret);
            if (VERBOSE_LOG)
            {
                WtcLog.info(TAG, "masterKey(" + masterKey.length + ")=" + WtcString.toHexString(masterKey));
            }

            byte[][] keysClientToServer = new byte[numKeys][];
            byte[][] keysServerToClient = new byte[numKeys][];
            decryptKeys(masterKey, numKeys, numBytesPerKey, keysEncrypted, keysClientToServer, keysServerToClient);

            initializePayloadTransforms(ivClientToServer, keysClientToServer, ivServerToClient, keysServerToClient,
                            WtcCipherSide.Client);
        }
        catch (WtcKexCryptoException e)
        {
            WtcLog.error(TAG, "EXCEPTION: processKexResponse", e);
            reset();
            throw e;
        }
        catch (Exception e)
        {
            WtcLog.error(TAG, "EXCEPTION: processKexResponse", e);
            reset();
            throw new WtcKexCryptoException("processKexResponse", e);
        }
        finally
        {
            WtcLog.info(TAG, "-processKexResponse");
        }
    }
}
