package com.twistpair.wave.thinclient.kexcrypto;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase.WtcKexCryptoException;
import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase.WtcTransformerAes256EcbBase;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.WtcString;

//
// BEGIN WtcCryptoUtilPlatform
//
public class WtcCryptoUtilPlatform
{
    //private static final String   TAG                  = WtcLog.TAG(WtcCryptoUtilPlatform.class);

    protected static final String AES_ECB_PADDING_NONE = "AES/ECB/NoPadding";
    protected static final String HMAC_SHA256          = "HmacSHA256";
    protected static final String SHA256               = "SHA256";

    //
    // BEGIN WtcDecryptorAes256Ecb
    //
    public//
    static//
    class WtcDecryptorAes256Ecb //
                    extends WtcTransformerAes256EcbBase
    {
        private static final String TAG = WtcLog.TAG(WtcDecryptorAes256Ecb.class);

        private final Cipher        decryptor;

        public WtcDecryptorAes256Ecb(byte[] key) //
                        throws WtcKexCryptoException
        {
            try
            {
                decryptor = Cipher.getInstance(AES_ECB_PADDING_NONE);
                SecretKey aesKey = new SecretKeySpec(key, decryptor.getAlgorithm());
                decryptor.init(Cipher.DECRYPT_MODE, aesKey);
            }
            catch (NoSuchAlgorithmException e)
            {
                throw new WtcKexCryptoException("new WtcDecryptorAes256Ecb(...)", e);
            }
            catch (NoSuchPaddingException e)
            {
                throw new WtcKexCryptoException("new WtcDecryptorAes256Ecb(...)", e);
            }
            catch (InvalidKeyException e)
            {
                throw new WtcKexCryptoException("new WtcDecryptorAes256Ecb(...)", e);
            }
        }

        //
        // BEGIN Transform
        //
        public//
        byte[] transform(byte[] inBytes, int offset, int length) //
                        throws WtcKexCryptoException
        {
            try
            {
                return decryptor.doFinal(inBytes, offset, length);
            }
            catch (IllegalBlockSizeException e)
            {
                throw new WtcKexCryptoException("WtcDecryptorAes256Ecb.transform", e);
            }
            catch (BadPaddingException e)
            {
                throw new WtcKexCryptoException("WtcDecryptorAes256Ecb.transform", e);
            }
        }

        //
        // END Transform
        //

        //
        // BEGIN Transform
        //
        public//
        void transform(byte[] inBytes, int inOffset, byte[] outBytes, int outOffset) //
                        throws WtcKexCryptoException
        {
            try
            {
                decryptor.doFinal(inBytes, inOffset, inBytes.length - inOffset, outBytes, outOffset);
            }
            catch (ShortBufferException e)
            {
                String rawIn = WtcString.toHexString(inBytes, 0, inBytes.length);
                String rawOut = WtcString.toHexString(outBytes, 0, outBytes.length);
                String message = "WtcEncryptorAes256Ecb.transform: encryptor.doFinal " //
                                + "inOffset=" + inOffset + ", inBytes[" + inBytes.length + "]=" + rawIn //
                                + ", outOffset=" + outOffset + ", outBytes[" + outBytes.length + "]=" + rawOut;
                WtcLog.error(TAG, message, e);
                throw new WtcKexCryptoException(message, e);
            }
            catch (IllegalBlockSizeException e)
            {
                throw new WtcKexCryptoException("WtcDecryptorAes256Ecb.transform", e);
            }
            catch (BadPaddingException e)
            {
                throw new WtcKexCryptoException("WtcDecryptorAes256Ecb.transform", e);
            }
        }
        //
        // END Transform
        //
    }

    //
    // END WtcDecryptorAes256Ecb
    //

    //
    // BEGIN WtcEncryptorAes256Ecb
    //
    public//
    static//
    class WtcEncryptorAes256Ecb //
                    extends WtcTransformerAes256EcbBase
    {
        private static final String TAG = WtcLog.TAG(WtcEncryptorAes256Ecb.class);

        private final Cipher        encryptor;

        public WtcEncryptorAes256Ecb(byte[] key) //
                        throws WtcKexCryptoException
        {
            try
            {
                encryptor = Cipher.getInstance(AES_ECB_PADDING_NONE);
                SecretKey aesKey = new SecretKeySpec(key, encryptor.getAlgorithm());
                encryptor.init(Cipher.ENCRYPT_MODE, aesKey);
            }
            catch (NoSuchAlgorithmException e)
            {
                throw new WtcKexCryptoException("new WtcEncryptorAes256Ecb(...)", e);
            }
            catch (NoSuchPaddingException e)
            {
                throw new WtcKexCryptoException("new WtcEncryptorAes256Ecb(...)", e);
            }
            catch (InvalidKeyException e)
            {
                throw new WtcKexCryptoException("new WtcEncryptorAes256Ecb(...)", e);
            }
        }

        //
        // BEGIN Transform
        //
        public//
        byte[] transform(byte[] inBytes, int offset, int length) //
                        throws WtcKexCryptoException
        {
            try
            {
                return encryptor.doFinal(inBytes, offset, length);
            }
            catch (IllegalBlockSizeException e)
            {
                throw new WtcKexCryptoException("WtcEncryptorAes256Ecb.transform", e);
            }
            catch (BadPaddingException e)
            {
                throw new WtcKexCryptoException("WtcEncryptorAes256Ecb.transform", e);
            }
        }

        //
        // END Transform
        //

        //
        // BEGIN Transform
        //
        public//
        void transform(byte[] inBytes, int inOffset, byte[] outBytes, int outOffset) //
                        throws WtcKexCryptoException
        {
            try
            {
                encryptor.doFinal(inBytes, inOffset, inBytes.length - inOffset, outBytes, outOffset);
            }
            catch (ShortBufferException e)
            {
                String rawIn = WtcString.toHexString(inBytes, 0, inBytes.length);
                String rawOut = WtcString.toHexString(outBytes, 0, outBytes.length);
                String message = "WtcEncryptorAes256Ecb.transform: encryptor.doFinal " //
                                + "inOffset=" + inOffset + ", inBytes[" + inBytes.length + "]=" + rawIn //
                                + ", outOffset=" + outOffset + ", outBytes[" + outBytes.length + "]=" + rawOut;
                WtcLog.error(TAG, message, e);
                throw new WtcKexCryptoException(message, e);
            }
            catch (IllegalBlockSizeException e)
            {
                throw new WtcKexCryptoException("WtcEncryptorAes256Ecb.transform", e);
            }
            catch (BadPaddingException e)
            {
                throw new WtcKexCryptoException("WtcEncryptorAes256Ecb.transform", e);
            }
        }
        //
        // END Transform
        //
    }

    //
    // END WtcEncryptorAes256Ecb
    //

    public static byte[] HMACSHA256(byte[] key, byte[] buffer) //
                    throws WtcKexCryptoException
    {
        return HMACSHA256(key, buffer, 0, buffer.length);
    }

    public static byte[] HMACSHA256(byte[] key, byte[] buffer, int offset, int length) //
                    throws WtcKexCryptoException
    {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA256);
        try
        {
            Mac mac = Mac.getInstance(signingKey.getAlgorithm());
            mac.init(signingKey);
            mac.update(buffer, offset, length);
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e)
        {
            throw new WtcKexCryptoException("HMACSHA256(...)", e);
        }
        catch (InvalidKeyException e)
        {
            throw new WtcKexCryptoException("HMACSHA256(...)", e);
        }
    }

    public static byte[] SHA256(byte[] buffer) //
                    throws WtcKexCryptoException
    {
        try
        {
            return MessageDigest.getInstance(SHA256).digest(buffer);
        }
        catch (NoSuchAlgorithmException e)
        {
            throw new WtcKexCryptoException("SHA256(...)", e);
        }
    }

    public static int getRandomInt32()
    {
        SecureRandom random = new SecureRandom();
        return random.nextInt();
    }

    public static long getRandomInt64()
    {
        SecureRandom random = new SecureRandom();
        return random.nextLong();
    }

    public static byte[] getRandomBytes(int count)
    {
        byte[] bytes = new byte[count];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
        return bytes;
    }
}
//
// END WtcCryptoUtilPlatform
//
