package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.util.WtcString;

public class WtcException extends Exception
{
    public final String    source;
    public final Exception innerException;

    public WtcException(String source, String message)
    {
        this(source, message, null);
    }

    public WtcException(String source, Exception innerException)
    {
        this(source, null, innerException);
    }

    public WtcException(String source, String message, Exception innerException)
    {
        super(message);
        this.source = source;
        this.innerException = innerException;
    }

    public Exception getInnerException()
    {
        return innerException;
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        sb.append(WtcString.getShortClassName(this)).append('(');
        String message = this.getMessage();
        if (!WtcString.isNullOrEmpty(message))
        {
            sb.append('\"').append(message).append('\"');
            if (innerException != null)
            {
                sb.append(", ");
            }
        }
        if (innerException != null)
        {
            sb.append("innerException=").append(WtcString.getShortClassName(innerException)).append('(');
            message = innerException.getMessage();
            if (!WtcString.isNullOrEmpty(message))
            {
                sb.append('\"').append(message).append('\"');
            }
            sb.append(')');
        }
        sb.append(')');
        return sb.toString();
    }
}
