package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcLocatorException.WtcLocatorErrorException;
import com.twistpair.wave.thinclient.WtcLocatorException.WtcLocatorResponseInvalidException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackMessageReceiveException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackMessageReceiveHeaderInvalidException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackMessageReceiveOverflowException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackMessageReceiveResponseUnexpectedException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackMessageReceiveTypeUnknownException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackMessageReceiveUnderflowException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackMessageRequestResponseTimeoutException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackProxyConnectException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackProxyLocateException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackRemoteDisconnectException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackSecurityAgreementException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackSecurityException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackSecurityInitializationException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackSessionCloseException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackThreadException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackThreadProcessReceivedMessagesException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackThreadSendException;
import com.twistpair.wave.thinclient.WtcStackException.WtcStackUserProfilesEmptyException;
import com.twistpair.wave.thinclient.net.WtcInetSocketAddressPlatform;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform.WtcNetworkUnknownHostException;
import com.twistpair.wave.thinclient.net.WtcSocketExceptionPlatform;
import com.twistpair.wave.thinclient.net.WtcUri;
import com.twistpair.wave.thinclient.protocol.headers.WtcpMediaHeader;
import com.twistpair.wave.thinclient.protocol.types.WtcpAddressBookInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallAnswer;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallDtmf;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallHangup;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallOffer;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallProgress;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelActivity;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpEndpointInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpEndpointProperties;
import com.twistpair.wave.thinclient.protocol.types.WtcpErrorCode;
import com.twistpair.wave.thinclient.protocol.types.WtcpKeyValueList;
import com.twistpair.wave.thinclient.protocol.types.WtcpProfileInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpStringList;
import com.twistpair.wave.thinclient.util.WtcInt16;
import com.twistpair.wave.thinclient.util.WtcInt32;
import com.twistpair.wave.thinclient.util.WtcVersionString;

/**
 * Nearly duplicates {@link WtcStackListener}, but simplifies some raw events, especially those related to Channels.
 */
public abstract class WtcClientListener
{
    /**
     * <p>See: {@link WtcStackListener#onDisconnected(WtcStack, WtcInetSocketAddressPlatform, Exception, WtcConnectionStatistics)}</p>
     * Fires when a connection to the Proxy is closed, or if there was an error locating or connecting to the Proxy.
     * @param client
     * @param proxyAddress The address of the Proxy being disconnected from, or null if an exception was thrown before a connection could be established.
     * @param exception The exception that caused the disconnect:
     * <ul>
     * <li>null: no exception; the disconnect was graceful</li>
     * <li>{@link WtcStackException} [abstract]
     *      <ul>
     *      <li>{@link WtcStackSecurityException} [abstract]
     *          <ul>
     *          <li>{@link WtcStackSecurityInitializationException}: WtcStack failed to initialize KEX Request prior to locating and connected to Proxy.
     *              <p>Should never happen, but could if there is something wrong w/ the device's security settings.
     *              <ul>
     *              <li>Action: STOP (Dialog details so that user can report it back to TPS)</li>
     *              <li>Notification: "Disconnected: Crypto Init Error"</li>
     *              </ul>
     *              </p>
     *          </li>
     *          <li>{@link WtcStackSecurityAgreementException}: WtcStack failed to complete the KEX handshake based on the KEX Response from the Proxy.
     *              <p>Should never happen, but could if there is something wrong w/ the device's security settings or server Response.
     *              <ul>
     *              <li>Action: STOP (Dialog details so that user can report it back to TPS)</li>
     *              <li>Notification: "Disconnected: Crypto Handshake Error"</li>
     *              </ul>
     *              </p>
     *          </li>
     *          </ul>
     *      </li>
     *      <li>{@link WtcStackProxyLocateException}: WtcStack failed to locate a Proxy.
     *          <p>innerException may be:
     *          <ul>
     *          <li>{@link WtcNetworkUnknownHostException}: Could not resolve or reach the server's address.
     *              <p>Can happen if the user enters a non-existing server address, if there is no network route to the address, or if the server doesn't respond.
     *              <ul>
     *              <li>Action: STOP (Go to Sign-In screen)</li>
     *              <li>Notification: "Disconnected: Locator Unreachable"</li>
     *              </ul>
     *              </p>
     *          </li> 
     *          <li>{@link WtcLocatorResponseInvalidException}: Locator response was invalid.
     *              <p>Can happen if the user enters a non-WAVE server address (ex: google.com, cnn.com, amazon.com, etc), or XML response is invalid.
     *              <ul>
     *              <li>Action: STOP (Go to Sign-In screen)</li>
     *              <li>Notification: "Disconnected: Locator Response Invalid"</li>
     *              </ul>
     *              </p>
     *          </li>
     *          <li>{@link WtcLocatorErrorException}: Locator XML response was valid, but contained a logical Error code.
     *              <p>Can happen if the WAVE Locator XML response contains a non-zero Error value for "&lt;ServerResponse Error='...'&gt;".
     *              <ul>
     *              <li>Action: RECONNECT (if not closing or signing out)</li>
     *              <li>Notification: "Disconnected: Locator Busy"</li>
     *              </ul>
     *              </p>
     *          </li>
     *          <li>other Exception: unexpected/unhandled error
     *              <ul>
     *              <li>Action: STOP (Dialog details so that user can report it back to TPS)</li>
     *              <li>Notification: "Disconnected: Unexpected Error"</li>
     *              <li>TODO:(pv) Detect these:
     *                  <ul>
     *                  <li>APN/etc settings; "Disconnected: Check Data Settings"</li>
     *                  <li>Connection timeout; "Disconnected: Connection timeout"</li>
     *                  <li>SSL denied; "Disconnected: Server Not Secure"</li>
     *                  <li>SSL certificate: "Disconnected: Server Security Error"</li>
     *                  </ul>
     *              </li>
     *              </ul>
     *          </li>
     *          </ul>
     *          </p>
     *      </li>
     *      <li>{@link WtcStackProxyConnectException}: WtcStack failed to connect to a Proxy.
     *          <ul>
     *          <li>{@link WtcNetworkUnknownHostException}: Could not resolve or reach the server's address.
     *              <p>Can happen if the user enters a non-existing server address, if there is no network route to the address, or if the server doesn't respond.
     *              <ul>
     *              <li>Action: STOP (Go to Sign-In screen)</li>
     *              <li>Notification: "Disconnected: Proxy Unreachable"</li>
     *              </ul>
     *              </p>
     *          </li>
     *          <li>other Exception: unexpected/unhandled error
     *              <ul>
     *              <li>Action: STOP (Toast error so that user can report it back to TPS)</li>
     *              <li>Notification: "Disconnected: Unexpected Error"</li>
     *              <li>TODO:(pv) Detect these:
     *                  <ul>
     *                  <li>APN/etc settings; "Disconnected: Check Data Settings"</li>
     *                  <li>Connection timeout; "Disconnected: Connection timeout"</li>
     *                  </ul>
     *              </li>
     *              </ul>
     *          </li>
     *          </ul> 
     *      </li>
     *      <li>{@link WtcStackThreadException} [abstract]
     *          <ul>
     *          <li>{@link WtcStackThreadSendException}: WtcStack encountered an error while sending a WtcpMessage.
     *              <p>innerException gives more details</p>
     *              <ul>
     *              <li>Action: RECONNECT (if not closing or signing out)</li>
     *              <li>Notification: "Disconnected: Client Send Error"</li>
     *              </ul>
     *          </li>
     *          <li>{@link WtcStackThreadProcessReceivedMessagesException}: WtcStack encountered an error while processing a received WtcpMessage.
     *              <p>innerException gives more details</p>
     *              <ul>
     *              <li>Action: RECONNECT (if not closing or signing out)</li>
     *              <li>Notification: "Disconnected: Client Read Error"</li>
     *              </ul>
     *          </li>
     *          </ul>
     *      </li>
     *      <li>{@link WtcStackMessageRequestResponseTimeoutException}: WtcStack failed to receive a timely Response to a WtcpMessage Request.
     *          <ul>
     *          <li>Action: RECONNECT (if not closing or signing out)</li>
     *          <li>Notification: "Disconnected: Connection Timeout"</li>
     *          </ul>
     *      </li>
     *      <li>{@link WtcStackMessageReceiveException} [abstract]
     *          <ul>
     *          <li>{@link WtcStackMessageReceiveOverflowException}: WtcStack read more than the expected/maximum payload bytes, or more than WtcpHeader.MAX_PAYLOAD_LENGTH bytes.
     *              <ul>
     *              <li>Action: RECONNECT (if not closing or signing out)</li>
     *              <li>Notification: "Disconnected: Client Read Overflow"</li>
     *              </ul>
     *          </li>
     *          <li>{@link WtcStackMessageReceiveUnderflowException}: WtcStack read less than the expected/minimum payload bytes.
     *              <ul>
     *              <li>Action: RECONNECT (if not closing or signing out)</li>
     *              <li>Notification: "Disconnected: Client Read Underflow"</li>
     *              </ul>
     *          </li>          
     *          <li>{@link WtcStackMessageReceiveTypeUnknownException}: WtcStack encountered an unexpected WtcpMessageType.
     *              <ul>
     *              <li>Action: RECONNECT (if not closing or signing out)</li>
     *              <li>Notification: "Disconnected: Client Read Unknown"</li>
     *              </ul>
     *          </li>
     *          <li>{@link WtcStackMessageReceiveHeaderInvalidException}: WtcStack received an invalid WtcpHeader.
     *              <ul>
     *              <li>Action: RECONNECT (if not closing or signing out)</li>
     *              <li>Notification: "Disconnected: Client Read Invalid"</li>
     *              </ul>
     *          </li>
     *          <li>{@link WtcStackMessageReceiveResponseUnexpectedException}: WtcStack received an unexpected Response from the Proxy.
     *              <ul>
     *              <li>Action: RECONNECT (if not closing or signing out)</li>
     *              <li>Notification: "Disconnected: Client Read Unexpected"</li>
     *              </ul>
     *          </li>
     *          </ul>
     *      <li>{@link WtcStackUserProfilesEmptyException}: WAVE User has no Profiles.
     *          <ul>
     *          <li>Action: STOP (Go to Sign-In screen)</li>
     *          <li>Notification: "Disconnected: No Profiles"</li>
     *          </ul>
     *      </li>
     *      <li>{@link WtcStackSessionCloseException}: WtcStack processed a SessionClose message (both Solicited and Unsolicited).
     *          <ul>
     *          <li>Action: RECONNECT (if not closing or signing out)</li>
     *          <li>Notification: "Disconnected: Session Closed"</li>
     *          </ul>
     *      </li>
     *      <li>{@link WtcStackRemoteDisconnectException}: WtcStack detected that the remote Proxy closed the socket.
     *          <ul>
     *          <li>Action: RECONNECT (if not closing or signing out)</li>
     *          <li>Notification: "Disconnected: Connection Closed"</li>
     *          </ul>
     *      </li>
     *      </ul>
     * </li>
     * <li>{@link WtcSocketExceptionPlatform}: Expected when another thread interrupts a socket InputStream.read(...)
     *      <p>Should never happen, but could if there is a race condition during shutdown/disconnect.
     *      <ul>
     *      <li>Action: RECONNECT (if not closing or signing out)</li>
     *      <li>Notification: "Disconnected: Connection Interrupted"</li>
     *      </ul>
     *      </p>
     * </li>
     * <li>Any other unexpected/unhandled exception: ex: IllegalArgumentException, NullReferenceException, etc...
     *      <ul>
     *      <li>Action: STOP (Dialog details so that user can report it back to TPS)</li>
     *      <li>Notification: "Disconnected: Unexpected Error"</li>
     *      </ul>
     * </li>
     * </ul>
     * Action "STOP": The client app should return to a Sign-In screen.<br>
     * @param statistics {@link WtcConnectionStatistics} associated when the closed connection, or null
     */
    protected abstract void onDisconnected(//
                    WtcClient client, //
                    WtcInetSocketAddressPlatform proxyAddress, Exception exception, WtcConnectionStatistics statistics);

    /**
     * Fires *before* connecting to a WTC Locator, mostly used as a progress indicator.  
     * @param client
     * @param remoteAddress
     */
    protected abstract void onProxyLocating(//
                    WtcClient client, //
                    WtcUri remoteAddress);

    /**
     * Fires *after* successfully connecting to a WTC Locator and locating a WTC Proxy.   
     * @param client
     * @param proxyInfos The array of WtcProxyInfo found on the Locator.
     */
    protected abstract void onProxyLocated(//
                    WtcClient client, //
                    WtcProxyInfo[] proxyInfos);

    /**
     * Fires immediately *before* connecting to a WTC Proxy, mostly used as a progress indicator.
     * @param client
     * @param proxyAddress The address of the Proxy being connected to.
     */
    protected abstract void onProxyConnecting(//
                    WtcClient client, //
                    WtcInetSocketAddressPlatform proxyAddress);

    /**
     * Fires *after* successfully connecting to a WTC Proxy.
     * @param client
     * @param proxyInfo Meta info used to describe this Proxy connection. 
     * @param proxyAddress The actual socket address of the Proxy connected to.
     */
    protected abstract void onProxyConnected(//
                    WtcClient client, //
                    WtcProxyInfo proxyInfo, WtcInetSocketAddressPlatform proxyAddress);

    /**
     * Fires immediately *before* requesting a secure connection with the WTC Proxy.
     * @param client
     * @param kexSize A kexSize of WtcKexPrimeSize.NONE means that the session security has been disabled.
     */
    protected abstract void onProxySecuring(//
                    WtcClient client, //
                    int kexSize);

    /**
     * Fires *after* processing a WTC Proxy's response to a secure session request.
     * @param client
     * @param kexSize A kexSize of WtcKexPrimeSize.NONE means that the session security has been disabled.
     */
    protected abstract void onProxySecured(//
                    WtcClient client, //
                    int kexSize);

    /**
     * Fires when a media message is received; mostly used as a status indicator.
     * The WtcStack automatically routes the media to the Speaker.  
     * @param client
     * @param mediaHeader
     * @param payloadLength
     */
    protected abstract void onMessageReceivedMedia(//
                    WtcClient client, //
                    WtcpMediaHeader mediaHeader, int payloadLength);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode may be null, indicating no error (ie: success)
     * @param sessionId
     */
    protected abstract void onSessionResume(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode, String sessionId);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param sessionId session id that be be used in future "sendSessionResume" (not yet implemented).
     * @param serverTime UTC time on proxy as seconds elapsed since midnight, January 1, 1970. May be null when connected to older Proxies.
     * @param serverVersion Version of the proxy server connected to. May be null when connected to older Proxies.
     */
    protected abstract void onSessionOpen(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    String sessionId, WtcInt32 serverTime, WtcVersionString serverVersion);

    /**
     * Proxy returned an Error in response to a SessionOpen Request.
     * The Proxy may drop the connection after this event.
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode
     */
    protected abstract void onSessionOpenError(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode may be null, indicating no error (ie: success)
     */
    protected abstract void onSessionClose(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode);

    /**
     * Fired after either "getting" the profiles or "setting" the profile.
     * If profileIndex == -1, then this event occurred after *getting* the list of profiles and the listener should prompt the user for a profile in profiles.
     * The user only has a certain number of seconds (~10-60) to make this choice before the Proxy times out and drops the connection.
     * If the user takes too long to make a choice then a new connection can be made with the specified profile to bypass this prompt in the future.
     * 
     * If profileIndex != -1, then this event occurred after *setting* the profile to use.
     *  
     * @param client
     * @param opType
     * @param transactionId
     * @param localEndpointId The endpoint id of this user in all Channels. (NOTE: Currently always "1") 
     * @param profileIndex If -1, then the listener should prompt the user for a profile in profiles, otherwise the index of the profile used in profiles. 
     * @param profiles A list of the profiles available to the logged in user. It is up to the application to handle the case of no user profiles.
     * @param channels A list of the channels available in this profile; empty if the profile has not been set.
     * @param phoneLines A list of the user's WAVE phone lines; empty if the profile has not been set. 
     */
    protected abstract void onSetCredentials(
                    //
                    WtcClient client, //
                    int opType,
                    int transactionId, //
                    String localEndpointId, byte profileIndex, WtcpProfileInfoList profiles, WtcpChannelInfoList channels,
                    WtcpStringList phoneLines);

    /**
     * Proxy returned an Error in response to a SetCredentials Request.
     * The Proxy may drop the connection after this event.
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode
     * @param profiles a list of Profiles available to the user.
     */
    protected abstract void onSetCredentialsError(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode, WtcpProfileInfoList profiles);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param reconnect
     * @param change One of WtcpChannelChange
     * @param channelId
     */
    protected abstract void onChannelChange(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    boolean reconnect, int change, int channelId);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel 
     * @param channelActivity
     * @return true if handled and {@link #onChannelActivity(WtcClient, int, int, WtcClientChannel, int, WtcpEndpointInfoList)} should *NOT* be called
     */
    protected abstract boolean onChannelActivity(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel, WtcpChannelActivity channelActivity);

    /**
     * @deprecated Use {@link #onChannelActivity(WtcClient, int, int, WtcClientChannel, WtcpChannelActivity)}
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     * @param channelFlags
     * @param activityEndpoints
     */
    //@Deprecated
    protected abstract void onChannelActivity(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel, int channelFlags, WtcpEndpointInfoList activityEndpoints);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode
     */
    protected abstract void onChannelActivityError(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     */
    protected abstract void onChannelActivated(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     * @param errorCode may be null, indicating no error (ie: success)
     */
    protected abstract void onChannelDeactivated(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel, WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     */
    protected abstract void onChannelMuteOn(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     * @param errorCode may be null, indicating no error (ie: success)
     */
    protected abstract void onChannelMuteOff(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel, WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     */
    protected abstract void onChannelTalkStarted(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     * @param errorCode may be null, indicating no error (ie: success)
     */
    protected abstract void onChannelTalkStopped(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel, WtcpErrorCode errorCode);

    /**
     * properties are "Hashtable&lt;String,String&gt;":
     * <ul>
     * <li>private: prefixed with '@' - read/write<br>
     * <ul>
     * <li>"@V" = volume: "0.0" to "1.0"</li>
     * </ul>
     * </li>
     * <li>system: prefixed with '%' - read-only (cannot be set)<br>
     * <ul>
     * <li>"%T" = transmitable: "0" or "1"; 0 effectively means the channel is read-only</li>
     * <li>"%R" = receiveable: "0" or "1"; 0 effectively means the channel is *remotely* muted (ie: "gone dark")</li>
     * </ul>
     * </li>
     * <li>custom: similar to "system", but prefixed with "%custom." - read-only (cannot be set)</li>
     * <li>shared: not yet implemented on server</li>
     * </ul>
     * 
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     * @param keyValues
     */
    protected abstract void onChannelPropertiesGet(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel, WtcpKeyValueList keyValues);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     * @param errorCode
     */
    protected abstract void onChannelPropertiesGetError(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel, WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channel
     * @param errorCode
     */
    protected abstract void onChannelPropertiesSet(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientChannel channel, WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channelId
     * @param pageNumber
     * @param numberOfPages
     * @param endpoints
     */
    protected abstract void onEndpointLookup(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    int channelId, short pageNumber, short numberOfPages, WtcpEndpointInfoList endpoints);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param channelId
     * @param errorCode
     */
    protected abstract void onEndpointLookupError(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    int channelId, WtcpErrorCode errorCode);

    /**
     * Example endpointProperties.properties (Hashtable&lt;String,String&gt;):
     * <ul>
     * <li>key: <b>"LOC"</b><br>
     * schema (all fields are optional):<br>
     * "t={UTC YYYYMMDDHHMMSS},lo={longitude},la={latitude},a={altitude},v={velocity},h={heading},c={confidence},m={mode},s={satellite_count}"<br>
     * example:<br>
     * "t=20110603125959,lo=-122.35717829,la=47.61898809,a=-29.3,v=0.0,h=0.0"
     * </li>
     * <li>key: <b>"D"</b><br>
     * possible value(s):
     * <ul>
     * <li>"r": Ready/Available</li>
     * <li>"p": Phone</li>
     * <li>"a": Away</li>
     * <li>"b": Busy</li>
     * <li>"i": Idle</li>
     * <li>"t": Intercom</li>
     * <li>"u": Unknown</li>
     * </ul>
     * </li>
     * </ul>
     * @param client
     * @param opType
     * @param transactionId
     * @param keyValues
     */
    protected abstract void onEndpointPropertiesGet(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpEndpointProperties keyValues);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode
     */
    protected abstract void onEndpointPropertiesGetError(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode
     */
    protected abstract void onEndpointPropertiesSet(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode
     */
    protected abstract void onEndpointPropertyFilterSet(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode);

    /**
     * @param client
     * @param timeoutMs timeout requested
     * @param elapsedMs timeout actual
     * @param lastPingRequestTxId the previously Transmitted Ping Request PingId
     * @return the next Transmitted Ping Request PingId, or -1 if not TXed
     */
    protected abstract short onPingRequestRxTimeout(//
                    WtcClient client, //
                    long timeoutMs, long elapsedMs, short lastPingRequestTxId);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param pingId
     */
    protected abstract void onPing(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    short pingId);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneLine
     * @param errorCode may be null, indicating no error (ie: success)
     * @return true if handled and {@link #onPhoneLineSetActive(WtcClient, int, int, WtcpErrorCode)} should *NOT* be called
     */
    protected abstract boolean onPhoneLineActivating(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneLine phoneLine, WtcpErrorCode errorCode);

    /**
     * @deprecated Use {@link #onPhoneLineActivating}
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode
     */
    //@Deprecated
    protected abstract void onPhoneLineSetActive(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneLine
     * @return true if handled and {@link #onPhoneLineStatus(WtcClient, int, int, String, WtcpErrorCode)} should *NOT* be called
     */
    protected abstract boolean onPhoneLineActivated(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneLine phoneLine);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneLine
     * @param errorCode may be null, indicating no error (ie: success)
     * @return true if handled and {@link #onPhoneLineStatus(WtcClient, int, int, String, WtcpErrorCode)} should *NOT* be called
     */
    protected abstract boolean onPhoneLineDeactivated(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneLine phoneLine, WtcpErrorCode errorCode);

    /**
     * @deprecated Use {@link #onPhoneLineActivated} or {@link #onPhoneLineDeactivated}
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneLine
     * @param errorCode WtcpErrorCodes.OK: line is up, WtcpErrorCodes.PhoneLineUnavailable: line is down, WtcpErrorCodes.InvalidPhoneLine: you requested to activate a phone line that does not exist.
     */
    //@Deprecated
    protected abstract void onPhoneLineStatus(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    String phoneLine, WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @return true if handled and {@link #onCallMake(WtcClient, int, int, WtcpCallInfo)} should *NOT* be called
     */
    protected abstract boolean onCallMake(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param callType
     * @param phoneLine
     * @param remoteNumber
     * @param remoteName
     * @param errorCode
     * @return true if handled and {@link #onCallMake(WtcClient, int, int, WtcpCallInfo)} should *NOT* be called
     */
    protected abstract boolean onCallMakeError(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    byte callType, WtcClientPhoneLine phoneLine, //
                    String remoteNumber, String remoteName, //
                    WtcpErrorCode errorCode);

    /**
     * @deprecated Use {@link #onCallMake(WtcClient, int, int, WtcClientPhoneCall)}
     * @param client
     * @param opType
     * @param transactionId
     * @param callInfo
     */
    //@Deprecated
    protected abstract void onCallMake(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpCallInfo callInfo);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @return true if handled and {@link #onCallProgress(WtcClient, int, int, WtcpCallProgress)} should *NOT* be called
     */
    protected abstract boolean onCallProceeding(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @return true if handled and {@link #onCallProgress(WtcClient, int, int, WtcpCallProgress)} should *NOT* be called
     */
    protected abstract boolean onCallRinging(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @return true if handled and {@link #onCallProgress(WtcClient, int, int, WtcpCallProgress)} should *NOT* be called
     */
    protected abstract boolean onCallConnected(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall);

    /**
     * @deprecated Use {@link #onCallProceeding}, {@link #onCallRinging}, and {@link #onCallConnected}
     * @param client
     * @param opType
     * @param transactionId
     * @param callProgress
     */
    //@Deprecated
    protected abstract void onCallProgress(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpCallProgress callProgress);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @return true if handled and {@link #onCallOffer(WtcClient, int, int, WtcpCallOffer)} should *NOT* be called
     */
    protected abstract boolean onCallOffer(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall);

    /**
     * @deprecated Use {@link #onCallOffer(WtcClient, int, int, WtcClientPhoneCall)}
     * @param client
     * @param opType
     * @param transactionId
     * @param callOffer
     */
    //@Deprecated
    protected abstract void onCallOffer(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpCallOffer callOffer);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @return true if handled and {@link #onCallAnswer(WtcClient, int, int, WtcpCallAnswer)} should *NOT* be called
     */
    protected abstract boolean onCallAnswered(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @param errorCode
     * @return true if handled and {@link #onCallAnswer(WtcClient, int, int, WtcpCallAnswer)} should *NOT* be called
     */
    protected abstract boolean onCallAnswerError(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall, WtcpErrorCode errorCode);

    /**
     * @deprecated Use {@link #onCallAnswered}
     * @param client
     * @param opType
     * @param transactionId
     * @param callAnswer
     */
    //@Deprecated
    protected abstract void onCallAnswer(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpCallAnswer callAnswer);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @return true if handled and {@link #onCallHangup(WtcClient, int, int, WtcpCallHangup)} should *NOT* be called
     */
    protected abstract boolean onCallHangup(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall);

    /**
     * @deprecated Use {@link #onCallHangup(WtcClient, int, int, WtcClientPhoneCall)}
     * @param client
     * @param opType
     * @param transactionId
     * @param callHangup
     */
    //@Deprecated
    protected abstract void onCallHangup(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpCallHangup callHangup);

    /**
     * NOTE: Neat trick that this can be Unsolicited! 
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @param digits
     * @param errorCode null or OK for success
     * @return true if handled and {@link #onCallDtmf(WtcClient, int, int, WtcpErrorCode)} should *NOT* be called
     */
    protected abstract boolean onCallDtmf(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall, String digits, WtcpErrorCode errorCode);

    /**
     * NOTE: Neat trick that this can be Unsolicited! 
     * @deprecated Use {@link #onCallDtmf(WtcClient, int, int, WtcClientPhoneCall, String, WtcpErrorCode)}
     * @param client
     * @param opType
     * @param transactionId
     * @param errorCode null or OK for success
     */
    //@Deprecated
    protected abstract void onCallDtmf(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpErrorCode errorCode);

    /**
     * NOTE: Most definitely can be Unsolicited!<br>
     * Always a Success condition, Never an Error condition. 
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @param digits
     * @return true if handled and {@link #onCallDtmf(WtcClient, int, int, WtcpCallDtmf)} should *NOT* be called
     */
    protected abstract boolean onCallDtmf(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall, String digits);

    /**
     * NOTE: Most definitely can be Unsolicited!<br>
     * Always a Success condition, Never an Error condition. 
     * @deprecated Use {@link #onCallDtmf(WtcClient, int, int, WtcClientPhoneCall, String)}
     * @param client
     * @param opType
     * @param transactionId
     * @param callDtmf will be null if messageType == Response
     */
    //@Deprecated
    protected abstract void onCallDtmf(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcpCallDtmf callDtmf);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @param errorCode 
     * @return true if handled
     */
    protected abstract boolean onCallPushToTalkOn(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall, WtcpErrorCode errorCode);

    /**
     * Fired when the callId cannot be matched to a call in WtcClientPhoneCallManager
     * @param client
     * @param opType
     * @param transactionId
     * @param callId
     * @param errorCode
     * @return true if handled
     */
    protected abstract boolean onCallPushToTalkOn(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcInt32 callId, WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param phoneCall
     * @param errorCode
     * @return true if handled
     */
    protected abstract boolean onCallPushToTalkOff(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcClientPhoneCall phoneCall, WtcpErrorCode errorCode);

    /**
     * Fired when the callId cannot be matched to a call in WtcClientPhoneCallManager
     * @param client
     * @param opType
     * @param transactionId
     * @param callId
     * @param errorCode
     * @return true if handled
     */
    protected abstract boolean onCallPushToTalkOff(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcInt32 callId, WtcpErrorCode errorCode);

    /**
     * @param client
     * @param opType
     * @param transactionId
     * @param version
     * @param errorCode
     * @param addressBookInfoList
     */
    protected abstract void onAddressBook(//
                    WtcClient client, //
                    int opType, int transactionId, //
                    WtcInt16 version, WtcpErrorCode errorCode, WtcpAddressBookInfoList addressBookInfoList);
}
