package com.twistpair.wave.thinclient;

public class WtcClientChannelAction
{
    private boolean on     = false;
    private boolean oning  = false;
    private boolean offing = false;

    public boolean isAnyTrue()
    {
        return on || oning || offing;
    }

    public void setOning()
    {
        oning = true;
        offing = false;
    }

    public void setOffing()
    {
        oning = false;
        offing = true;
    }

    /**
     * 
     * @param on
     * @return the previous value of this.on
     */
    public boolean setOn(boolean on)
    {
        boolean previous = this.on;

        this.on = on;
        this.oning = false;
        this.offing = false;

        return previous;
    }

    public boolean isOn()
    {
        return on;
    }

    public boolean isOningOrOn()
    {
        return oning || on;
    }

    public boolean isOffing()
    {
        return offing;
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        if (on)
        {
            sb.append("on=").append(on);
        }
        if (oning)
        {
            if (on)
            {
                sb.append(',');
            }
            sb.append("oning=").append(oning);
        }
        if (offing)
        {
            if (on || oning)
            {
                sb.append(',');
            }
            sb.append("offing=").append(offing);
        }
        sb.append('}');
        return sb.toString();
    }
}
