package com.twilio.voice;

/*
 *  Copyright 2015 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

import java.util.Locale;

class ThreadUtils {
    public static class ThreadChecker {
        private final long threadId;

        public ThreadChecker(Thread thread) {
            this.threadId = thread.getId();
        }

        public void checkIsOnValidThread() {
            if (BuildConfig.DEBUG && threadId != Thread.currentThread().getId()) {
                throw new IllegalStateException(
                        String.format(
                                Locale.US,
                                "Wrong thread. Expected thread: %d, Actual thread: %d",
                                threadId,
                                Thread.currentThread().getId()));
            }
        }
    }
}
