package com.twilio.voice;

import androidx.annotation.Nullable;

/** {@link CallerInfo} is used to represent SHAKEN/STIR status information about the caller. */
public class CallerInfo {
    private Boolean isVerified = null;

    CallerInfo(String stirStatus) {
        isVerified =
                (stirStatus == null || (stirStatus.equals("null")))
                        ? null
                        : stirStatus.equals(VoiceConstants.TN_VALIDATION_PASSED_A) ? true : false;
    }

    /**
     * Returns `true` if the caller has been validated at 'A' level, `false` if the caller has been
     * verified at any lower level or has failed validation. Returns `null` if no caller
     * verification information is available or if stir status value is `null`.
     */
    @Nullable
    public Boolean isVerified() {
        return isVerified;
    }
}
