package com.twilio.voice;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * AudioDeviceCapturer interface provides the mechanism to define a custom audio device capturer.
 */
public interface AudioDeviceCapturer {
    /**
     * Returns the format of the audio that will be captured. Returning `null` indicates capturing
     * is not supported.
     *
     * @return {@link com.twilio.voice.AudioFormat}
     */
    @Nullable
    AudioFormat getCapturerFormat();

    /**
     * Raised when the capturer is ready to be initialized. This method is called before {@link
     * #onStartCapturing(AudioDeviceContext)}.
     *
     * @return A boolean value to indicate if initialization was successful.
     */
    boolean onInitCapturer();

    /**
     * Raised when the capturer is ready to capture. This method is called after {@link
     * #onInitCapturer()}.
     *
     * @param audioDeviceContext
     * @return A boolean value that indicates if capturing has started or not.
     */
    boolean onStartCapturing(@NonNull AudioDeviceContext audioDeviceContext);

    /**
     * Raised when the capturer stops capturing. This method is called some time after {@link
     * #onStartCapturing(AudioDeviceContext)} when audio capturing is no longer needed by the media
     * engine.
     *
     * @return A boolean value that indicates if capturing has stopped or not.
     */
    boolean onStopCapturing();
}
