package com.twilio.video;

import java.util.Map;

/**
 * Configures the mode for specifying content preferences for the {@link RemoteVideoTrack}. When set
 * to {@link #AUTO} the SDK determines the render dimensions by inspecting the attached view({@link
 * VideoView} or {@link VideoTextureView}). {@link RemoteVideoTrack}s rendered in smaller views will
 * receive a lower resolution stream compared to the video rendered in larger views. When set to
 * {@link #MANUAL} you can set the dimensions programmatically by calling {@link
 * RemoteVideoTrack#setContentPreferences(VideoContentPreferences)}. This feature supersedes the
 * {@link VideoBandwidthProfileOptions.Builder#renderDimensions(Map)} setter. Attempting to set
 * {@link
 * VideoBandwidthProfileOptions.Builder#videoContentPreferencesMode(VideoContentPreferencesMode)}
 * when {@link VideoBandwidthProfileOptions.Builder#renderDimensions(Map)} is already set will throw
 * an exception.
 */
public enum VideoContentPreferencesMode {

    /**
     * The SDK specifies content preferences based on video view size. A {@link RemoteVideoTrack}
     * rendered by a view({@link VideoView} or {@link VideoTextureView}) with larger dimensions will
     * get a higher quality video compared to a RemoteVideoTrack rendered by a VideoView or
     * VideoTextureView with smaller dimensions.
     */
    AUTO,
    /**
     * The application specifies the content preferences for individual tracks using {@link
     * RemoteVideoTrack#setContentPreferences(VideoContentPreferences)}
     */
    MANUAL
}
