package com.twilio.video;

import androidx.annotation.NonNull;

public abstract class RemoteTrackStats extends BaseTrackStats {
    /** Total number of bytes received */
    public final long bytesReceived;

    /** Total number of packets received */
    public final int packetsReceived;

    protected RemoteTrackStats(
            @NonNull String trackSid,
            int packetsLost,
            @NonNull String codec,
            @NonNull String ssrc,
            double timestamp,
            long bytesReceived,
            int packetsReceived) {
        super(trackSid, packetsLost, codec, ssrc, timestamp);
        this.bytesReceived = bytesReceived;
        this.packetsReceived = packetsReceived;
    }
}
