package com.twilio.video;

import tvi.webrtc.CapturerObserver;

/**
 * A VideoFrameProcessor is an interface that allows for custom video frame processors to be
 * created. A VideoFrameProcessor can be attached to either a {@link
 * com.twilio.video.CameraCapturer} or a {@link com.twilio.video.Camera2Capturer} capturer at the
 * time of construction via two new constructors. Every frame captured by the c{@link
 * com.twilio.video.CameraCapturer} or {@link com.twilio.video.Camera2Capturer} is passed to the
 * onFrame method prior to being sent to the underlying system for encoding.
 */
public interface VideoFrameProcessor {
    /**
     * Invoked when the capturer has started. This method is invoked on the same thread as the
     * onFrame() method and shall contain an OpenGLES context associated with it.
     */
    void onCaptureStarted();

    /**
     * Invoked when the capturer has Stopped. This method is invoked on the same thread as the
     * onFrame() method and shall contain an OpenGLES context associated with it.
     */
    void onCaptureStoped();

    /**
     * Invoked upon the capturing of each frame and the thread from which it is invoked on shall
     * contain an OpenGLES context. The implementation of this method must pass the resultant output
     * frame to the capturerObserver once processing on the frame is complete.
     *
     * @param videoFrame the captured video frame
     * @param capturerObserver the interface to pass the resultant processed frame to the underlying
     *     system.
     */
    void onFrame(tvi.webrtc.VideoFrame videoFrame, CapturerObserver capturerObserver);
}
