package com.twilio.video;

import androidx.annotation.Nullable;

class SinkHints {
    private final long sinkId;
    @Nullable private final Boolean enabled;
    @Nullable private final VideoContentPreferences videoContentPreferences;

    SinkHints(
            long sinkId,
            @Nullable Boolean enabled,
            @Nullable VideoContentPreferences videoContentPreferences) {
        this.enabled = enabled;
        this.sinkId = sinkId;
        this.videoContentPreferences = videoContentPreferences;
    }

    long getSinkId() {
        return sinkId;
    }

    @Nullable
    Boolean isEnabled() {
        return enabled;
    }

    @Nullable
    VideoContentPreferences getVideoContentPreferences() {
        return videoContentPreferences;
    }

    @Override
    public String toString() {
        return "SinkHints{"
                + "sinkId="
                + sinkId
                + ", enabled="
                + enabled
                + ", videoContentPreferences="
                + videoContentPreferences
                + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SinkHints sinkHints = (SinkHints) o;

        if (sinkId != sinkHints.sinkId) return false;
        if (enabled != sinkHints.enabled) return false;
        return videoContentPreferences != null
                ? videoContentPreferences.equals(sinkHints.videoContentPreferences)
                : sinkHints.videoContentPreferences == null;
    }

    @Override
    public int hashCode() {
        int result = (int) (sinkId ^ (sinkId >>> 32));
        result = 31 * result + (enabled ? 1 : 0);
        result =
                31 * result
                        + (videoContentPreferences != null
                                ? videoContentPreferences.hashCode()
                                : 0);
        return result;
    }
}
