/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.AccessedByNative;
import com.twilio.video.ConnectOptions;
import com.twilio.video.LocalParticipant;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Preconditions;
import com.twilio.video.RemoteParticipant;
import com.twilio.video.StatsListener;
import com.twilio.video.StatsReport;
import com.twilio.video.ThreadChecker;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import com.twilio.video.Video;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import tvi.webrtc.voiceengine.WebRtcAudioManager;

public class Room {
    private static final Logger logger = Logger.getLogger(Room.class);
    private static final Field blacklistDeviceForOpenSLESUsageField;
    private static final Field blacklistDeviceForOpenSLESUsageIsOverriddenField;
    private long nativeRoomDelegate;
    private Context context;
    private String name;
    private String sid;
    private String mediaRegion = null;
    private State state;
    private Map<String, RemoteParticipant> participantMap = new HashMap<String, RemoteParticipant>();
    private LocalParticipant localParticipant;
    private RemoteParticipant dominantSpeaker;
    private final Listener listener;
    private final Handler handler;
    private Queue<Pair<Handler, StatsListener>> statsListenersQueue;
    private MediaFactory mediaFactory;
    private final Listener roomListenerProxy = new Listener(){

        @Override
        @AccessedByNative
        public void onConnected(@NonNull Room room) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onConnected()");
                Room.this.listener.onConnected(room);
            });
        }

        @Override
        @AccessedByNative
        public void onConnectFailure(@NonNull Room room, @NonNull TwilioException twilioException) {
            Room.this.releaseRoom();
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onConnectFailure()");
                Room.this.state = State.DISCONNECTED;
                Room.this.release();
                Room.this.listener.onConnectFailure(room, twilioException);
            });
        }

        @Override
        @AccessedByNative
        public void onReconnecting(@NonNull Room room, @NonNull TwilioException twilioException) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onReconnecting()");
                Room.this.state = State.RECONNECTING;
                Room.this.listener.onReconnecting(room, twilioException);
            });
        }

        @Override
        @AccessedByNative
        public void onReconnected(@NonNull Room room) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onReconnected()");
                Room.this.state = State.CONNECTED;
                Room.this.listener.onReconnected(room);
            });
        }

        @Override
        @AccessedByNative
        public void onDisconnected(@NonNull Room room, @Nullable TwilioException twilioException) {
            Room.this.releaseRoom();
            if (Room.this.localParticipant != null) {
                Room.this.localParticipant.release();
            }
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onDisconnected()");
                Room.this.state = State.DISCONNECTED;
                Room.this.release();
                Room.this.listener.onDisconnected(room, twilioException);
            });
        }

        @Override
        @AccessedByNative
        public void onParticipantConnected(@NonNull Room room, @NonNull RemoteParticipant participant) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onParticipantConnected()");
                Room.this.participantMap.put(participant.getSid(), participant);
                Room.this.listener.onParticipantConnected(room, participant);
            });
        }

        @Override
        @AccessedByNative
        public void onParticipantDisconnected(@NonNull Room room, @NonNull RemoteParticipant remoteParticipant) {
            remoteParticipant.release();
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onParticipantDisconnected()");
                Room.this.participantMap.remove(remoteParticipant.getSid());
                Room.this.listener.onParticipantDisconnected(room, remoteParticipant);
            });
        }

        @Override
        @AccessedByNative
        public void onDominantSpeakerChanged(@NonNull Room room, @Nullable RemoteParticipant remoteParticipant) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onDominantSpeakerChanged()");
                Room.this.dominantSpeaker = remoteParticipant;
                Room.this.listener.onDominantSpeakerChanged(room, remoteParticipant);
            });
        }

        @Override
        @AccessedByNative
        public void onRecordingStarted(@NonNull Room room) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onRecordingStarted()");
                Room.this.listener.onRecordingStarted(room);
            });
        }

        @Override
        @AccessedByNative
        public void onRecordingStopped(@NonNull Room room) {
            Room.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(Room.this.handler);
                logger.d("onRecordingStopped()");
                Room.this.listener.onRecordingStopped(room);
            });
        }
    };
    private final StatsListener statsListenerProxy = new StatsListener(){

        @Override
        @AccessedByNative
        public void onStats(@NonNull List<StatsReport> statsReports) {
            Pair statsPair = (Pair)Room.this.statsListenersQueue.poll();
            if (statsPair != null) {
                ((Handler)statsPair.first).post(() -> ((StatsListener)statsPair.second).onStats(statsReports));
            }
        }
    };

    Room(@NonNull Context context, @NonNull String name, @NonNull Handler handler, @NonNull Listener listener) {
        this.context = context;
        this.name = name;
        this.sid = "";
        this.state = State.DISCONNECTED;
        this.listener = listener;
        this.handler = handler;
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
        Room.configureOpenSLES();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getSid() {
        return this.sid;
    }

    @Nullable
    public String getMediaRegion() {
        return this.mediaRegion;
    }

    @NonNull
    public synchronized State getState() {
        return this.state;
    }

    @Nullable
    public RemoteParticipant getDominantSpeaker() {
        return this.dominantSpeaker;
    }

    public synchronized boolean isRecording() {
        return this.state == State.CONNECTED && this.nativeIsRecording(this.nativeRoomDelegate);
    }

    @NonNull
    public synchronized List<RemoteParticipant> getRemoteParticipants() {
        return new ArrayList<RemoteParticipant>(this.participantMap.values());
    }

    @Nullable
    public synchronized LocalParticipant getLocalParticipant() {
        return this.localParticipant;
    }

    public synchronized void getStats(@NonNull StatsListener statsListener) {
        Preconditions.checkNotNull(statsListener, "StatsListener must not be null");
        if (this.state == State.DISCONNECTED) {
            return;
        }
        this.statsListenersQueue.offer((Pair<Handler, StatsListener>)new Pair((Object)Util.createCallbackHandler(), (Object)statsListener));
        this.nativeGetStats(this.nativeRoomDelegate);
    }

    public synchronized void disconnect() {
        if (this.state != State.DISCONNECTED && this.nativeRoomDelegate != 0L) {
            if (this.localParticipant != null) {
                this.localParticipant.release();
            }
            this.nativeDisconnect(this.nativeRoomDelegate);
        }
    }

    void onNetworkChanged(Video.NetworkChangeEvent networkChangeEvent) {
        if (this.nativeRoomDelegate != 0L) {
            this.nativeOnNetworkChange(this.nativeRoomDelegate, networkChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    void connect(@NonNull ConnectOptions connectOptions) {
        ConnectOptions.checkAudioTracksReleased(connectOptions.getAudioTracks());
        ConnectOptions.checkVideoTracksReleased(connectOptions.getVideoTracks());
        Listener listener = this.roomListenerProxy;
        synchronized (listener) {
            this.mediaFactory = connectOptions.getMediaFactory() == null ? MediaFactory.instance(this, this.context) : connectOptions.getMediaFactory();
            this.nativeRoomDelegate = this.nativeConnect(connectOptions, this.roomListenerProxy, this.statsListenerProxy, this.mediaFactory.getNativeMediaFactoryHandle(), this.handler);
            this.state = State.CONNECTING;
        }
    }

    @VisibleForTesting
    static void configureOpenSLES() {
        if (!Room.openSLESEnabled()) {
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)true);
        }
    }

    @VisibleForTesting
    static boolean openSLESEnabled() {
        try {
            return (Boolean)blacklistDeviceForOpenSLESUsageField.get(null) == false && (Boolean)blacklistDeviceForOpenSLESUsageIsOverriddenField.get(null) != false;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine if OpenSLES is enabled.");
        }
    }

    @AccessedByNative
    private synchronized void setConnected(String roomSid, String mediaRegion, LocalParticipant localParticipant, List<RemoteParticipant> remoteParticipants) {
        logger.d("setConnected()");
        this.sid = roomSid;
        String string = this.mediaRegion = mediaRegion.isEmpty() ? null : mediaRegion;
        if (this.name == null || this.name.isEmpty()) {
            this.name = roomSid;
        }
        this.localParticipant = localParticipant;
        for (RemoteParticipant remoteParticipant : remoteParticipants) {
            this.participantMap.put(remoteParticipant.getSid(), remoteParticipant);
        }
        this.state = State.CONNECTED;
    }

    private synchronized void releaseRoom() {
        if (this.nativeRoomDelegate != 0L) {
            for (RemoteParticipant remoteParticipant : this.participantMap.values()) {
                remoteParticipant.release();
            }
            this.nativeReleaseRoom(this.nativeRoomDelegate);
            this.cleanupStatsListenerQueue();
        }
    }

    private synchronized void release() {
        ThreadChecker.checkIsValidThread(this.handler);
        if (this.nativeRoomDelegate != 0L) {
            this.nativeRelease(this.nativeRoomDelegate);
            this.nativeRoomDelegate = 0L;
            this.mediaFactory.release(this);
        }
    }

    private void cleanupStatsListenerQueue() {
        for (Pair pair : this.statsListenersQueue) {
            ((Handler)pair.first).post(() -> ((StatsListener)listenerPair.second).onStats(new ArrayList<StatsReport>()));
        }
        this.statsListenersQueue.clear();
    }

    private native long nativeConnect(ConnectOptions var1, Listener var2, StatsListener var3, long var4, Handler var6);

    private native boolean nativeIsRecording(long var1);

    private native void nativeGetStats(long var1);

    private native void nativeOnNetworkChange(long var1, Video.NetworkChangeEvent var3);

    private native void nativeDisconnect(long var1);

    private native void nativeReleaseRoom(long var1);

    private native void nativeRelease(long var1);

    static {
        try {
            blacklistDeviceForOpenSLESUsageField = WebRtcAudioManager.class.getDeclaredField("blacklistDeviceForOpenSLESUsage");
            blacklistDeviceForOpenSLESUsageIsOverriddenField = WebRtcAudioManager.class.getDeclaredField("blacklistDeviceForOpenSLESUsageIsOverridden");
            blacklistDeviceForOpenSLESUsageField.setAccessible(true);
            blacklistDeviceForOpenSLESUsageIsOverriddenField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static enum State {
        CONNECTING,
        CONNECTED,
        RECONNECTING,
        DISCONNECTED;

    }

    public static interface Listener {
        public void onConnected(@NonNull Room var1);

        public void onConnectFailure(@NonNull Room var1, @NonNull TwilioException var2);

        public void onReconnecting(@NonNull Room var1, @NonNull TwilioException var2);

        public void onReconnected(@NonNull Room var1);

        public void onDisconnected(@NonNull Room var1, @Nullable TwilioException var2);

        public void onParticipantConnected(@NonNull Room var1, @NonNull RemoteParticipant var2);

        public void onParticipantDisconnected(@NonNull Room var1, @NonNull RemoteParticipant var2);

        default public void onDominantSpeakerChanged(@NonNull Room room, @Nullable RemoteParticipant remoteParticipant) {
            logger.d("onDominantSpeakerChanged");
        }

        public void onRecordingStarted(@NonNull Room var1);

        public void onRecordingStopped(@NonNull Room var1);
    }
}

