/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import com.twilio.video.AccessedByNative;
import com.twilio.video.AudioTrack;
import com.twilio.video.Logger;

@AccessedByNative
public class RemoteAudioTrack
extends AudioTrack {
    private static final Logger logger = Logger.getLogger(RemoteAudioTrack.class);
    private long nativeRemoteAudioTrackHandle;
    private final String sid;
    private boolean playbackEnabled;

    @AccessedByNative
    RemoteAudioTrack(long nativeRemoteAudioTrackHandle, @NonNull String sid, @NonNull String name, boolean isEnabled) {
        super(nativeRemoteAudioTrackHandle, isEnabled, name);
        this.nativeRemoteAudioTrackHandle = nativeRemoteAudioTrackHandle;
        this.sid = sid;
        this.playbackEnabled = true;
    }

    @NonNull
    public String getSid() {
        return this.sid;
    }

    public synchronized void enablePlayback(boolean enable) {
        this.playbackEnabled = enable;
        if (!this.isReleased()) {
            this.nativeEnablePlayback(this.nativeRemoteAudioTrackHandle, enable);
        } else {
            logger.w("Cannot enable playback of remote audio track that is no longer subscribed to");
        }
    }

    public synchronized boolean isPlaybackEnabled() {
        return this.playbackEnabled;
    }

    @Override
    synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeRemoteAudioTrackHandle);
            this.nativeRemoteAudioTrackHandle = 0L;
        }
    }

    @Override
    boolean isReleased() {
        return this.nativeRemoteAudioTrackHandle == 0L;
    }

    private native void nativeEnablePlayback(long var1, boolean var3);

    private native void nativeRelease(long var1);
}

