/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.twilio.video.I420Frame;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Track;
import com.twilio.video.VideoRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tvi.webrtc.VideoRenderer;

public abstract class VideoTrack
implements Track {
    private static final Logger logger = Logger.getLogger(VideoTrack.class);
    private Map<VideoRenderer, tvi.webrtc.VideoRenderer> videoRenderersMap = new HashMap<VideoRenderer, tvi.webrtc.VideoRenderer>();
    private final tvi.webrtc.VideoTrack webRtcVideoTrack;
    private final String name;
    private boolean isEnabled;
    private boolean isReleased = false;

    VideoTrack(@NonNull tvi.webrtc.VideoTrack webRtcVideoTrack, boolean enabled, @NonNull String name) {
        this.isEnabled = enabled;
        this.name = name;
        this.webRtcVideoTrack = webRtcVideoTrack;
    }

    public synchronized void addRenderer(@NonNull VideoRenderer videoRenderer) {
        Preconditions.checkNotNull(videoRenderer, "Video renderer must not be null");
        if (!this.isReleased) {
            tvi.webrtc.VideoRenderer webrtcVideoRenderer = this.createWebRtcVideoRenderer(videoRenderer);
            this.videoRenderersMap.put(videoRenderer, webrtcVideoRenderer);
            if (this.webRtcVideoTrack != null) {
                this.webRtcVideoTrack.addRenderer(webrtcVideoRenderer);
            }
        } else {
            logger.w("Attempting to add renderer to track that has been removed");
        }
    }

    public synchronized void removeRenderer(@NonNull VideoRenderer videoRenderer) {
        Preconditions.checkNotNull(videoRenderer, "Video renderer must not be null");
        if (!this.isReleased) {
            tvi.webrtc.VideoRenderer webrtcVideoRenderer = this.videoRenderersMap.remove(videoRenderer);
            if (this.webRtcVideoTrack != null && webrtcVideoRenderer != null) {
                this.webRtcVideoTrack.removeRenderer(webrtcVideoRenderer);
            }
        } else {
            logger.w("Attempting to remove renderer from track that has been removed");
        }
    }

    @NonNull
    public synchronized List<VideoRenderer> getRenderers() {
        return new ArrayList<VideoRenderer>(this.videoRenderersMap.keySet());
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    synchronized void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    synchronized void release() {
        if (!this.isReleased) {
            this.invalidateWebRtcTrack();
            this.videoRenderersMap.clear();
            this.isReleased = true;
        }
    }

    synchronized boolean isReleased() {
        return this.isReleased;
    }

    synchronized void invalidateWebRtcTrack() {
        if (this.webRtcVideoTrack != null) {
            for (Map.Entry<VideoRenderer, tvi.webrtc.VideoRenderer> entry : this.videoRenderersMap.entrySet()) {
                this.webRtcVideoTrack.removeRenderer(entry.getValue());
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    synchronized tvi.webrtc.VideoTrack getWebRtcTrack() {
        return this.webRtcVideoTrack;
    }

    private tvi.webrtc.VideoRenderer createWebRtcVideoRenderer(VideoRenderer videoRenderer) {
        return new tvi.webrtc.VideoRenderer((VideoRenderer.Callbacks)new VideoRendererCallbackAdapter(videoRenderer));
    }

    private class VideoRendererCallbackAdapter
    implements VideoRenderer.Callbacks {
        private final VideoRenderer videoRenderer;

        VideoRendererCallbackAdapter(VideoRenderer videoRenderer) {
            this.videoRenderer = videoRenderer;
        }

        public void renderFrame(VideoRenderer.I420Frame frame) {
            this.videoRenderer.renderFrame(new I420Frame(frame));
        }
    }
}

